package org.eaglei.datatools.etl.server;

/**
 * @author Sravan Kumar Cheriyala
 * This class has services related to repository
 */
import java.io.File;
import java.io.StringWriter;
import java.net.URL;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.datatools.config.DatatoolsConfiguration;
import org.eaglei.datatools.jena.EIInstanceFactory;
import org.eaglei.datatools.jena.RESTRepositoryProvider;
import org.eaglei.datatools.jena.RESTRepositoryProviderFactory;
import org.eaglei.datatools.provider.RepositoryProvider;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIURI;

import com.hp.hpl.jena.rdf.model.Model;

public class RDFtoRepoService {
	private static RDFtoRepoService	instance				= null;
	private DatatoolsConfiguration	config;
	RESTRepositoryProvider			repoProvider;
	private static final String		DEFAULT_CONFIGURATION	= "etl-datatools.prop";
	private static final Log		logger					= LogFactory.getLog(RDFtoRepoService.class);
	private String					token;
	private RDFtoRepoService(String file) throws Exception {
		config = getConfiguration(file);
		repoProvider = (RESTRepositoryProvider) new RESTRepositoryProviderFactory().createRepositoryProvider(config);
	}
	private RDFtoRepoService() throws Exception {
		config = getConfiguration();
		repoProvider = (RESTRepositoryProvider) new RESTRepositoryProviderFactory().createRepositoryProvider(config);
	}
	public RepositoryProvider getRepositoryProvider() {
		return repoProvider;
	}
	public DatatoolsConfiguration getDatatoolsConfiguration() {
		return config;
	}
	/* removed sigleton logic */
	public static RDFtoRepoService getInstance(String file) throws Exception {
		if (instance == null) {
			instance = new RDFtoRepoService(file);
		}
		return instance;
	}
	public static RDFtoRepoService getInstance() throws Exception {
		if (instance == null) {
			instance = new RDFtoRepoService();
		}
		return instance;
	}

	/**
	 * pushed the Model to Repo and promotes it
	 * 
	 * @param rdfModel
	 * @param session
	 * @param uri
	 * @return
	 * @throws Exception
	 */
	public boolean pushtoRepo(Model rdfModel, String session, String uri, String promoteParameter) throws Exception {
		StringWriter swriter = new StringWriter();
		rdfModel.write(swriter, "RDF/XML");
		repoProvider.createInstance(session, swriter.toString(), uri);
		token = repoProvider.updateInstance(session, swriter.toString(), uri, null);
		repoProvider.updateInstance(session, swriter.toString(), uri, token);
		if (promoteParameter.equalsIgnoreCase("publish")) {
			repoProvider.promote(session, uri, "http://eagle-i.org/ont/repo/1.0/WFS_Curation");
			repoProvider.promote(session, uri, "http://eagle-i.org/ont/repo/1.0/WFS_Published");
		} else {
			repoProvider.promote(session, uri, "http://eagle-i.org/ont/repo/1.0/WFS_Curation");
		}
		return true;
	}
	
	
	
	/**
	 * gets the new instance from Repo
	 * 
	 * @param countofInstances
	 * @return
	 * @throws Exception
	 */
	public List<EIURI> getNewInstancesFromRepo(String session,int countofInstances) throws Exception {
		return repoProvider.getNewInstanceID(session, countofInstances);
	}
	public RepositoryProvider setPropertyFilePathAndgetNewRepoProvider(final String configFilePath) throws Exception {
		final File configFile = new File(configFilePath);
		logger.debug("loading configuration file: " + configFile);
		config = new DatatoolsConfiguration(configFile);
		repoProvider = (RESTRepositoryProvider) new RESTRepositoryProviderFactory().createRepositoryProvider(config);
		return repoProvider;
	}
	/**
	 * get the configuration object by the String as path to file
	 * 
	 * @param DEFAULT_CONFIGURATION
	 * @return
	 * @throws Exception
	 */
	private DatatoolsConfiguration getConfiguration(final String DEFAULT_CONFIGURATION) throws Exception {
		// final URL configURL =
		// this.getClass().getClassLoader().getResource(DEFAULT_CONFIGURATION);
		/*
		 * if (configURL == null) { logger.error("Could not locate " +
		 * DEFAULT_CONFIGURATION + " on classpath"); throw new
		 * Exception("Could not locate " + DEFAULT_CONFIGURATION +
		 * " on classpath"); }
		 */
		try {
			final File configFile = new File(DEFAULT_CONFIGURATION);
			logger.debug("loading configuration file: " + configFile);
			return new DatatoolsConfiguration(configFile);
		} catch (Exception e) {
			logger.error("Error loading configuration from " + DEFAULT_CONFIGURATION + " " + e);
			throw new Exception(e);
		}
	}
	/**
	 * get the Configuration of default ETL properties file
	 * 
	 * @return
	 * @throws Exception
	 */
	private DatatoolsConfiguration getConfiguration() throws Exception {
		final URL configURL = this.getClass().getClassLoader().getResource(DEFAULT_CONFIGURATION);
		if (configURL == null) {
			logger.error("Could not locate " + DEFAULT_CONFIGURATION + " on classpath");
			throw new Exception("Could not locate " + DEFAULT_CONFIGURATION + " on classpath");
		}
		try {
			final File configFile = new File(configURL.toURI());
			logger.debug("loading configuration file: " + configFile);
			return new DatatoolsConfiguration(configFile);
		} catch (Exception e) {
			logger.error("Error loading configuration from " + DEFAULT_CONFIGURATION + " " + e);
			throw new Exception(e);
		}
	}
}
