/*
 * The MIT License
 *
 * Copyright 2007 Lushan Han and UMBC Ebiquity Research Group.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to
 * deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

package org.eaglei.datatools.etl.utils;

import java.util.Map;
import javax.swing.table.DefaultTableModel;

public class Rdf123Expression {
	private String expression;
	private int curIndex;
	private int nextIndex;
	private String token;
	private String lookAhead;
	private String outdate;
	private String output;
	DefaultTableModel tableModel;
	int row;
	private Map prefixMap = null;
	int startCol;
	private String baseURI;
	static private boolean error_tolerate = false;

	public Rdf123Expression(DefaultTableModel model, Map map, int startColumn,
			String base) {
		super();
		tableModel = model;
		prefixMap = map;
		startCol = startColumn;
		baseURI = base;
		// TODO Auto-generated constructor stub
	}

	public String nextToken() {
		if (curIndex >= expression.length())
			return "EOF";

		if (expression.charAt(curIndex) == '\'') {
			nextIndex = expression.indexOf('\'', curIndex + 1);
			if (nextIndex != -1) {
				token = expression.substring(curIndex, nextIndex + 1);
				curIndex = nextIndex + 1;
				return token;
			} else {
				token = expression.substring(curIndex);
				curIndex = expression.length();
				return token;
			}

		} else if (expression.charAt(curIndex) == '<'
				&& expression.charAt(curIndex + 1) == '>') {
			curIndex += 2;
			return "<>";

		} else if (expression.charAt(curIndex) == '!'
				&& expression.charAt(curIndex + 1) == '=') {
			curIndex += 2;
			return "!=";

		} else if (expression.charAt(curIndex) == '?') {
			curIndex++;
			return "?";

		} else if (expression.charAt(curIndex) == '@') {
			if (expression.substring(curIndex).startsWith("@If(")) {
				curIndex += 4;
				return "@If(";
			} else if (expression.substring(curIndex).startsWith("@IsEmpty(")) {
				curIndex += 9;
				return "@IsEmpty(";
			} else if (expression.substring(curIndex).startsWith("@Add(")) {
				curIndex += 5;
				return "@Add(";
			} else if (expression.substring(curIndex).startsWith("@Sub(")) {
				curIndex += 5;
				return "@Sub(";
			} else if (expression.substring(curIndex).startsWith("@Length(")) {
				curIndex += 8;
				return "@Length(";
			} else if (expression.substring(curIndex).startsWith("@IndexOf(")) {
				curIndex += 9;
				return "@IndexOf(";
			} else if (expression.substring(curIndex).startsWith("@Substr(")) {
				curIndex += 8;
				return "@Substr(";
			} else {
				int next = indexOfNextToken(curIndex + 1);
				String token = expression.substring(curIndex, next);
				curIndex = next;
				return token;
				// curIndex++;
				// return "@";
			}
		} else if (expression.charAt(curIndex) == ')') {
			curIndex++;
			return ")";
		} else if (expression.charAt(curIndex) == ';') {
			curIndex++;
			return ";";
		} else if (expression.charAt(curIndex) == ',') {
			curIndex++;
			return ",";
		} else if (expression.charAt(curIndex) == '+') {
			curIndex++;
			return "+";
		} else if (expression.charAt(curIndex) == ' ') {
			curIndex++;
			return " ";
		} else if (expression.charAt(curIndex) == '(') {
			curIndex++;
			return "(";
		} else if (expression.charAt(curIndex) == '=') {
			curIndex++;
			return "=";
		} else {
			nextIndex = curIndex;
			while (nextIndex < expression.length()
					&& expression.charAt(nextIndex) != '@'
					&& expression.charAt(nextIndex) != ')'
					&& expression.charAt(nextIndex) != '('
					&& expression.charAt(nextIndex) != ';'
					&& expression.charAt(nextIndex) != ','
					&& expression.charAt(nextIndex) != '+'
					&& expression.charAt(nextIndex) != '<'
					&& expression.charAt(nextIndex) != '?'
					&& expression.charAt(nextIndex) != '='
					&& expression.charAt(nextIndex) != '!'
					&& expression.charAt(nextIndex) != ' '
					&& expression.charAt(nextIndex) != '\'') {
				nextIndex++;
			}
			token = expression.substring(curIndex, nextIndex);
			curIndex = nextIndex;
			return token;
		}
	}

	private int indexOfNextToken(int current) {

		int next = current;

		while (next < expression.length() && expression.charAt(next) != '@'
				&& expression.charAt(next) != ')'
				&& expression.charAt(next) != '('
				&& expression.charAt(next) != ';'
				&& expression.charAt(next) != ','
				&& expression.charAt(next) != '+'
				&& expression.charAt(next) != '<'
				&& expression.charAt(next) != '?'
				&& expression.charAt(next) != '='
				&& expression.charAt(next) != '!'
				&& expression.charAt(next) != ' '
				&& expression.charAt(next) != '\'') {

			next++;
		}

		return next;
	}

	private void match(String t) throws Exception {
		if (lookAhead.equals(t)) {
			lookAhead = this.nextToken();
			output += lookAhead;
		} else
			// throw new Exception("Parse Error: (" + output +
			// ") Not expected '" + lookAhead + "' at index " + curIndex +
			// " of the expression " + expression);
			throw new Exception("Parse error found at index " + curIndex
					+ " :    '" + lookAhead
					+ "' is not expected in the expression "
					+ expression.substring(0, curIndex - lookAhead.length())
					+ "<font color=red><u>" + lookAhead + "</u></font>"
					+ expression.substring(curIndex));
	}

	public String evaluate(String formula, int r) throws Exception {
		if (formula.endsWith("_"))
			expression = formula.substring(0, formula.length() - 1);
		else
			expression = formula;
		row = r;
		curIndex = 0;
		output = "";
		lookAhead = this.nextToken();
		output += lookAhead;
		;
		String exp = E(false);
		if (!lookAhead.equals("EOF")) {
			// throw new Exception("Parse Error: (" + output +
			// ") Not expected '" + lookAhead + "' at index " + curIndex +
			// " of the expression " + expression);
			throw new Exception("Parse error found at index " + curIndex
					+ " :    '" + lookAhead
					+ "' is not expected in the expression "
					+ expression.substring(0, curIndex - lookAhead.length())
					+ "<font color=red><u>" + lookAhead + "</u></font>"
					+ expression.substring(curIndex));
		}
		if (exp.trim().equals(""))
			return null;
		else
			return exp;
	}

	private String E(boolean parseOnly) throws Exception {
		String tExp = T(parseOnly);
		String e2Exp = E2(parseOnly);
		return tExp + e2Exp;
	}

	private String E2(boolean parseOnly) throws Exception {
		if (lookAhead.equals("+")) {
			match("+");
			String tExp = T(parseOnly);
			String e2Exp = E2(parseOnly);
			return tExp + e2Exp;
		} else
			return "";
	}

	private String T(boolean parseOnly) throws Exception {

		if (lookAhead.equals("@If(")) {
			match("@If(");
			boolean test = B(parseOnly);
			match(";");

			String thenE;
			if (test)
				thenE = E(parseOnly);
			else
				thenE = E(true);

			match(";");

			String elseE;
			if (test)
				elseE = E(true);
			else
				elseE = E(parseOnly);

			match(")");

			if (test)
				return thenE;
			else
				return elseE;
		} else
			return S(parseOnly);
	}

	private boolean B(boolean parseOnly) throws Exception {

		if (lookAhead.equals("@IsEmpty(")) {
			match("@IsEmpty(");
			String value = E(parseOnly);
			match(")");
			if (value.trim().equals(""))
				return true;
			else
				return false;
		} else {
			String leftE = E(parseOnly);
			if (lookAhead.equals("=")) {
				match("=");
				String rightE = E(parseOnly);

				try {
					float leftFloat = Float.parseFloat(leftE);
					float rightFloat = Float.parseFloat(rightE);
					if (leftFloat == rightFloat)
						return true;
					else
						return false;
				} catch (NumberFormatException e) {
					if (leftE.trim().equals(rightE.trim()))
						return true;
					else
						return false;
				}

			} else {
				match("!=");
				String rightE = E(parseOnly);

				try {
					float leftFloat = Float.parseFloat(leftE);
					float rightFloat = Float.parseFloat(rightE);
					if (leftFloat == rightFloat)
						return false;
					else
						return true;
				} catch (NumberFormatException e) {
					if (leftE.trim().equals(rightE.trim()))
						return false;
					else
						return true;
				}

			}
		}
	}

	private String S(boolean parseOnly) throws Exception {
		if (lookAhead.startsWith("'") && lookAhead.endsWith("'")) {
			outdate = lookAhead;
			match(lookAhead);

			if (parseOnly)
				return "";

			return outdate.substring(1, outdate.length() - 1);
		} else if (lookAhead.matches("\\$[0-9]+")) {
			outdate = lookAhead;
			match(lookAhead);

			if (parseOnly)
				return "";

			int col = Integer.valueOf(outdate.substring(1));
			if (col != 0) {
				try {

					// String cell = (String) tableModel.getValueAt(row,
					// startCol + col - 1);
					String cell = (String) tableModel.getValueAt(row,
							0 + col - 1);
					// if cell is not empty
					if (cell == null) {
						cell = "";
					}
					return cell.trim();
				} 
				catch(ArrayIndexOutOfBoundsException AI)
				{
					return "";
				}
				
				catch (Exception e) {
					e.printStackTrace();
					throw new Exception("Access error: the cell " + outdate
							+ " is out of bound in the expression "
							+ expression);
				}

			} else
				return String.valueOf(row);

		} else if (lookAhead.equals("<>")) {
			match(lookAhead);

			if (parseOnly)
				return "";

			return baseURI;
		} else if (lookAhead.equals("?")) {
			match(lookAhead);

			if (parseOnly)
				return "";

			return baseURI;
		} else if (lookAhead.equals("@Add(")) {
			int beginIndex = curIndex;
			match(lookAhead);
			String leftE = E(parseOnly);
			match(",");
			String rightE = E(parseOnly);
			match(")");
			int endIndex = curIndex;

			if (parseOnly)
				return "";

			try {
				try {
					int leftInt = Integer.parseInt(leftE);
					int rightInt = Integer.parseInt(rightE);
					return String.valueOf(leftInt + rightInt);
				} catch (NumberFormatException e) {
					float leftFloat = Float.parseFloat(leftE);
					float rightFloat = Float.parseFloat(rightE);
					return String.valueOf(leftFloat + rightFloat);
				}

			} catch (Exception e) {
				if (error_tolerate)
					return "";

				if (lookAhead.equals("EOF"))
					endIndex++;
				throw new Exception("Compute Error at row " + (row + 1) + ": "
						+ " in the expression "
						+ expression.substring(0, beginIndex - 1)
						+ "<font color=red><u>"
						+ expression.substring(beginIndex - 1, endIndex - 1)
						+ "</u></font>" + expression.substring(endIndex - 1)
						+ " with an error message --- " + e.toString());

			}
		} else if (lookAhead.equals("@Sub(")) {
			int beginIndex = curIndex;
			match(lookAhead);
			String leftE = E(parseOnly);
			match(",");
			String rightE = E(parseOnly);
			match(")");
			int endIndex = curIndex;

			if (parseOnly)
				return "";

			try {
				try {
					int leftInt = Integer.parseInt(leftE);
					int rightInt = Integer.parseInt(rightE);
					return String.valueOf(leftInt - rightInt);
				} catch (NumberFormatException e) {
					float leftFloat = Float.parseFloat(leftE);
					float rightFloat = Float.parseFloat(rightE);
					return String.valueOf(leftFloat - rightFloat);
				}

			} catch (Exception e) {
				if (error_tolerate)
					return "";

				if (lookAhead.equals("EOF"))
					endIndex++;
				throw new Exception("Compute Error at row " + (row + 1) + ": "
						+ " in the expression "
						+ expression.substring(0, beginIndex - 1)
						+ "<font color=red><u>"
						+ expression.substring(beginIndex - 1, endIndex - 1)
						+ "</u></font>" + expression.substring(endIndex - 1)
						+ " with an error message --- " + e.toString());
			}
		} else if (lookAhead.equals("@Length(")) {
			match(lookAhead);
			String Exp = E(parseOnly);
			match(")");

			if (parseOnly)
				return "";

			return String.valueOf(Exp.length());
		} else if (lookAhead.equals("@IndexOf(")) {
			match(lookAhead);
			String leftE = E(parseOnly);
			match(",");
			String rightE = E(parseOnly);
			match(")");

			if (parseOnly)
				return "";

			return String.valueOf(leftE.indexOf(rightE));
		} else if (lookAhead.equals("@Substr(")) {
			int beginIndex = curIndex;
			match(lookAhead);
			String leftE = E(parseOnly);
			match(",");
			String midE = E(parseOnly);

			// @substr(E,E,E)
			if (lookAhead.equals(",")) {
				match(",");
				String rightE = E(parseOnly);
				match(")");
				int endIndex = curIndex;

				if (parseOnly)
					return "";

				try {
					int begin = Integer.parseInt(midE);
					int end = Integer.parseInt(rightE);
					return leftE.substring(begin, end);
				} catch (Exception e) {
					if (error_tolerate)
						return "";

					if (lookAhead.equals("EOF"))
						endIndex++;
					throw new Exception("Compute Error at row "
							+ (row + 1)
							+ ": "
							+ " in the expression "
							+ expression.substring(0, beginIndex - 1)
							+ "<font color=red><u>"
							+ expression
									.substring(beginIndex - 1, endIndex - 1)
							+ "</u></font>"
							+ expression.substring(endIndex - 1)
							+ " with an error message --- " + e.toString());
				}
				// @substr(E,E)
			} else {
				match(")");
				int endIndex = curIndex;

				if (parseOnly)
					return "";

				try {
					int begin = Integer.parseInt(midE);
					return leftE.substring(begin);
				} catch (Exception e) {
					if (error_tolerate)
						return "";

					if (lookAhead.equals("EOF"))
						endIndex++;
					throw new Exception("Compute Error at row "
							+ (row + 1)
							+ ": "
							+ " in the expression "
							+ expression.substring(0, beginIndex - 1)
							+ "<font color=red><u>"
							+ expression
									.substring(beginIndex - 1, endIndex - 1)
							+ "</u></font>"
							+ expression.substring(endIndex - 1)
							+ " with an error message --- " + e.toString());
				}
			}
		} else if (lookAhead.matches("[A-Za-z0-9._]+")) {
			outdate = lookAhead;
			match(lookAhead);

			if (parseOnly)
				return "";

			String expend = (String) prefixMap.get(outdate);
			if (expend != null)
				return expend;
			else
				return outdate;
		} else
			// throw new Exception("Parse Error: (" + output +
			// ") Not expected '" + lookAhead + "' at index " + curIndex +
			// " of the expression " + expression);
			throw new Exception("Parse error found at index " + curIndex
					+ " :    '" + lookAhead
					+ "' is not expected in the expression "
					+ expression.substring(0, curIndex - lookAhead.length())
					+ "<font color=red><u>" + lookAhead + "</u></font>"
					+ expression.substring(curIndex));
	}

	public static void main(String[] args) {
		/*
		 * Rdf123Expression myExp = new
		 * Rdf123Expression("?C1=C2:'ab+;;c+C1+C2;C3+C4"); String token =
		 * myExp.nextToken(); while (!token.equals("EOF")){
		 * System.out.print(token + " "); token = myExp.nextToken(); }
		 */
		try {
			// Rdf123Expression myExp = new
			// Rdf123Expression("?C7+?C1='C1C2':C1;?'http'=abc:C2;C3+C5='C7C3C5';C8;C9");
			// String result = myExp.evaluate();
			System.out.println();
			// System.out.println(result);

		} catch (Exception e) {
			e.printStackTrace();
		}

	}

}
