// The MIT License
//
// Copyright (c) 2005 Michael Grove
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
// IN THE SOFTWARE.

package org.eaglei.datatools.etl.utils;

import com.hp.hpl.jena.rdf.model.Resource;

import java.util.Comparator;

/**
 * <p>Title: SubclassSortResourceComparator</p>
 * <p>Description: An implementation of the Java Collections Comparator interface.  It can sort a list of jena resources by their subclass relationships</p>
 * <p>Copyright: Copyright (c) 2005</p>
 * <p>Company: </p>
 * @author Michael Grove
 * @version 1.0
 */
public class SubclassSortResourceComparator implements Comparator
{
    public SubclassSortResourceComparator() {
    }

    public int compare(Object obj1, Object obj2) {
        Resource res1 = null;
        if (obj1 instanceof Resource)
            res1 = (Resource)obj1;

        Resource res2 = null;
        if (obj2 instanceof Resource)
            res2 = (Resource)obj2;

        if ((res1 == null || res2 == null) || res1.equals(res2))
            return 0;
        else if (JenaUtils.isSubClassOf(res2,res1))
            return -1;
        else return 1;
    }
}
