package org.eaglei.datatools.jena;

import java.io.IOException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import org.eaglei.datatools.config.DatatoolsConfiguration;
import org.eaglei.datatools.provider.RepositoryProvider;
import org.eaglei.datatools.provider.RepositoryProviderFactory;

import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;

public class RESTRepositoryProviderFactory implements RepositoryProviderFactory {

    private static final Log logger = LogFactory.getLog(RESTRepositoryProviderFactory.class);


    @Override
    public RepositoryProvider createRepositoryProvider(DatatoolsConfiguration config) throws IOException
    {
   
        return new RESTRepositoryProvider(config);
    }
    
 
}
