/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.etl.server;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;

public class RowConfiguration {
    public static Map<String, String> getRowInfoMap(String mapPath, String tab) throws ConfigurationException {
        String globalColumnsOrder;
        HashMap<String, String> rowInfoMap = new HashMap<String, String>();
        PropertiesConfiguration config = new PropertiesConfiguration(mapPath + "/rowinfo.properties");
        Integer startrow = config.getInteger(tab.toLowerCase() + ".startrow", Integer.valueOf(1));
        rowInfoMap.put("startrow", startrow + "");
        Integer rowheadStart = config.getInteger(tab + ".rowheadstart", Integer.valueOf(1));
        rowInfoMap.put("rowheadstart", rowheadStart + "");
        String order = config.getString("process.order");
        rowInfoMap.put("order", order);
        String globalColumns = config.getString("globalcolumnsorderintoCSV");
        if (globalColumns != null) {
            rowInfoMap.put("globalcolumnsorderintoCSV", globalColumns);
        }
        if ((globalColumnsOrder = config.getString("globalcolumnsorderinexcel")) != null) {
            rowInfoMap.put("globalcolumnsorderinexcel", globalColumnsOrder);
        }
        return rowInfoMap;
    }

    public static Map<String, String> getCredentialsForRepo(String repoPath) throws ConfigurationException {
        HashMap<String, String> rowInfoMap = new HashMap<String, String>();
        PropertiesConfiguration config = new PropertiesConfiguration(repoPath);
        String user = config.getString("datatools.repository.user");
        String password = config.getString("datatools.repository.password");
        rowInfoMap.put("user", user);
        rowInfoMap.put("password", password);
        return rowInfoMap;
    }

    public static Map<String, String> getMapInfo(String mapPath) throws ConfigurationException {
        HashMap<String, String> rowInfoMap = new HashMap<String, String>();
        PropertiesConfiguration config = new PropertiesConfiguration(mapPath);
        Iterator iter = config.getKeys();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            rowInfoMap.put(key, config.getString(key));
        }
        return rowInfoMap;
    }

    public static Map<String, String> getdcCreatorFromRepoFile(String repoPath) throws ConfigurationException {
        String[] dccreatorAry;
        HashMap<String, String> dcCreatorMap = new HashMap<String, String>();
        PropertiesConfiguration config = new PropertiesConfiguration(repoPath);
        config.setDelimiterParsingDisabled(true);
        for (String dccreator : dccreatorAry = config.getStringArray("datatools.repository.dccreator")) {
            String[] splitAry = dccreator.split("#");
            dcCreatorMap.put(splitAry[0].replace(";", ","), splitAry[1]);
        }
        return dcCreatorMap;
    }
}

