/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.etl.utils;

import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Seq;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.vocabulary.DAML_OIL;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import org.eaglei.datatools.etl.utils.NamespaceManager;
import org.eaglei.datatools.etl.utils.SubclassSortResourceComparator;

public class JenaUtils {
    public static final String XML_URI = "http://www.w3.org/2000/10/XMLSchema#";
    public static final String[] XML_DATATYPES = new String[]{"http://www.w3.org/2000/10/XMLSchema#string", "http://www.w3.org/2000/10/XMLSchema#boolean", "http://www.w3.org/2000/10/XMLSchema#float", "http://www.w3.org/2000/10/XMLSchema#double", "http://www.w3.org/2000/10/XMLSchema#decimal", "http://www.w3.org/2000/10/XMLSchema#timeDuration", "http://www.w3.org/2000/10/XMLSchema#binary", "http://www.w3.org/2000/10/XMLSchema#uriReference", "http://www.w3.org/2000/10/XMLSchema#integer", "http://www.w3.org/2000/10/XMLSchema#nonPositiveInteger", "http://www.w3.org/2000/10/XMLSchema#negativeInteger", "http://www.w3.org/2000/10/XMLSchema#long", "http://www.w3.org/2000/10/XMLSchema#int", "http://www.w3.org/2000/10/XMLSchema#short", "http://www.w3.org/2000/10/XMLSchema#byte", "http://www.w3.org/2000/10/XMLSchema#nonNegativeInteger", "http://www.w3.org/2000/10/XMLSchema#unsignedLong", "http://www.w3.org/2000/10/XMLSchema#unsignedInt", "http://www.w3.org/2000/10/XMLSchema#unsignedShort", "http://www.w3.org/2000/10/XMLSchema#unsignedByte", "http://www.w3.org/2000/10/XMLSchema#positiveInteger", "http://www.w3.org/2000/10/XMLSchema#time", "http://www.w3.org/2000/10/XMLSchema#date", "http://www.w3.org/2000/10/XMLSchema#anyURI"};
    private static final Model XML_MODEL = ModelFactory.createDefaultModel();
    private static final String NEW_XML_URI = "http://www.w3.org/2001/XMLSchema#";
    public static final Resource XML_STRING = XML_MODEL.createResource("http://www.w3.org/2001/XMLSchema#string");
    public static final Resource XML_BOOLEAN = XML_MODEL.createResource("http://www.w3.org/2001/XMLSchema#boolean");
    public static final Resource XML_FLOAT = XML_MODEL.createResource("http://www.w3.org/2001/XMLSchema#float");
    public static final Resource XML_DOUBLE = XML_MODEL.createResource("http://www.w3.org/2001/XMLSchema#double");
    public static final Resource XML_DECIMAL = XML_MODEL.createResource("http://www.w3.org/2001/XMLSchema#decimal");
    public static final Resource XML_INTEGER = XML_MODEL.createResource("http://www.w3.org/2001/XMLSchema#integer");
    public static final Resource XML_NONPOSITIVE_INTEGER = XML_MODEL.createResource("http://www.w3.org/2001/XMLSchema#nonPositiveInteger");
    public static final Resource XML_NEGATIVE_INTEGER = XML_MODEL.createResource("http://www.w3.org/2001/XMLSchema#negativeInteger");
    public static final Resource XML_LONG = XML_MODEL.createResource("http://www.w3.org/2001/XMLSchema#long");
    public static final Resource XML_INT = XML_MODEL.createResource("http://www.w3.org/2001/XMLSchema#int");
    public static final Resource XML_SHORT = XML_MODEL.createResource("http://www.w3.org/2001/XMLSchema#short");
    public static final Resource XML_NONNEGATIVE_INTEGER = XML_MODEL.createResource("http://www.w3.org/2001/XMLSchema#nonNegativeInteger");
    public static final Resource XML_UNSIGNED_LONG = XML_MODEL.createResource("http://www.w3.org/2001/XMLSchema#unsignedLong");
    public static final Resource XML_UNSIGNED_INT = XML_MODEL.createResource("http://www.w3.org/2001/XMLSchema#unsignedInt");
    public static final Resource XML_UNSIGNED_SHORT = XML_MODEL.createResource("http://www.w3.org/2001/XMLSchema#unsignedShort");
    public static final Resource XML_POSITIVE_INTEGER = XML_MODEL.createResource("http://www.w3.org/2001/XMLSchema#positiveInteger");
    public static final Resource XML_TIME = XML_MODEL.createResource("http://www.w3.org/2001/XMLSchema#time");
    public static final Resource XML_DATE = XML_MODEL.createResource("http://www.w3.org/2001/XMLSchema#date");
    private static Map mNsMap;

    public static boolean isXMLDatatype(String s) {
        for (int i = 0; i < XML_DATATYPES.length; ++i) {
            if (!s.equals(XML_DATATYPES[i])) continue;
            return true;
        }
        return false;
    }

    public static int findMinCardinality(Property p) {
        if (p.listProperties(OWL.minCardinality).hasNext()) {
            return p.listProperties(OWL.minCardinality).nextStatement().getInt();
        }
        return -1;
    }

    public static int findMaxCardinality(Property p) {
        if (p.listProperties(OWL.maxCardinality).hasNext()) {
            return p.listProperties(OWL.maxCardinality).nextStatement().getInt();
        }
        return -1;
    }

    public static boolean isClass(Resource aRes) {
        return JenaUtils.isClass(aRes, aRes.getModel());
    }

    public static boolean isClass(Resource aRes, Model theModel) {
        boolean isclass;
        boolean bl = isclass = theModel.contains(aRes, RDF.type, (RDFNode)RDFS.Class) || theModel.contains(aRes, RDF.type, (RDFNode)OWL.Class) || theModel.contains(aRes, RDF.type, (RDFNode)DAML_OIL.Class);
        if (!isclass) {
            StmtIterator sIter = theModel.listStatements(aRes, RDFS.subClassOf, (RDFNode)null);
            while (sIter.hasNext()) {
                Resource aSubClass = sIter.nextStatement().getResource();
                if (aRes.equals(aSubClass) || !JenaUtils.isClass(aSubClass, theModel)) continue;
                isclass = true;
                break;
            }
            sIter.close();
        }
        return isclass;
    }

    public static boolean isProperty(Resource aRes) {
        return JenaUtils.isRDFProperty(aRes) || JenaUtils.isDatatypeProperty(aRes) || JenaUtils.isObjectProperty(aRes) || aRes.hasProperty(RDF.type, (RDFNode)OWL.AnnotationProperty);
    }

    public static boolean isRDFProperty(Resource aRes) {
        boolean isprop = aRes.hasProperty(RDF.type, (RDFNode)RDF.Property);
        if (!isprop) {
            StmtIterator sIter = aRes.listProperties(RDFS.subPropertyOf);
            while (sIter.hasNext()) {
                Resource aSubProp = sIter.nextStatement().getResource();
                if (aRes.equals(aSubProp) || !JenaUtils.isProperty(aSubProp)) continue;
                isprop = true;
                break;
            }
            sIter.close();
        }
        return isprop;
    }

    public static boolean isDatatypeProperty(Resource aRes) {
        return JenaUtils.isDatatypeProperty(aRes, aRes.getModel());
    }

    public static boolean isDatatypeProperty(Resource theRes, Model theModel) {
        boolean isprop;
        boolean bl = isprop = theModel.contains(theRes, RDF.type, (RDFNode)DAML_OIL.DatatypeProperty) || theModel.contains(theRes, RDF.type, (RDFNode)OWL.DatatypeProperty);
        if (!isprop) {
            StmtIterator sIter = theModel.listStatements(theRes, RDFS.subPropertyOf, (RDFNode)null);
            while (sIter.hasNext()) {
                Resource aSubProp = sIter.nextStatement().getResource();
                if (theRes.equals(aSubProp) || !JenaUtils.isDatatypeProperty(aSubProp, theModel)) continue;
                isprop = true;
                break;
            }
            sIter.close();
        }
        if (!isprop) {
            Property aProp = (Property)theRes.as(Property.class);
            for (Resource aRange : JenaUtils.getDeclaredRanges(aProp, theModel)) {
                if (aRange.isAnon() || !JenaUtils.isXMLDatatype(aRange.getURI()) && !aRange.getURI().equals(RDFS.Literal.getURI())) continue;
                isprop = true;
                break;
            }
        }
        return isprop;
    }

    public static boolean isObjectProperty(Resource theRes) {
        return JenaUtils.isObjectProperty(theRes, theRes.getModel());
    }

    public static boolean isObjectProperty(Resource theRes, Model theModel) {
        boolean isprop;
        if (theRes.equals(RDF.Property)) {
            return false;
        }
        boolean bl = isprop = theModel.contains(theRes, RDF.type, (RDFNode)DAML_OIL.ObjectProperty) || theModel.contains(theRes, RDF.type, (RDFNode)OWL.ObjectProperty);
        if (!isprop) {
            StmtIterator sIter = theModel.listStatements(theRes, RDFS.subPropertyOf, (RDFNode)null);
            while (sIter.hasNext()) {
                Resource aSubProp = sIter.nextStatement().getResource();
                if (theRes.equals(aSubProp) || !JenaUtils.isObjectProperty(aSubProp, theModel)) continue;
                isprop = true;
                break;
            }
            sIter.close();
        }
        if (!isprop) {
            Property aProp = (Property)theRes.as(Property.class);
            for (Resource aRange : JenaUtils.getDeclaredRanges(aProp, theModel)) {
                if (!JenaUtils.isClass(aRange)) continue;
                isprop = true;
                break;
            }
        }
        return isprop;
    }

    public static boolean isOntology(Resource theRes) {
        return JenaUtils.isOntology(theRes, theRes.getModel());
    }

    public static boolean isOntology(Resource theRes, Model theModel) {
        return theModel.contains(theRes, RDF.type, (RDFNode)OWL.Ontology);
    }

    public static Set getAllSubClassesOf(Resource r, boolean direct) {
        return JenaUtils.getAllSubClassesOf(r, r.getModel(), direct);
    }

    public static Set getAllSubClassesOf(Resource r, Model m, boolean direct) {
        HashSet<Resource> sc = new HashSet<Resource>();
        ResIterator rIter = m.listSubjectsWithProperty(RDFS.subClassOf, (RDFNode)r);
        while (rIter.hasNext()) {
            Resource aRes = rIter.nextResource();
            if (aRes.isAnon() || aRes.getURI().startsWith(RDF.getURI()) || aRes.getURI().startsWith(RDFS.getURI()) || aRes.getURI().startsWith(OWL.getURI()) || r.equals(aRes)) continue;
            sc.add(aRes);
            if (direct) continue;
            Set s = JenaUtils.getAllSubClassesOf(aRes, m, direct);
            sc.addAll(s);
        }
        rIter.close();
        return sc;
    }

    public static Set getAllSuperClassesOf(Resource r, boolean direct) {
        return JenaUtils.getAllSuperClassesOf(r, r.getModel(), direct);
    }

    public static Set getAllSuperPropertiesOf(Resource r, Model m) {
        HashSet<Resource> sc = new HashSet<Resource>();
        StmtIterator sIter = r.listProperties(RDFS.subPropertyOf);
        while (sIter.hasNext()) {
            Statement stmt = sIter.nextStatement();
            Resource aRes = stmt.getResource();
            if (aRes.isAnon() || aRes.getURI().startsWith(RDF.getURI()) || aRes.getURI().startsWith(RDFS.getURI()) || aRes.getURI().startsWith(OWL.getURI()) || r.equals(aRes)) continue;
            sc.add(aRes);
            if (JenaUtils.isLanguageTerm(aRes)) continue;
            Set s = JenaUtils.getAllSuperPropertiesOf(aRes, m);
            sc.addAll(s);
        }
        sIter.close();
        return sc;
    }

    public static Set getAllSuperClassesOf(Resource r, Model m, boolean direct) {
        HashSet<Resource> sc = new HashSet<Resource>();
        StmtIterator sIter = r.listProperties(RDFS.subClassOf);
        while (sIter.hasNext()) {
            Statement stmt = sIter.nextStatement();
            Resource aRes = stmt.getResource();
            if (aRes.isAnon() || aRes.getURI().startsWith(RDF.getURI()) || aRes.getURI().startsWith(RDFS.getURI()) || aRes.getURI().startsWith(OWL.getURI()) || r.equals(aRes)) continue;
            sc.add(aRes);
            if (JenaUtils.isLanguageTerm(aRes) || direct) continue;
            Set s = JenaUtils.getAllSuperClassesOf(aRes, m, direct);
            sc.addAll(s);
        }
        sIter.close();
        return sc;
    }

    public static Set getAllSubPropertiesOf(Resource r) {
        return JenaUtils.getAllSubPropertiesOf(r, r.getModel());
    }

    public static Set getAllSubPropertiesOf(Resource r, Model m) {
        HashSet<Resource> sc = new HashSet<Resource>();
        ResIterator rIter = m.listSubjectsWithProperty(RDFS.subPropertyOf, (RDFNode)r);
        while (rIter.hasNext()) {
            Resource aRes = rIter.nextResource();
            if (aRes.isAnon()) continue;
            sc.add(aRes);
            Set s = JenaUtils.getAllSubPropertiesOf(aRes);
            sc.addAll(s);
        }
        rIter.close();
        return sc;
    }

    public static Resource getType(Resource theRes, boolean filter) {
        return JenaUtils.getType(theRes, theRes.getModel(), filter);
    }

    public static Resource getType(Resource theRes, Model theModel, boolean filter) {
        Set types = JenaUtils.getTypes(theRes, theModel, filter);
        Vector v = new Vector(types);
        Collections.sort(v, new SubclassSortResourceComparator());
        if (v.size() > 0) {
            return (Resource)v.lastElement();
        }
        return null;
    }

    public static Set getTypes(Resource theRes, boolean filter) {
        return JenaUtils.getTypes(theRes, theRes.getModel(), filter);
    }

    public static Set getTypes(Resource theRes, Model theModel, boolean filter) {
        LinkedHashSet<Resource> s = new LinkedHashSet<Resource>();
        StmtIterator sIter = theModel.listStatements(theRes, RDF.type, (RDFNode)null);
        while (sIter.hasNext()) {
            Resource type = sIter.nextStatement().getResource();
            if (filter && (type.isAnon() || type.getURI().startsWith(OWL.getURI()) || type.getURI().startsWith(RDFS.getURI()) || type.getURI().startsWith(RDF.getURI()))) continue;
            s.add(type);
        }
        sIter.close();
        return s;
    }

    public static Set getAllTypes(Resource theRes, boolean filter) {
        return JenaUtils.getAllTypes(theRes, theRes.getModel(), filter);
    }

    public static Set getAllTypes(Resource theRes, Model theModel, boolean filter) {
        TreeSet<Resource> types = new TreeSet<Resource>(new SubclassSortResourceComparator());
        Set s = JenaUtils.getTypes(theRes, theModel, filter);
        for (Resource aType : s) {
            types.add(aType);
            types.addAll(JenaUtils.getAllSuperClassesOf(aType, theModel, false));
        }
        return types;
    }

    public static Set getRanges(Property aProp, Resource theClass) {
        return JenaUtils.getRanges(aProp, theClass, theClass == null ? aProp.getModel() : theClass.getModel());
    }

    public static Set getRanges(Property aProp, Resource theClass, Model theModel) {
        HashSet ranges = new HashSet();
        ranges.addAll(JenaUtils.getDeclaredRanges(aProp, theModel));
        if (aProp.hasProperty(RDFS.subPropertyOf)) {
            StmtIterator sIter = aProp.listProperties(RDFS.subPropertyOf);
            while (sIter.hasNext()) {
                Statement stmt = sIter.nextStatement();
                Property p = null;
                p = stmt.getResource() instanceof Property ? (Property)stmt.getResource() : (Property)stmt.getResource().as(Property.class);
                if (p.isAnon() || p.equals(aProp)) continue;
                Set s = JenaUtils.getRanges(p, theClass);
                ranges.addAll(s);
            }
            sIter.close();
        }
        Vector newRanges = new Vector();
        for (Resource r : ranges) {
            Set sc = JenaUtils.getAllSubClassesOf(r, false);
            newRanges.addAll(sc);
        }
        ranges.addAll(newRanges);
        if (theClass != null) {
            ranges.addAll(JenaUtils.getRestrictionRanges(aProp, theClass));
        }
        return ranges;
    }

    public static Set getDeclaredRanges(Property theProp) {
        return JenaUtils.getDeclaredRanges(theProp, theProp.getModel());
    }

    public static Set getDeclaredRanges(Property theProp, Model theModel) {
        HashSet<RDFNode> ranges = new HashSet<RDFNode>();
        StmtIterator si = theModel.listStatements((Resource)theProp, RDFS.range, (RDFNode)null);
        while (si.hasNext()) {
            Statement aStmt = si.nextStatement();
            ranges.add(aStmt.getObject());
        }
        si.close();
        return ranges;
    }

    private static Set getRestrictionRanges(Property theProp, Resource theClass) {
        HashSet<RDFNode> ranges = new HashSet<RDFNode>();
        StmtIterator sIter = theClass.listProperties(RDFS.subClassOf);
        while (sIter.hasNext()) {
            Resource restriction;
            Statement stmt = sIter.nextStatement();
            if (!(!(stmt.getObject() instanceof Resource) || theClass.equals(stmt.getResource()) || stmt.getResource().isAnon() || stmt.getResource().toString().startsWith(RDFS.getURI()) || stmt.getResource().toString().startsWith(OWL.getURI()) || stmt.getResource().toString().startsWith(RDF.getURI()))) {
                Set s = JenaUtils.getRestrictionRanges(theProp, stmt.getResource());
                ranges.addAll(s);
                continue;
            }
            if (!(stmt.getObject() instanceof Resource) || !stmt.getResource().hasProperty(RDF.type, (RDFNode)OWL.Restriction) || !(restriction = stmt.getResource()).getProperty(OWL.onProperty).getResource().equals(theProp)) continue;
            if (restriction.hasProperty(OWL.allValuesFrom)) {
                ranges.add(restriction.getProperty(OWL.allValuesFrom).getObject());
                continue;
            }
            if (!restriction.hasProperty(OWL.someValuesFrom)) continue;
            ranges.add(restriction.getProperty(OWL.someValuesFrom).getObject());
        }
        sIter.close();
        return ranges;
    }

    public static String getPrettyRDF(Model m) {
        mNsMap = m.getNsPrefixMap();
        StringBuffer rdf = new StringBuffer("<" + JenaUtils.encode(RDF.getURI() + "RDF") + "\n");
        Set aSet = mNsMap.keySet();
        Iterator iter = aSet.iterator();
        while (iter.hasNext()) {
            String key = iter.next().toString();
            String value = mNsMap.get(key).toString();
            if (key.equals("")) {
                rdf.append("");
                continue;
            }
            rdf.append("\txmlns:" + key + "=\"" + value + "\"\n");
        }
        rdf.append(">\n\n");
        Hashtable seen = new Hashtable();
        ResIterator rIter = m.listSubjects();
        while (rIter.hasNext()) {
            Resource r = rIter.nextResource();
            if (r.isAnon() || seen.containsKey(r.toString())) continue;
            rdf.append(JenaUtils.toRDF(r, m, 0) + "\n\n");
        }
        rIter.close();
        rdf.append("</" + JenaUtils.encode(RDF.getURI() + "RDF") + ">");
        return rdf.toString();
    }

    private static String toRDF(Resource r, Model m, int indent) {
        String rdfAbout = JenaUtils.encode(RDF.getURI() + "about");
        String rdfResource = JenaUtils.encode(RDF.getURI() + "resource");
        String ind = "";
        for (int i = 0; i < indent; ++i) {
            ind = ind + " ";
        }
        StringBuffer rdf = new StringBuffer();
        Resource type = r.getProperty(RDF.type).getResource();
        String encType = JenaUtils.encode(type.toString());
        if (r.isAnon()) {
            rdf.append(ind + "<" + encType + ">\n");
        } else {
            rdf.append(ind + "<" + encType + " " + rdfAbout + "=\"" + r.toString() + "\">\n");
        }
        StmtIterator sIter = r.listProperties();
        while (sIter.hasNext()) {
            Statement stmt = sIter.nextStatement();
            if (stmt.getPredicate().equals(RDF.type)) continue;
            String name = JenaUtils.encode(stmt.getPredicate().toString());
            if (stmt.getObject() instanceof Literal) {
                rdf.append(ind + "  <" + name + ">" + stmt.getObject().toString() + "</" + name + ">\n");
                continue;
            }
            if (stmt.getResource().isAnon()) {
                rdf.append(ind + "  <" + name + ">\n" + JenaUtils.toRDF(stmt.getResource(), m, indent + 4) + "\n" + ind + "  </" + name + ">\n");
                continue;
            }
            rdf.append(ind + "  <" + name + " " + rdfResource + "=\"" + stmt.getObject().toString() + "\"/>\n");
        }
        sIter.close();
        rdf.append(ind + "</" + encType + ">");
        return rdf.toString();
    }

    private static String encode(String uri) {
        Set aSet = mNsMap.keySet();
        Iterator iter = aSet.iterator();
        String uriPart = uri.substring(0, uri.lastIndexOf("#") + 1);
        String prefix = null;
        while (iter.hasNext()) {
            String key = iter.next().toString();
            String value = mNsMap.get(key).toString();
            if (!value.equals(uriPart)) continue;
            prefix = key;
        }
        if (prefix == null) {
            return uri;
        }
        return prefix + ":" + uri.substring(uri.lastIndexOf("#") + 1);
    }

    public static boolean isValidRDFId(String theId) {
        return true;
    }

    public static Set getDeclaredProps(Resource aRes) {
        return JenaUtils.getDeclaredProps(aRes, aRes.getModel());
    }

    public static Set getDeclaredProps(Resource aRes, Model theModel) {
        Statement stmt;
        HashSet<Resource> s = new HashSet<Resource>();
        aRes = theModel.getResource(aRes.toString());
        ResIterator rIter = theModel.listSubjectsWithProperty(RDFS.domain, (RDFNode)aRes);
        while (rIter.hasNext()) {
            s.add(rIter.nextResource());
        }
        rIter.close();
        StmtIterator sIter = aRes.listProperties(RDFS.subClassOf);
        while (sIter.hasNext()) {
            Resource restriction;
            stmt = sIter.nextStatement();
            if (!stmt.getResource().hasProperty(RDF.type, (RDFNode)OWL.Restriction) || !(restriction = stmt.getResource()).hasProperty(OWL.onProperty)) continue;
            Resource prop = restriction.getProperty(OWL.onProperty).getResource();
            s.add(prop);
        }
        sIter.close();
        sIter = aRes.listProperties(RDFS.subClassOf);
        while (sIter.hasNext()) {
            stmt = sIter.nextStatement();
            if (!(stmt.getObject() instanceof Resource) || aRes.equals(stmt.getResource()) || stmt.getResource().isAnon() || stmt.getResource().toString().startsWith(RDFS.getURI()) || stmt.getResource().toString().startsWith(OWL.getURI()) || stmt.getResource().toString().startsWith(RDF.getURI())) continue;
            Set temp = JenaUtils.getDeclaredProps(stmt.getResource());
            s.addAll(temp);
        }
        sIter.close();
        return s;
    }

    public static String getQName(Resource res) {
        return NamespaceManager.getQNameFor(res.toString());
    }

    public static boolean isLanguageTerm(Resource r) {
        return !r.isAnon() && (r.getURI().startsWith(RDFS.getURI()) || r.getURI().startsWith(RDF.getURI()) || r.getURI().startsWith(OWL.getURI()) || r.getURI().startsWith("http://www.daml.org/2001/03/daml+oil#"));
    }

    public static String getLocalName(String name) {
        int hashIndex;
        int slashIndex = name.lastIndexOf("/");
        if (slashIndex > (hashIndex = name.lastIndexOf("#"))) {
            return name.substring(slashIndex + 1);
        }
        return name.substring(hashIndex + 1);
    }

    public static String getLabel(Resource theResource) {
        return JenaUtils.getLabel(theResource, "EN");
    }

    public static String getLabel(Resource theResource, String thePreferredLang) {
        if (theResource.hasProperty(RDFS.label)) {
            StmtIterator sIter = theResource.listProperties(RDFS.label);
            while (sIter.hasNext()) {
                Statement aStmt = sIter.nextStatement();
                if (!aStmt.getLiteral().getLanguage().equalsIgnoreCase(thePreferredLang)) continue;
                return aStmt.getLiteral().getString();
            }
            sIter.close();
            return theResource.getProperty(RDFS.label).getString();
        }
        return null;
    }

    public static String getComment(Resource theResource) {
        if (theResource.hasProperty(RDFS.comment)) {
            return theResource.getProperty(RDFS.comment).getObject().toString();
        }
        return null;
    }

    public static boolean isIndividual(Resource theResource) {
        StmtIterator sIter = theResource.listProperties(RDF.type);
        HashSet<Resource> aSet = new HashSet<Resource>();
        while (sIter.hasNext()) {
            aSet.add(sIter.nextStatement().getResource());
        }
        sIter.close();
        aSet.removeAll(Arrays.asList(RDFS.Class, RDF.Property, RDFS.Resource, OWL.Class, OWL.AnnotationProperty, OWL.DatatypeProperty, OWL.ObjectProperty, OWL.InverseFunctionalProperty, OWL.ObjectProperty, OWL.OntologyProperty, OWL.Restriction, OWL.SymmetricProperty, OWL.TransitiveProperty, RDFS.Datatype, OWL.Ontology, OWL.FunctionalProperty));
        return !aSet.isEmpty();
    }

    public static Iterator listIndividuals(Model theModel) {
        HashSet<Resource> list = new HashSet<Resource>();
        ResIterator rIter = theModel.listSubjectsWithProperty(RDF.type);
        int count = 0;
        while (rIter.hasNext()) {
            Resource aRes = rIter.nextResource();
            long start = System.currentTimeMillis();
            boolean isIndividual = JenaUtils.isIndividual(aRes);
            long end = System.currentTimeMillis();
            System.err.println("is ind time: " + (end - start));
            ++count;
            if (!isIndividual || list.contains(aRes)) continue;
            list.add(aRes);
        }
        rIter.close();
        System.err.println("");
        return list.iterator();
    }

    public static boolean isSubClassOf(Resource theChild, Resource theParent) {
        return JenaUtils.getAllSubClassesOf(theParent, false).contains(theChild);
    }

    public static boolean isType(Resource theInst, Resource theType) {
        return JenaUtils.isType(theInst, theType, theInst.getModel());
    }

    public static boolean isType(Resource theInst, Resource theType, Model theModel) {
        for (Resource aType : JenaUtils.getAllTypes(theInst, theModel, false)) {
            if (!aType.equals(theType)) continue;
            return true;
        }
        return false;
    }

    public static Set collectResourcesFromRDFList(Resource theList) {
        LinkedHashSet aSet = new LinkedHashSet();
        Resource first = null;
        Resource rest = null;
        rest = theList;
        if (rest == null || !rest.hasProperty(RDF.first)) {
            if (theList.canAs(Seq.class)) {
                aSet = JenaUtils.getFromSeq(theList);
            }
            return aSet;
        }
        do {
            first = rest.getProperty(RDF.first).getResource();
            rest = rest.getProperty(RDF.rest).getResource();
            aSet.add(first);
        } while (!rest.equals(RDF.nil));
        return aSet;
    }

    private static LinkedHashSet getFromSeq(Resource theList) {
        LinkedHashSet<RDFNode> aSet = new LinkedHashSet<RDFNode>();
        Seq aSeq = (Seq)theList.as(Seq.class);
        NodeIterator nIter = aSeq.iterator();
        while (nIter.hasNext()) {
            aSet.add(nIter.next());
        }
        nIter.close();
        return aSet;
    }

    public static Iterator listClasses(Model theModel) {
        HashSet<Resource> classes = new HashSet<Resource>();
        ResIterator rIter = theModel.listSubjects();
        while (rIter.hasNext()) {
            Resource aRes = (Resource)rIter.next();
            if (aRes.isAnon() || JenaUtils.isLanguageTerm(aRes) || !aRes.hasProperty(RDF.type, (RDFNode)RDFS.Class) && !aRes.hasProperty(RDF.type, (RDFNode)OWL.Class)) continue;
            classes.add(aRes);
        }
        rIter.close();
        return classes.iterator();
    }

    public static Iterator listProperties(Model theModel) {
        HashSet<RDFNode> classes = new HashSet<RDFNode>();
        ResIterator rIter = theModel.listSubjects();
        while (rIter.hasNext()) {
            Set aTypes;
            Resource aRes = (Resource)rIter.next();
            if (aRes.isAnon() || JenaUtils.isLanguageTerm(aRes) || !(aTypes = JenaUtils.getTypes(aRes, false)).contains(RDF.Property) && !aTypes.contains(OWL.DatatypeProperty) && !aTypes.contains(OWL.ObjectProperty)) continue;
            classes.add(aRes.as(Property.class));
        }
        rIter.close();
        return classes.iterator();
    }
}

