import sys
import pycurl
import StringIO

def getUPass(user):
    return user + ":" + user         

class RepoCurler:
    def __init__(self, repoUrl, user):
        self.curler = pycurl.Curl()
        self.repoUrl = repoUrl
        self.user = user
        self.curler.setopt(pycurl.USERPWD, getUPass(self.user))
        self.performed = False
        
    def makeNewRequest(self, repoUrlSuffix, format = None):
        self.performed = False
        self.curler.setopt(pycurl.URL, self.repoUrl + repoUrlSuffix)
        
        self.b = StringIO.StringIO()
        self.curler.setopt(pycurl.WRITEFUNCTION, self.b.write)
        self.curler.setopt(pycurl.POST, 1)
        self.curler.setopt(pycurl.HTTPHEADER, ["Accept:"])
        
        if format is None:
            self.curler.setopt(pycurl.POSTFIELDS, "format=text/plain")
        else:
            self.curler.setopt(pycurl.POSTFIELDS, format)
        
    def setopt(self, optname, optval):
        self.curler.setopt(optname, optval)
        
    def perform(self):
        self.curler.perform()
        self.performed = True
        
    def getResult(self):
        if not self.performed:
            self.perform()
            
        return self.b.getvalue()
    
    def getinfo(self, field):
        return self.curler.getinfo(field)
        