/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.client.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.Style;
import com.google.gwt.dom.client.UListElement;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.PasswordTextBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import org.eaglei.datatools.User;
import org.eaglei.datatools.client.AbstractEntryPoint;
import org.eaglei.datatools.client.DatatoolsCookies;
import org.eaglei.datatools.client.logging.GWTLogger;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.rpc.RootAsyncCallback;

public class LoginLogoutPanel
extends Composite
implements ClientRepositoryToolsManager.SessionListener {
    private static LoginLogoutPanelUiBinder uiBinder = (LoginLogoutPanelUiBinder)GWT.create(LoginLogoutPanelUiBinder.class);
    private static GWTLogger log = GWTLogger.getLogger("Datatools");
    @UiField
    protected Label welcomeLabel;
    @UiField
    protected Anchor logoutAnchor;
    @UiField
    protected UListElement loginList;
    @UiField
    protected TextBox userTextBox;
    @UiField
    protected PasswordTextBox passTextBox;
    @UiField
    protected Button loginButton;
    private Element loginListParent;
    private boolean signedIn = false;

    public LoginLogoutPanel() {
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
        this.loginListParent = this.loginList.getParentElement();
        this.welcomeLabel.setText("Please login");
        this.passTextBox.addKeyUpHandler(new KeyUpHandler(){

            public void onKeyUp(KeyUpEvent event) {
                if (event.getNativeKeyCode() == 13) {
                    LoginLogoutPanel.this.performLogin();
                }
            }
        });
        this.loginButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                LoginLogoutPanel.this.performLogin();
            }
        });
        if (!this.signedIn) {
            this.logoutAnchor.setVisible(false);
        }
        this.logoutAnchor.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (LoginLogoutPanel.this.signedIn) {
                    AbstractEntryPoint.setIsRefresh(false);
                    LoginLogoutPanel.this.performLogout();
                }
            }
        });
        if (DatatoolsCookies.getSession() != null) {
            this.onLogIn(DatatoolsCookies.getUserName(), DatatoolsCookies.getUserUri());
        }
        ClientRepositoryToolsManager.INSTANCE.addSessionListener(this);
    }

    private void performLogout() {
        ClientRepositoryToolsManager.INSTANCE.logOut();
    }

    @Override
    public void onLogOut(boolean isSessionExpired) {
        this.welcomeLabel.setText("Please login");
        this.loginListParent.appendChild((Node)this.loginList);
        this.loginList.getStyle().setVisibility(Style.Visibility.VISIBLE);
        this.signedIn = false;
        this.userTextBox.setText("");
        this.passTextBox.setText("");
        this.logoutAnchor.setVisible(false);
    }

    @Override
    public void onLogIn(String username, String userUri) {
        this.welcomeLabel.setText("Welcome, " + username);
        this.logoutAnchor.setVisible(true);
        this.loginList.removeFromParent();
        this.signedIn = true;
    }

    private void performLogin() {
        log.debug("triggered perfrom login");
        String user = this.userTextBox.getText();
        if (user == null || user.trim().length() == 0) {
            Window.alert((String)"A user name is required.");
            return;
        }
        String pass = this.passTextBox.getText();
        if (pass == null || pass.trim().length() == 0) {
            Window.alert((String)"A password is required.");
            return;
        }
        ClientRepositoryToolsManager.INSTANCE.logIn(user.trim(), pass.trim(), new RootAsyncCallback<User>(){

            @Override
            public void onSuccess(User userInfo) {
                AbstractEntryPoint.setUser(userInfo);
            }
        });
    }

    static interface LoginLogoutPanelUiBinder
    extends UiBinder<Widget, LoginLogoutPanel> {
    }
}

