/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.client.ui;

import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import org.eaglei.datatools.SortByProperties;
import org.eaglei.datatools.client.AbstractEntryPoint;
import org.eaglei.datatools.client.ApplicationState;
import org.eaglei.datatools.client.QueryTokenObject;
import org.eaglei.datatools.client.logging.GWTLogger;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.rpc.RootAsyncCallback;
import org.eaglei.datatools.client.ui.ApplicationStateChangeListener;
import org.eaglei.datatools.client.ui.EIResourcesGrid;
import org.eaglei.datatools.client.ui.FormsPanelFactory;
import org.eaglei.model.EIInstanceMinimal;
import org.eaglei.model.EIURI;
import org.eaglei.search.provider.AuthSearchRequest;

public class MainController
implements ApplicationStateChangeListener {
    public static final String DATATOOLS_FILTER = "DatatoolsFilter";
    public static final String DATATOOLS_CONTROLS = "DatatoolsControls";
    private static final GWTLogger log = GWTLogger.getLogger("MainController");

    public MainController() {
        ApplicationState.getInstance().addApplicationStateListener(this);
        this.onApplicationStateChange();
    }

    @Override
    public void onApplicationStateChange() {
        if (!ApplicationState.getInstance().hasUser()) {
            log.info("no user!");
            AbstractEntryPoint.clearDataPanel();
            return;
        }
        if (QueryTokenObject.Mode.isResourcesList(ApplicationState.getInstance().getMode())) {
            this.drawResourcesListMode();
        } else if (ApplicationState.getInstance().getMode() == QueryTokenObject.Mode.workbench) {
            this.drawWorkbench();
        } else if (ApplicationState.getInstance().getMode() == QueryTokenObject.Mode.view) {
            this.drawView();
        } else if (ApplicationState.getInstance().getMode() == QueryTokenObject.Mode.edit) {
            this.drawEdit();
        }
    }

    private void drawResourcesListMode() {
        if (ApplicationState.getInstance().getMode() == QueryTokenObject.Mode.references) {
            if (ApplicationState.getInstance().hasInstance()) {
                log.info("showing references to " + ApplicationState.getInstance().getInstanceEntity().getLabel());
                this.drawGrid();
            } else {
                log.warn("trying to display references mode with no instance!");
                Window.alert((String)"Trying to display references without a referrent!");
            }
        } else {
            this.drawGrid();
        }
    }

    protected void drawWorkbench() {
        AbstractEntryPoint.showWorkbench();
    }

    protected void drawGrid() {
        EIURI providerUri;
        EIURI WFStateUri;
        EIURI typeUri;
        AbstractEntryPoint.clearDataPanel();
        if (ApplicationState.getInstance().getMode() == QueryTokenObject.Mode.resources) {
            AbstractEntryPoint.showData((Widget)new EIResourcesGrid());
            return;
        }
        if (this.applicationShouldShowEmptyGrid()) {
            AbstractEntryPoint.showData((Widget)new EIResourcesGrid());
            return;
        }
        if (ApplicationState.getInstance().getMode() == QueryTokenObject.Mode.filter) {
            typeUri = ApplicationState.getInstance().getFilterTypeUri();
            WFStateUri = ApplicationState.getInstance().getFilterWorkflowUri();
            providerUri = ApplicationState.getInstance().getFilterResourceProviderUri();
            log.debug("setting parameters for filter query: " + typeUri + ", " + WFStateUri + ", " + providerUri);
        } else {
            typeUri = ApplicationState.getInstance().getTypeUri();
            WFStateUri = EIURI.NULL_EIURI;
            providerUri = ApplicationState.getInstance().getResourceProviderUri();
            log.debug("setting parameters for unfiltered query: " + typeUri + ", " + WFStateUri + ", " + providerUri);
        }
        AbstractEntryPoint.showGlasspane();
        AuthSearchRequest request = new AuthSearchRequest();
        if (ApplicationState.getInstance().isPaginated()) {
            request.setPaginated(true);
            request.setStartIndex(ApplicationState.getInstance().getOffset().intValue());
            request.setMaxResults(ApplicationState.getInstance().getLimit().intValue());
        } else {
            request.setPaginated(false);
        }
        if (ApplicationState.getInstance().getMode() == QueryTokenObject.Mode.references) {
            ClientRepositoryToolsManager.INSTANCE.listReferencingResources(ApplicationState.getInstance().getInstanceUri(), request, SortByProperties.getOrderBy((String)ApplicationState.getInstance().getSortBy()), ApplicationState.getInstance().isStrictlyFilteredByOwner(), this.getDisplayCallback());
        } else {
            boolean requestStubs;
            request.setType(typeUri);
            request.setWFState(WFStateUri);
            request.setLab(providerUri);
            boolean bl = requestStubs = ApplicationState.getInstance().getMode() == QueryTokenObject.Mode.stubs;
            if (requestStubs) {
                log.debug("requesting stubs; type is " + typeUri + "; instance is " + ApplicationState.getInstance().getInstanceUri());
            }
            ClientRepositoryToolsManager.INSTANCE.listResources(request, SortByProperties.getOrderBy((String)ApplicationState.getInstance().getSortBy()), true, ApplicationState.getInstance().isStrictlyFilteredByOwner(), requestStubs, this.getDisplayCallback());
        }
    }

    private boolean applicationShouldShowEmptyGrid() {
        return false;
    }

    private RootAsyncCallback<List<EIInstanceMinimal>> getDisplayCallback() {
        return new RootAsyncCallback<List<EIInstanceMinimal>>(){

            @Override
            public void onSuccess(List<EIInstanceMinimal> result) {
                AbstractEntryPoint.hideGlasspane();
                EIResourcesGrid grid = new EIResourcesGrid(result);
                AbstractEntryPoint.showData((Widget)grid);
            }

            @Override
            public void onFailure(Throwable caught) {
                AbstractEntryPoint.hideGlasspane();
                super.onFailure(caught);
            }
        };
    }

    protected void drawView() {
        log.debug("viewing " + ApplicationState.getInstance().getInstanceEntity());
        AbstractEntryPoint.clearDataPanel();
        AbstractEntryPoint.showData((Widget)FormsPanelFactory.generateViewForm(ApplicationState.getInstance().getInstanceUri()));
    }

    protected void drawEdit() {
        log.debug("editing " + ApplicationState.getInstance().getInstanceEntity());
        AbstractEntryPoint.clearDataPanel();
        if (!ApplicationState.getInstance().hasInstance()) {
            AbstractEntryPoint.showData((Widget)FormsPanelFactory.generateNewForm(ApplicationState.getInstance().getTypeEntity()));
        } else {
            AbstractEntryPoint.showData((Widget)FormsPanelFactory.generateEditForm(ApplicationState.getInstance().getInstanceUri()));
        }
    }

    public void onLogIn(String username, String userUri) {
        log.debug("main controller logged in, calling on AppStateChange; mode = " + (Object)((Object)ApplicationState.getInstance().getMode()) + "; type = " + ApplicationState.getInstance().getTypeEntity());
        this.onApplicationStateChange();
    }

    public void onLogOut(boolean isSessionExpired) {
        this.onApplicationStateChange();
    }
}

