/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.client.ui.widgets;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eaglei.datatools.client.logging.GWTLogger;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.rpc.RootAsyncCallback;
import org.eaglei.datatools.client.ui.WidgetUtils;
import org.eaglei.datatools.client.ui.listeners.NewInnerInstanceListener;
import org.eaglei.datatools.client.ui.widgets.EIResourceListWidget;
import org.eaglei.datatools.client.ui.widgets.EditWidget;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;

public class ObjectWidget
extends EditWidget {
    private final ListBox rangePicker = new ListBox();
    private List<EIClass> rangeList = new ArrayList<EIClass>();
    private final EIEntity selectedEntity;
    private EIClass instanceRootClass;
    private List<EIClass> instanceSuperclasses;
    private EditWidget innerWidget;
    private final EIEntity providerEntity;
    private boolean isEnabled = true;
    private final NewInnerInstanceListener listener;
    private final boolean isPropertyProviderRelated;
    private final Map<EIEntity, EIClass> entityRangeMap = new HashMap<EIEntity, EIClass>();
    private static final String NO_VALUE = "<none>";
    private static final GWTLogger log = GWTLogger.getLogger("ObjectWidget");

    public ObjectWidget(EIInstance eiInstance, EIEntity propertyEntity, String propertyDefinition, boolean isRequired, List<EIClass> rangeList, EIEntity providerEntity, EIEntity selectedEntity, boolean isPropertyProviderRelated, NewInnerInstanceListener listener) {
        super(eiInstance, propertyEntity, propertyDefinition, isRequired);
        log.debug("range list has " + rangeList.size() + " entries");
        this.rangeList = rangeList;
        Collections.sort(this.rangeList, new Comparator<EIClass>(){

            @Override
            public int compare(EIClass arg0, EIClass arg1) {
                return arg0.getEntity().getLabel().compareTo(arg1.getEntity().getLabel());
            }
        });
        this.listener = listener;
        this.selectedEntity = selectedEntity;
        this.isPropertyProviderRelated = isPropertyProviderRelated;
        log.debug("selected entity is: " + this.selectedEntity);
        this.providerEntity = providerEntity;
        this.getInstanceRootClass();
    }

    private void setup() {
        this.rangePicker.setStyleName("MultiRangeDropbox");
        this.widgetPanel.add((Widget)this.rangePicker);
        this.rangePicker.addItem(NO_VALUE, NO_VALUE);
        for (EIClass range : this.rangeList) {
            this.entityRangeMap.put(range.getEntity(), range);
            this.rangePicker.addItem(range.getEntity().getLabel(), range.getEntity().getURI().toString());
            if (this.instanceRootClass == null && this.instanceSuperclasses != null && this.instanceSuperclasses.contains(range)) {
                this.rangePicker.setSelectedIndex(this.rangePicker.getItemCount() - 1);
                continue;
            }
            if (this.instanceRootClass != null && range.getEntity().equals((Object)this.instanceRootClass.getEntity())) {
                this.rangePicker.setSelectedIndex(this.rangePicker.getItemCount() - 1);
                continue;
            }
            if (!this.hasResourceProviderUri() || !this.isPropertyProviderRelated) continue;
            this.rangePicker.setSelectedIndex(this.rangePicker.getItemCount() - 1);
        }
        this.selectProperValue();
        this.setRangePickBehavior();
    }

    private void setRangePickBehavior() {
        this.rangePicker.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent arg0) {
                if (ObjectWidget.this.rangePicker.getItemText(ObjectWidget.this.rangePicker.getSelectedIndex()).equals(ObjectWidget.NO_VALUE)) {
                    if (ObjectWidget.this.hasOldValue()) {
                        ObjectWidget.this.removeValue();
                    }
                    if (ObjectWidget.this.widgetPanel.getWidgetCount() > 2) {
                        ObjectWidget.this.widgetPanel.remove(2);
                        ObjectWidget.this.innerWidget = null;
                    }
                } else {
                    if (ObjectWidget.this.widgetPanel.getWidgetCount() > 2) {
                        if (ObjectWidget.this.getInnerWidget().hasOldValue()) {
                            ObjectWidget.this.eiInstance.replaceObjectPropertyValue(ObjectWidget.this.propertyEntity, ObjectWidget.this.getInnerWidget().getOldEIURIValue(), null);
                        }
                        ObjectWidget.this.widgetPanel.remove(2);
                        ObjectWidget.this.innerWidget = null;
                    }
                    EIEntity selectedRange = ObjectWidget.this.getSelectedRangeEntity();
                    ObjectWidget.this.updateOldValue(selectedRange.getURI());
                    EIClass selectedRangeClass = (EIClass)ObjectWidget.this.entityRangeMap.get(selectedRange);
                    if (selectedRangeClass.isEagleIResource()) {
                        FlowPanel tempPanel = new FlowPanel();
                        tempPanel.setStyleName("formPanelMultiRange");
                        ObjectWidget.this.innerWidget = new EIResourceListWidget(ObjectWidget.this.eiInstance, ObjectWidget.this.propertyEntity, ObjectWidget.this.propertyDefinition, ObjectWidget.this.isRequired, (EIClass)ObjectWidget.this.entityRangeMap.get(selectedRange), EIEntity.NULL_ENTITY, false, ObjectWidget.this.isPropertyProviderRelated, ObjectWidget.this.listener);
                        tempPanel.add((Widget)ObjectWidget.this.innerWidget);
                        ObjectWidget.this.widgetPanel.add((Widget)tempPanel);
                        if (ObjectWidget.this.isPropertyProviderRelated) {
                            ((EIResourceListWidget)ObjectWidget.this.innerWidget).disableAsProviderProperty();
                        }
                    } else {
                        EIClass range = (EIClass)ObjectWidget.this.entityRangeMap.get(selectedRange);
                        log.debug("term widget: selected range " + range);
                        FlowPanel tempPanel = new FlowPanel();
                        tempPanel.setStyleName("formPanelMultiRange");
                        ObjectWidget.this.widgetPanel.add((Widget)tempPanel);
                        WidgetUtils.addTermWidgetToPanel(ObjectWidget.this.eiInstance, ObjectWidget.this.propertyEntity, ObjectWidget.this.propertyDefinition, ObjectWidget.this.isRequired, range, EIEntity.NULL_ENTITY, tempPanel, false);
                    }
                }
            }
        });
    }

    private void selectProperValue() {
        if (this.rangePicker.getSelectedIndex() > 0) {
            EIEntity selectedRange = this.getSelectedRangeEntity();
            if (this.entityRangeMap.get(selectedRange).isEagleIResource()) {
                if (this.selectedEntity == null && this.hasResourceProviderUri() && this.isPropertyProviderRelated) {
                    log.info("making provider-property for " + this.entityRangeMap.get(selectedRange) + " " + this.providerEntity);
                    this.eiInstance.addObjectProperty(this.propertyEntity, this.providerEntity);
                    this.innerWidget = new EIResourceListWidget(this.eiInstance, this.propertyEntity, this.propertyDefinition, this.isRequired, this.entityRangeMap.get(selectedRange), this.providerEntity, false, this.isPropertyProviderRelated, this.listener);
                    this.disable();
                } else {
                    this.innerWidget = new EIResourceListWidget(this.eiInstance, this.propertyEntity, this.propertyDefinition, this.isRequired, this.entityRangeMap.get(selectedRange), this.selectedEntity, false, this.isPropertyProviderRelated, this.listener);
                    if (this.hasResourceProviderUri() && this.isPropertyProviderRelated) {
                        log.info("disabling " + this.propertyEntity.getLabel() + " because it is provider-related and has provider uri");
                        this.disable();
                    }
                }
                this.widgetPanel.add((Widget)this.innerWidget);
            } else {
                FlowPanel tempPanel = new FlowPanel();
                this.widgetPanel.add((Widget)tempPanel);
                WidgetUtils.addTermWidgetToPanel(this.eiInstance, this.propertyEntity, this.propertyDefinition, this.isRequired, this.instanceRootClass, this.selectedEntity, tempPanel, false);
            }
        } else if (this.selectedEntity != null && this.selectedEntity != EIEntity.NULL_ENTITY) {
            log.info("trying to make widget for deleted value");
            this.innerWidget = new EIResourceListWidget(this.eiInstance, this.propertyEntity, this.propertyDefinition, this.isRequired, EIClass.NULL_CLASS, this.selectedEntity, false, this.isPropertyProviderRelated, this.listener);
            this.widgetPanel.add((Widget)this.innerWidget);
        }
    }

    private void getInstanceRootClass() {
        if (this.selectedEntity == null) {
            log.info("no selected entity");
            this.setup();
            return;
        }
        if (WidgetUtils.isInstance(this.selectedEntity)) {
            log.debug("Trying to get superclasses for instance: " + this.selectedEntity);
            ClientRepositoryToolsManager.INSTANCE.getClassAndSuperclassesForInstanceUri(this.selectedEntity.getURI(), new RootAsyncCallback<List<EIClass>>(){

                @Override
                public void onSuccess(List<EIClass> result) {
                    ObjectWidget.this.instanceSuperclasses = result;
                    log.debug("Got superclasses: " + ObjectWidget.this.instanceSuperclasses);
                    ObjectWidget.this.setup();
                }

                @Override
                public void onFailure(Throwable caught) {
                    log.warn("Server call getRootSuperclassForInstanceUri failed; instance may have been deleted");
                    ObjectWidget.this.setup();
                }
            });
        } else {
            log.debug("in getInstanceRootClass for " + this.selectedEntity);
            ClientRepositoryToolsManager.INSTANCE.getRootSuperClass(this.selectedEntity, new RootAsyncCallback<EIClass>(){

                @Override
                public void onSuccess(EIClass superclass) {
                    ObjectWidget.this.instanceRootClass = superclass;
                    ObjectWidget.this.setup();
                }
            });
        }
    }

    private EIEntity getSelectedRangeEntity() {
        return WidgetUtils.getSelectedEntity(this.rangePicker);
    }

    protected EditWidget getInnerWidget() {
        if (this.innerWidget != null) {
            return this.innerWidget;
        }
        if (this.widgetPanel.getWidgetCount() > 2) {
            Widget widget = this.widgetPanel.getWidget(2);
            if (widget instanceof FlowPanel && (widget = ((FlowPanel)widget).getWidget(0)) != null) {
                return (EditWidget)widget;
            }
            if (widget instanceof EditWidget) {
                EditWidget inner = (EditWidget)widget;
                return inner;
            }
            Window.alert((String)"Failed to get an editWidget");
        }
        return null;
    }

    @Override
    protected boolean hasOldValue() {
        if (this.getInnerWidget() == null) {
            return false;
        }
        return this.getInnerWidget().hasOldValue();
    }

    @Override
    protected void removeValue() {
        if (this.getInnerWidget() == null) {
            return;
        }
        this.getInnerWidget().removeValue();
    }

    @Override
    public EditWidget duplicateBlank() {
        return new ObjectWidget(this.eiInstance, this.propertyEntity, this.propertyDefinition, this.isRequired, this.rangeList, this.providerEntity, null, this.isPropertyProviderRelated, this.listener);
    }

    protected boolean hasResourceProviderUri() {
        return this.providerEntity != null && !this.providerEntity.getURI().toString().equals("");
    }

    public void disable() {
        this.rangePicker.setEnabled(false);
        if (this.innerWidget instanceof EIResourceListWidget) {
            ((EIResourceListWidget)this.innerWidget).disableAsProviderProperty();
        }
        this.isEnabled = false;
    }

    public boolean isDisabled() {
        return !this.isEnabled;
    }
}

