/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.client.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.SpanElement;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import java.util.Map;
import org.eaglei.datatools.client.DatatoolsCookies;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.ui.WidgetUtils;
import org.eaglei.ui.gwt.instance.widgets.InstanceWidgetUtils;

public class TopPanel
extends Composite
implements ClientRepositoryToolsManager.SessionListener {
    private static final String BLANK = "_blank";
    private static final Binder binder = (Binder)GWT.create(Binder.class);
    @UiField
    protected Anchor changePassword;
    @UiField
    protected Image logo;
    @UiField
    protected Anchor searchLink;
    @UiField
    protected Anchor glossaryLink;
    @UiField
    protected Anchor helpLink;
    @UiField
    protected SpanElement institutionName;
    private boolean signedIn = false;
    public static String[] wfStates;
    public static Map<String, Boolean> accessMap;
    private Map<String, String> shortNameToFullNameMap = new HashMap<String, String>(){
        {
            this.put("harvard", "Harvard University");
            this.put("upr", "University Of Puerto Rico Medical Sciences Campus");
            this.put("msm", "Morehouse School of Medicine");
            this.put("jsu", "Jackson State University");
            this.put("hawaii", "University of Hawaii at Manoa");
            this.put("ohsu", "Oregon Health & Science University");
            this.put("dartmouth", "Dartmouth College");
            this.put("montana", "Montana State University");
            this.put("alaska", "University of Alaska Fairbanks");
        }
    };

    public TopPanel() {
        this.initWidget((Widget)binder.createAndBindUi(this));
        if (!this.signedIn) {
            this.changePassword.setVisible(false);
        }
        this.searchLink.setHref(WidgetUtils.getSearchURL() == null ? "http://search.eagle-i.net/central/" : this.getSearchURL());
        this.searchLink.setTarget(BLANK);
        this.glossaryLink.setHref(InstanceWidgetUtils.getGlossaryURL() == null ? "http://search.eagle-i.net/model/" : InstanceWidgetUtils.getGlossaryURL());
        this.glossaryLink.setTarget(BLANK);
        this.helpLink.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent clickEvent) {
                Window.open((String)WidgetUtils.getHelpURL(), (String)TopPanel.BLANK, (String)("height=" + TopPanel.this.getHelpWindowHeight() + ",width=" + TopPanel.this.getHelpWindowWidth() + ",left=" + TopPanel.this.getHelpWindowLeft() + ",top=0"));
            }
        });
        String shortName = InstanceWidgetUtils.getNodeNameFromURL();
        this.logo.setUrl("images/logo_" + shortName + ".png");
        this.institutionName.setInnerText(InstanceWidgetUtils.getUniversity((String)GWT.getHostPageBaseURL()));
        this.changePassword.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (TopPanel.this.signedIn) {
                    Window.open((String)WidgetUtils.getChangePasswordURL(), (String)TopPanel.BLANK, (String)("height=" + TopPanel.this.getHelpWindowHeight() + ",width=" + TopPanel.this.getHelpWindowWidth() + ",left=" + TopPanel.this.getHelpWindowLeft() + ",top=0"));
                }
            }
        });
        if (DatatoolsCookies.hasSession()) {
            this.signedIn = true;
        }
        ClientRepositoryToolsManager.INSTANCE.addSessionListener(this);
    }

    private void performLogout() {
        ClientRepositoryToolsManager.INSTANCE.logOut();
    }

    @Override
    public void onLogOut(boolean isSessionExpired) {
        this.changePassword.setVisible(false);
        this.signedIn = false;
    }

    @Override
    public void onLogIn(String username, String userUri) {
        this.changePassword.setVisible(true);
        this.signedIn = true;
    }

    private String getSearchURL() {
        String url = GWT.getHostPageBaseURL();
        String node = InstanceWidgetUtils.getNodeNameFromURL();
        if (node != null) {
            String searchUrl = url.replace(node + ".", "search.").replace("/datatools/", "") + "/central/";
            return searchUrl;
        }
        return null;
    }

    private int getHelpWindowHeight() {
        return Window.getClientHeight() + Window.getClientHeight() / 12;
    }

    private int getHelpWindowWidth() {
        return 600;
    }

    private int getHelpWindowLeft() {
        return Window.getClientWidth() - this.getHelpWindowWidth();
    }

    static {
        accessMap = new HashMap<String, Boolean>();
    }

    static interface Binder
    extends UiBinder<Widget, TopPanel> {
    }
}

