/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.client.ui.widgets;

import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import org.eaglei.datatools.client.ui.DatatoolsUIConstants;
import org.eaglei.datatools.client.ui.Validations;
import org.eaglei.datatools.client.ui.WidgetUtils;
import org.eaglei.datatools.client.ui.widgets.EditWidget;
import org.eaglei.datatools.client.ui.widgets.OldValueHandler;
import org.eaglei.datatools.client.ui.widgets.OldValueHandlerFactory;
import org.eaglei.datatools.client.ui.widgets.TextAreaWidget;
import org.eaglei.datatools.client.ui.widgets.ValidatedTextWidget;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.ui.gwt.instance.EagleIEntityConstants;
import org.eaglei.ui.gwt.instance.widgets.InstanceWidgetUtils;

public class TextWidget
extends EditWidget {
    private final TextBox valueField = WidgetUtils.createTextField();
    protected OldValueHandler oldValueHandler;

    public static EditWidget makeDatatypeTextWidget(EIInstance eiInstance, EIEntity propertyEntity, String propertyDefinition, boolean isRequired, String propertyValue) {
        if (propertyEntity.getLabel().equalsIgnoreCase("email")) {
            return new ValidatedTextWidget(eiInstance, propertyEntity, propertyDefinition, isRequired, propertyValue);
        }
        if (propertyEntity.equals((Object)EagleIEntityConstants.RESOURCE_DESCRIPTION_ENTITY) || propertyEntity.getLabel().contains("Address")) {
            return TextAreaWidget.makeDatatypeTextArea(eiInstance, propertyEntity, propertyDefinition, isRequired, propertyValue);
        }
        return new TextWidget(eiInstance, propertyEntity, propertyDefinition, isRequired, propertyValue, OldValueHandlerFactory.getDatatypeOldValueHandler());
    }

    public static TextWidget makeLabelTextWidget(EIInstance eiInstance, EIEntity propertyEntity, String propertyDefinition, boolean isRequired, String propertyValue) {
        return new TextWidget(eiInstance, propertyEntity, propertyDefinition, isRequired, propertyValue, new OldValueHandler(){

            @Override
            public void replaceValue(EIInstance instance, EIEntity propertyEntity, String oldValue, String newValue) {
                instance.getEntity().setLabel(newValue);
            }

            @Override
            public void addValue(EIInstance instance, EIEntity propertyEntity, String newValue) {
                instance.getEntity().setLabel(newValue);
            }
        });
    }

    public static TextWidget makeNonOntologyTextWidget(EIInstance eiInstance, EIEntity propertyEntity, String propertyValue) {
        return new TextWidget(eiInstance, propertyEntity, "", false, propertyValue, OldValueHandlerFactory.getNonOntologyOldValueHandler());
    }

    public static TextWidget makeTermRequestWidget(EIInstance eiInstance) {
        TextWidget termRequest = TextWidget.makeNonOntologyTextWidget(eiInstance, DatatoolsUIConstants.termRequestEntity, "");
        termRequest.label.setStyleName("TermFormLabel");
        termRequest.valueField.setStyleName("TermFormText");
        return termRequest;
    }

    protected TextWidget(EIInstance eiInstance, EIEntity propertyEntity, String propertyDefinition, boolean isRequired, String propertyValue, OldValueHandler handler) {
        super(eiInstance, propertyEntity, propertyDefinition, isRequired);
        this.oldValue = propertyValue;
        this.oldValueHandler = handler;
        this.shouldShowLabel = true;
        this.setup();
    }

    protected void setup() {
        this.valueField.setName(this.propertyEntity.getURI().toString());
        if (this.hasOldValue()) {
            this.valueField.setText(InstanceWidgetUtils.formatText((String)this.oldValue));
        }
        this.widgetPanel.add((Widget)this.valueField);
        this.valueField.addValueChangeHandler(this.getValueChangeHandler());
    }

    protected ValueChangeHandler<String> getValueChangeHandler() {
        return new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> changedValue) {
                if (TextWidget.this.hasOldValue()) {
                    TextWidget.this.oldValueHandler.replaceValue(TextWidget.this.eiInstance, TextWidget.this.propertyEntity, TextWidget.this.oldValue, (String)changedValue.getValue());
                } else {
                    TextWidget.this.oldValueHandler.addValue(TextWidget.this.eiInstance, TextWidget.this.propertyEntity, (String)changedValue.getValue());
                }
                TextWidget.this.updateOldValue((String)changedValue.getValue());
            }
        };
    }

    @Override
    public void removeValue() {
        if (this.hasOldValue()) {
            this.oldValueHandler.replaceValue(this.eiInstance, this.propertyEntity, this.oldValue, null);
        }
    }

    @Override
    public EditWidget duplicateBlank() {
        return new TextWidget(this.eiInstance, this.propertyEntity, this.propertyDefinition, this.isRequired, "", this.oldValueHandler);
    }

    protected void setFieldValue(String newValue) {
        this.valueField.setValue((Object)newValue);
    }

    protected String getValueText() {
        return this.valueField.getValue();
    }

    private void addPhoneValidations() {
        this.valueField.addKeyUpHandler(new KeyUpHandler(){

            public void onKeyUp(KeyUpEvent event) {
                if (!Validations.OnlyPhoneFormat(TextWidget.this.valueField.getValue())) {
                    TextWidget.this.valueField.setText(TextWidget.this.valueField.getText().replace(TextWidget.this.valueField.getText().toCharArray()[TextWidget.this.valueField.getText().length() - 1] + "", ""));
                    return;
                }
                Validations.jsniPhoneValidation((Element)TextWidget.this.valueField.getElement());
            }
        });
    }

    public void setName(String name) {
        this.valueField.setName(name);
    }
}

