/**
 * 
 */
package org.eaglei.datatools.client;

import org.eaglei.datatools.User;
import org.eaglei.datatools.client.logging.GWTLogger;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.rpc.RootAsyncCallback;
import org.eaglei.datatools.client.ui.EagleiGlassPane;
import org.eaglei.datatools.client.ui.LeftListPanel;
import org.eaglei.datatools.client.ui.LoginLogoutPanel;
import org.eaglei.datatools.client.ui.MainController;
import org.eaglei.datatools.client.ui.ResourceProviderCache;
import org.eaglei.datatools.client.ui.TopPanel;
import org.eaglei.datatools.client.ui.UIMessages;
import org.eaglei.datatools.client.ui.Workbench;
import org.eaglei.datatools.client.ui.widgets.BreadcrumbWidget;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIURI;
import org.eaglei.ui.gwt.NewFooterPanel;

import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.Widget;

/**
 * @author "Sravan Cheriyala" Started Mar 21, 2011
 */
public abstract class AbstractEntryPoint implements EntryPoint {

	protected static String currentUser;
	protected FlowPanel mainDiv;
	protected FlowPanel datatoolsDiv1;
	// FIXME this isn't right (see handleloginrequired)
	protected static FlowPanel datatoolsDiv2;
	protected FlowPanel datatoolsTitleDiv;
	protected HTML datatoolsTitle;
	protected FlowPanel mainPanel;
	// FIXME it looks like isRefresh is not used any more
	protected static boolean isRefresh;
	protected TopPanel topPanel;
	protected boolean initialized = false;
	protected LeftListPanel leftList;
	protected MainController mainController;
	protected static final FlowPanel dataPanel = new FlowPanel();
	protected LoginLogoutPanel loginLogout;
	protected static final EagleiGlassPane glasspane = new EagleiGlassPane();
	protected ResourceProviderCache providerCache = null;
	protected static GWTLogger log = GWTLogger.getLogger( "AbstractEntryPoint" );
	protected static Workbench workbench = null; // TODO: UGH!
	protected BreadcrumbWidget breadcrumbs;

	protected abstract void initialize();

	public void onModuleLoad() {
		initialized = false;
		log.info( "making new main controller" );
		if ( !Window.Location.getHash().equals( "" ) ) {
			isRefresh = true;
			// need to do this here because otherwise the MainController will make a new one willy-nilly, and may not stay subscribed
			// ApplicationState.newInstance( Window.Location.getHash() );
		}

		mainController = new MainController();
		final RootPanel footerSlot = RootPanel.get( "footer_container" );
		final String version = footerSlot.getElement().getInnerText();
		footerSlot.getElement().setInnerText( "" );
		final NewFooterPanel footerPanel = new NewFooterPanel( version );
		footerSlot.add( footerPanel );

		datatoolsDiv2 = new FlowPanel();
		datatoolsDiv2.setStyleName( "datatoolsContent2" );
		datatoolsDiv1 = new FlowPanel();
		datatoolsDiv1.setStyleName( "datatoolsWrapper" );
		mainDiv = new FlowPanel();
		mainDiv.setStyleName( "wrapper" );
		datatoolsTitleDiv = new FlowPanel();
		datatoolsTitleDiv.setStyleName( "searchClickBar0" );
		datatoolsTitle = new HTML( "<img src='/datatools/images/datatools-lefttop.jpg' alt='Search' width='44' height='157' border='0' />" );
		mainDiv.add( datatoolsDiv1 );
		datatoolsTitleDiv.add( datatoolsTitle );
		datatoolsDiv1.add( datatoolsTitleDiv );
		datatoolsDiv1.add( datatoolsDiv2 );
		mainDiv.add( datatoolsDiv1 );
		RootPanel.get( "main_container" ).add( mainDiv );
		mainPanel = new FlowPanel();
		mainPanel.setStyleName( "mainPanel" );
		datatoolsDiv2.add( mainPanel );
		currentUser = DatatoolsCookies.getUserName();
		// If there are cookies, check that they're real by talking to the client manager. If not, reset user & user URI to null.
		// Since userUri is necessarily a mutable local variable, do this by checking currentUser and *then* nulling userUri afterward.

		// TODO do we need to call super.onFailure?
		if ( currentUser != null ) {
			ClientRepositoryToolsManager.INSTANCE.whoami( new RootAsyncCallback<User>() {

				@Override
				public void onSuccess(final User userInfo) {
					if ( userInfo == null ) {
						log.debug( "failed to get any user info from whoami" );
						handleNotLoggedIn();
						initialize();
						return;
					}
					AbstractEntryPoint.setUser( userInfo );
					final String user = userInfo.getUserName();
					if ( user == null ) {
						log.debug( "did whoami; user null, removing cookies" );
						handleNotLoggedIn();
						initialize();
						return;
					}
					if ( !user.equals( currentUser ) ) {
						log.debug( "did whoami; user not same as current user, removing cookies" );
						handleNotLoggedIn();
						initialize();
						return;
					}
					log.debug( "did whoami: confirms signed in as " + user );
					initialize();
					return;
				}

				@Override
				public void onFailure(final Throwable caught) {
					log.debug( "other failure in whoami" );
					handleNotLoggedIn();
					initialize();
					return;
				}
			} );
		} else {
			// Window.alert("Datatools: no user; is initialized? " + initialized);
			if ( !initialized ) {
				initialize();
				return;
			}
		}
	}

	public static void showGlasspane() {
		glasspane.add( new Image( "images/ajax-loader.gif" ) );
		glasspane.show();
	}

	public static void hideGlasspane() {
		glasspane.hide();
	}

	public static boolean isGlasspaneShowing() {
		return glasspane.isShowing();
	}

	public static void clearDataPanel() {
		dataPanel.clear();
	}

	public static void handleLoginRequired() {
		clearDataPanel();
		Window.alert( UIMessages.SESSION_EXPIRED );
		for (int index = 0; index < datatoolsDiv2.getWidgetCount(); index++) {
			if ( datatoolsDiv2.getWidget( index ) instanceof BreadcrumbWidget ) {
				datatoolsDiv2.getWidget( index ).setVisible( false );
			} else if ( datatoolsDiv2.getWidget( index ) instanceof LoginLogoutPanel ) {
				datatoolsDiv2.remove( datatoolsDiv2.getWidget( index ) );
			}
		}
		LoginLogoutPanel loginLogout = new LoginLogoutPanel();
		loginLogout.setStyleName( "floatRight" );
		datatoolsDiv2.add( loginLogout );
	}

	public static void showData(final Widget widget) {
		clearDataPanel();
		hideGlasspane();
		dataPanel.add( widget );
	}

	public static void setUser(final User user) {
		currentUser = user.getUserName();
	}

	public static void setIsRefresh(final boolean refreshing) {
		isRefresh = refreshing;
	}

	public static void addWelcomeUserText() {

	}

	protected void showLoginPanel() {
		// show the login panel
		if ( loginLogout == null ) {
			// show the login panel
			loginLogout = new LoginLogoutPanel();
			loginLogout.setStyleName( "floatRight" );
			datatoolsDiv2.add( loginLogout );

		}
	}

	private void handleNotLoggedIn() {
		ApplicationState.getInstance().setUser( EIEntity.NULL_ENTITY );
		DatatoolsCookies.removeCookies();
		currentUser = null;
		ClientRepositoryToolsManager.INSTANCE.logOut();
	}

	public static void showWorkbench() {
		workbench.resetSelectedProvider();
		showData( workbench );

	}

	public void addTopPanel() {
		if ( topPanel == null ) {
			topPanel = new TopPanel();
			RootPanel.get( "header_container" ).add( topPanel );
		}
	}

	public String attachUserToState() {
		String userUri = DatatoolsCookies.getUserUri();
		if ( currentUser == null ) {
			userUri = null;
		}

		if ( userUri != null ) {
			ApplicationState.getInstance().setUser( EIEntity.create( EIURI.create( userUri ), currentUser ) );
			log.debug( "User uri " + ApplicationState.getInstance().getUserURI() + "; label " + ApplicationState.getInstance().getUserID() );
		}
		return userUri;
	}

	public void setRefreshFlag() {
		if ( !Window.Location.getHash().equals( "" ) ) {
			isRefresh = true;
			log.debug( "token from window: " + Window.Location.getHash() );
			// ApplicationState.newInstance( Window.Location.getHash() );
		}
	}

}
