package org.eaglei.datatools.client.rpc;


import org.eaglei.datatools.client.AbstractEntryPoint;
import org.eaglei.services.repository.RepositoryProviderException;
import org.eaglei.services.repository.RepositoryProviderException.RepositoryProviderExceptionType;

import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;

public abstract class RootAsyncCallback<T> implements AsyncCallback<T>{
	
	public void onFailure(Throwable caught) {
		if ( caught instanceof RepositoryProviderException) {
			RepositoryProviderException e = (RepositoryProviderException) caught;
			if (e.getExceptionType() == RepositoryProviderExceptionType.INVALID_SESSION 
				|| e.getExceptionType() == RepositoryProviderExceptionType.UNAUTHORIZED) {
				ClientRepositoryToolsManager.INSTANCE.handleExpiredSession();	
			}
		}
		if(AbstractEntryPoint.isGlasspaneShowing())
		{
			AbstractEntryPoint.hideGlasspane();
		}
		Window.alert(caught.getMessage());
	}
	
	public abstract void onSuccess(T result);
}
