/**
 * The eagle-i consortium
 * Harvard University
 * Jul 6, 2010
 */
package org.eaglei.datatools.client.status;

import java.io.Serializable;
import java.util.HashMap;

import org.eaglei.services.repository.RepositoryProviderException.RepositoryProviderExceptionType;
/**
 * @author Daniela Bourges-Waldegg
 * Put user-friendly error messages here so they're easily reviewable; these messages are set by default in individual client side exceptions
 */
public class RepositoryErrorMessages implements Serializable{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	public final static String INVALID_SESSION_MESSAGE = "No valid session information was found.";
	public final static String UNAUTHORIZED_MESSAGE = "Could not authenticate user. Re-enter username and/or password.";
	public final static String UNAVAILABLE_MESSAGE = "The repository is currently unavailable.";
	public final static String FAILED_MESSAGE = "Could not complete operation";
	public final static String STALE_TOKEN_MESSAGE = "This resource is being edited or has recently changed. Is it open in another window? Cancel and try editing again."; // TODO: Lucy added this, edit it!
	public final static String CONFIGURATION_MESSAGE = "The server application is not correctly configured. Please contact the system administrator.";
	
	//FIXME find real user-friendly messages
	public final static String BAD_REQUEST_MESSAGE = "Bad request";
	public final static String CONFLICT_MESSAGE = "Conflict (likely stale token)";
	public final static String FORBIDDEN_MESSAGE = "Forbidden";
	public final static String INTERNAL_SERVER_ERROR_MESSAGE = UNAVAILABLE_MESSAGE;
	public final static String NOT_ACCEPTABLE_MESSAGE = "Request was not accepted by the repository.";
	public final static String NOT_FOUND_MESSAGE = "Not found";
	public static final String GONE_MESSAGE = "Resource is no longer in the repository.";
	
	private static final HashMap<RepositoryProviderExceptionType, String> messageMap = new HashMap<RepositoryProviderExceptionType, String>(9);
	
	public static String getErrorMessageForExceptionType(RepositoryProviderExceptionType type) {
		return messageMap.get(type);
	}
	
	static {
		messageMap.put(RepositoryProviderExceptionType.BAD_REQUEST, BAD_REQUEST_MESSAGE);
		messageMap.put(RepositoryProviderExceptionType.CONFLICT, CONFLICT_MESSAGE);
		messageMap.put(RepositoryProviderExceptionType.FORBIDDEN, FORBIDDEN_MESSAGE);
		messageMap.put(RepositoryProviderExceptionType.GONE, GONE_MESSAGE);
		messageMap.put(RepositoryProviderExceptionType.INTERNAL_SERVER_ERROR, INTERNAL_SERVER_ERROR_MESSAGE);
		messageMap.put(RepositoryProviderExceptionType.INVALID_SESSION, INVALID_SESSION_MESSAGE);
		messageMap.put(RepositoryProviderExceptionType.NOT_ACCEPTABLE, NOT_ACCEPTABLE_MESSAGE);
		messageMap.put(RepositoryProviderExceptionType.NOT_FOUND, NOT_FOUND_MESSAGE);
		messageMap.put(RepositoryProviderExceptionType.UNAUTHORIZED, UNAUTHORIZED_MESSAGE);
	}
}
