package org.eaglei.datatools.client.ui;

import java.util.Collection;
import java.util.Map;
import java.util.Set;

import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.ui.gwt.instance.widgets.LabelValuesWidget;

import com.google.gwt.user.client.ui.FlowPanel;

public class NonOntologyPropViewRenderer extends NonOntologyPropertiesRenderer {

	public NonOntologyPropViewRenderer(EIInstance eiInstance, FlowPanel nonOntologyOuterPanel) {
		super( eiInstance, nonOntologyOuterPanel );
		
	}

	@Override
	protected void drawNonOntologyLiteralProperty(final EIEntity propertyEntity, final Set<String> propertyValues, final FlowPanel nonOntologyPanel) {
		final String propLabel = propertyEntity.getLabel();
		final LabelValuesWidget widget = new LabelValuesWidget( propLabel );
		for (final String value : propertyValues) {
			widget.add( handleReadOnlyTextProperty( value ) );
		}
		nonOntologyPanel.add( widget );
	}

	@Override
	protected void drawNonOntologyResourceProperty(final EIEntity propertyEntity, final Set<EIEntity> propertyValues, final FlowPanel nonOntologyPanel) {
		final String propLabel = propertyEntity.getLabel();
		final LabelValuesWidget widget = new LabelValuesWidget( propLabel );
		boolean hadValue = false;
		for (final EIEntity propEntity : propertyValues) {
			// Not sure if it's possible to delete the referred-to entity for a non-ontology literal, but we might as well take care of it...
			if ( propEntity != null && propEntity != EIEntity.NULL_ENTITY && !propEntity.getLabel().equals( EIEntity.NULL_ENTITY.getLabel() ) ) {
				widget.add( handleReadOnlyTextProperty( propEntity.getLabel() ) );
				hadValue = true;
			}
		}
		if ( hadValue ) {
			nonOntologyPanel.add( widget );
		}
	}

	@Override
	protected void drawExtraFields(Map<EIEntity, Set<String>> nonOntologyLiteralProperties) {
		// TODO Auto-generated method stub
		
	}

	@Override
	protected Collection<EIEntity> getNonOntologyLiteralPropEntities() {
		return eiInstance.getNonOntologyLiteralProperties().keySet();
	}

	@Override
	protected Collection<EIEntity> getNonOntologyResourcePropEntities() {
		return eiInstance.getNonOntologyResourceProperties().keySet();
	}

	



}
