package org.eaglei.datatools.client.ui;

import static org.eaglei.ui.gwt.instance.EagleIEntityConstants.RDFS_LABEL_ENTITY;
import static org.eaglei.ui.gwt.instance.EagleIEntityConstants.RDF_TYPE_ENTITY;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.eaglei.datatools.client.ApplicationState;
import org.eaglei.datatools.client.logging.GWTLogger;
import org.eaglei.datatools.client.ui.listeners.NewInnerInstanceListener;
import org.eaglei.datatools.client.ui.widgets.EIEmbeddedResourceEditWidget;
import org.eaglei.datatools.client.ui.widgets.EIResourceListWidget;
import org.eaglei.datatools.client.ui.widgets.EditWidgetCollection;
import org.eaglei.datatools.client.ui.widgets.ObjectWidget;
import org.eaglei.datatools.client.ui.widgets.TextWidget;
import org.eaglei.datatools.client.ui.widgets.TypeWidget;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIDatatypeProperty;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIObjectProperty;
import org.eaglei.model.EIOntConstants;
import org.eaglei.model.EIProperty;
import org.eaglei.model.EIURI;
import org.eaglei.model.gwt.rpc.ClientModelManager;
import org.eaglei.model.gwt.rpc.ClientModelManager.ClassesInGroupCallback;
import org.eaglei.ui.gwt.instance.EagleIEntityConstants;
import org.eaglei.ui.gwt.instance.OntologyPropertiesRenderer;
import org.eaglei.ui.gwt.instance.widgets.InstanceWidgetUtils;

import com.google.gwt.user.client.ui.FlowPanel;

public class OntologyPropEditRenderer extends OntologyPropertiesRenderer {

	protected final List<EIEntity> dataPropEntityList = new ArrayList<EIEntity>();
	protected final List<EIEntity> booleanPropEntityList = new ArrayList<EIEntity>();
	protected final List<EIEntity> objPropEntityList = new ArrayList<EIEntity>();
	protected final Map<EIEntity, List<EIClass>> objectPropertyRanges = new HashMap<EIEntity, List<EIClass>>();

	private final EIEntity providerEntity;
	private static final GWTLogger log = GWTLogger.getLogger( "OntologyPropEditRenderer" );
	private final NewInnerInstanceListener listener;

	public OntologyPropEditRenderer(final EIInstance eiInstance, final FlowPanel ontologyPanel, final NewInnerInstanceListener innerListener) {
		super( eiInstance, ontologyPanel );
		providerEntity = ApplicationState.getInstance().getResourceProviderEntity();
		listener = innerListener; 
	}
  
	@Override
	protected void drawDataProperty(final EIEntity propertyEntity, final String propertyDefinition, final boolean isRequired, final Set<String> propertyValues) {
		if ( propertyEntity.equals( EagleIEntityConstants.RDFS_LABEL_ENTITY ) ) {
			
			final FlowPanel temp = new FlowPanel(); // Added to solve the styling issue.
			temp.setStyleName("formPanelRow");
			ontologyPanel.add(temp);
			temp.add( TextWidget.makeLabelTextWidget( eiInstance, propertyEntity, propertyDefinition, isRequired, propertyValues.iterator().next() ) );
		} else if ( propertyValues == null || propertyValues.size() == 0 ) {
			if ( booleanPropEntityList.contains( propertyEntity ) ) {
				ontologyPanel.add( WidgetUtils.createRadioButon( eiInstance, propertyEntity, propertyDefinition, isRequired, null ) );
			} else {
				ontologyPanel.add( new EditWidgetCollection( eiInstance, propertyEntity, TextWidget.makeDatatypeTextWidget( eiInstance, propertyEntity, propertyDefinition, isRequired, null ) ) );
			}
		} else {
			final EditWidgetCollection fields = new EditWidgetCollection( eiInstance, propertyEntity );
			for (final String value : propertyValues) {
				if ( booleanPropEntityList.contains( propertyEntity ) ) {
					fields.addWithoutModifiers( WidgetUtils.createRadioButon( eiInstance, propertyEntity, propertyDefinition, isRequired, value ) );
				} else {
					fields.addWidget( TextWidget.makeDatatypeTextWidget( eiInstance, propertyEntity, propertyDefinition, isRequired, value ) );
				}
			}
			fields.setStyleName( "required" );
			ontologyPanel.add( fields );
		}

	}

	@Override
	protected void drawObjectProperty(final EIEntity propertyEntity, final String propertyDefinition, final boolean isRequired, final Set<EIEntity> propertyValues) {
		if ( propertyEntity.equals( EagleIEntityConstants.RDF_TYPE_ENTITY ) ) { // Type does not have a range
			drawTypeProperty();
		} else if ( objectPropertyRanges.get( propertyEntity ) != null && objectPropertyRanges.get( propertyEntity ).size() > 0 ) {
			final EditWidgetCollection fields = new EditWidgetCollection( eiInstance, propertyEntity );
			ontologyPanel.add( fields );
			if ( objectPropertyRanges.get( propertyEntity ).size() == 1 ) { // Single range
				drawSingleObjectProperty( propertyEntity, propertyDefinition, isRequired, propertyValues, fields );
			} else { // Multiple ranges
				log.info( propertyEntity + " is a multi-range item  with " + ( propertyValues == null ? "<null>" : propertyValues.size() ) + "entries" );
				if ( propertyValues == null || propertyValues.size() == 0 ) {
					createWidgetForMultiRanges( propertyEntity, propertyDefinition, isRequired, null, fields );
				} else {
					for (final EIEntity selectedEntity : propertyValues) {
						createWidgetForMultiRanges( propertyEntity, propertyDefinition, isRequired, selectedEntity, fields );
					}
				}
			}
		}

	}

	private void drawSingleObjectProperty(final EIEntity propertyEntity, final String propertyDefinition, final boolean isRequired, 
			final Set<EIEntity> propertyValues, final EditWidgetCollection fields) {
		final EIClass range = objectPropertyRanges.get( propertyEntity ).iterator().next();
		if ( hasResourceProviderUri() && isResourceProviderRelatedProperty( propertyEntity ) ) {
			log.info( "making disabled widget for provider uri '" + providerEntity + "' property " + range.getEntity().getLabel() );
			eiInstance.addObjectProperty( propertyEntity, providerEntity );
			createWidgetForRange( propertyEntity, propertyDefinition, isRequired, range, providerEntity, fields, true );
		} else if ( propertyValues == null || propertyValues.size() == 0 ) { // new
			if ( isResourceProviderRelatedProperty( propertyEntity ) ) { // was WidgetUtils.isResourceProperty: why?
				log.info( "drawing widget for resource provider prop " + range.getEntity().getLabel() + " without treating it as resource provider" );
			}
			createWidgetForRange( propertyEntity, propertyDefinition, isRequired, range, EIEntity.NULL_ENTITY, fields, false );
		} else { // existing
			if ( isResourceProviderRelatedProperty( propertyEntity ) ) { // was WidgetUtils.isResourceProperty: why?
				log.info( "drawing multiple widgets for resource provider prop " + range.getEntity().getLabel() + " without treating it as resource provider" );
			}
			for (final EIEntity selectedEntity : propertyValues) {
				createWidgetForRange( propertyEntity, propertyDefinition, isRequired, range, selectedEntity, fields, false );
			}
		}
	}


	/**
	 * @param range
	 * @return
	 */
	private boolean isDataModelCreateRange(EIClass range) {
		if(ApplicationState.getInstance().getResourceTypesForProvider() == null) {
			return false;
		}
		return ApplicationState.getInstance().getResourceTypesForProvider().contains( range );
	}

	protected boolean hasResourceProviderUri() {
		return ( providerEntity != null ) && ( providerEntity.getURI() != EIURI.NULL_EIURI ) && ( !providerEntity.getURI().toString().equals( "" ) );
	}

	private void drawTypeProperty() {
		final FlowPanel temp = new FlowPanel();
		temp.setStyleName("formPanelRow");
		ontologyPanel.add( temp );
		final TypeWidget typeWidget = new TypeWidget( eiInstance, EagleIEntityConstants.RDF_TYPE_ENTITY, 
				eiInstance.getRootSuperType(), eiInstance.getInstanceClass(), 
				new TypeWidget.TypeChangeHandler() {
			@Override
			public void onTypeChange() {
				log.info( "redrawing; type changed to " + eiInstance.getInstanceClass() );
				ontologyPanel.clear();
				// formPanel.add( buttonPanel );
				eiClass = eiInstance.getInstanceClass();
				initializeProperties(); // re-gets lists, re-draws form. Also adds as a session listener *again*
			}
		} );
		temp.add( typeWidget );
	}


	private void createWidgetForMultiRanges(final EIEntity propertyEntity, final String propertyDefinition, final boolean isRequired, final EIEntity selectedEntity, final EditWidgetCollection fields) {
		log.info( "making multi-range widget with " + objectPropertyRanges.get( propertyEntity ).size() + " ranges" );
		final ObjectWidget widget = new ObjectWidget( eiInstance, propertyEntity, propertyDefinition, isRequired, objectPropertyRanges.get( propertyEntity ), providerEntity, selectedEntity, isResourceProviderRelatedProperty( propertyEntity ), listener );
		fields.addWidget( widget, widget.isDisabled() );
	}

	private void createWidgetForRange(final EIEntity propertyEntity, final String propertyDefinition, final boolean isRequired, final EIClass range, final EIEntity selectedEntity, final EditWidgetCollection fields, final boolean isProvider) {
		if(ApplicationState.getInstance().getEmbeddedClasses().contains(range)) {
			addEmbeddedInstanceWidget( eiInstance, propertyEntity, propertyDefinition, isRequired, range, selectedEntity, fields, true );
		} else if ( range.isEagleIResource() ) { 
			final boolean isProviderRelatedProperty = isResourceProviderRelatedProperty( propertyEntity );
			final EIResourceListWidget resourceWidget = new EIResourceListWidget( eiInstance, propertyEntity, propertyDefinition, isRequired, range, selectedEntity, true, isProviderRelatedProperty, listener );
			fields.addWidget( resourceWidget, isProvider );
			if ( isProvider ) {
				resourceWidget.disableAsProviderProperty();
			}
		} else { 
			WidgetUtils.addTermWidgetToPanel( eiInstance, propertyEntity, propertyDefinition, isRequired, range, selectedEntity, fields, true );
		}
	}

	private boolean isResourceProviderRelatedProperty(final EIEntity propertyEntity) {
		if ( eiPropertiesEntityMap.get(propertyEntity).getAnnotations() == null) {
			return false;
		}
		return eiPropertiesEntityMap.get( propertyEntity ).getAnnotations().contains(EIOntConstants.PG_LAB_RELATED);
	}
	
	private void addEmbeddedInstanceWidget(final EIInstance outerInstance, final EIEntity propertyEntity, final String propertyDefinition, final boolean isRequired, final EIClass range, final EIEntity selectedEntity,
			final EditWidgetCollection fields, final boolean showLabel) {
		final EIInstance embeddedInstance = outerInstance.getEmbeddedInstance( selectedEntity );
		EIEmbeddedResourceEditWidget widget = new EIEmbeddedResourceEditWidget(outerInstance, embeddedInstance, range.getEntity(), propertyEntity, propertyDefinition, isRequired, showLabel, listener );
		fields.addWidget(widget);
	}
		
	@Override
	protected void finishSetup() { 
		//buttonPanel.setRootSuperClass( rootSuperClass );
		dataPropEntityList.clear();
		objPropEntityList.clear();
		objectPropertyRanges.clear();
		booleanPropEntityList.clear();
		propertyInitializationCallback( );
	}   
	
	@Override
	protected void addNameProperty(final String labelPrefix) {
		final EIEntity namePropEntity = EIEntity.create( RDFS_LABEL_ENTITY.getURI(), InstanceWidgetUtils.getExtendedPropertyLabel( labelPrefix, RDFS_LABEL_ENTITY.getLabel() ) );
		drawDataProperty( namePropEntity, "", true, makeSetFromSingle( eiInstance.getInstanceLabel() ) );
	}

	@Override
	protected void addTypeProperty(final String labelPrefix) {
		final EIEntity typePropEntity = EIEntity.create( RDF_TYPE_ENTITY.getURI(), InstanceWidgetUtils.getExtendedPropertyLabel( labelPrefix, RDF_TYPE_ENTITY.getLabel() ) );
		drawObjectProperty( typePropEntity, "", true, makeSetFromSingleEntity( eiInstance.getInstanceType() ) );
	}
	
	@Override
	public void fetchConstants() {
		if ( ApplicationState.getInstance().getEmbeddedClasses() == null ) {
			ClientModelManager.INSTANCE.getClassesInGroup( EIOntConstants.CG_EMBEDDED_CLASS, new ClassesInGroupCallback() {
				@Override
				public void onSuccess(final List<EIClass> result) {
					ApplicationState.getInstance().setEmbeddedClassList( result );
					finishSetup();
				}
			} );
		} else {
			finishSetup();
		}
	}
	
	
	private void propertyInitializationCallback() { 
		for (final EIProperty property : eiProperties) {
			if ( property instanceof EIDatatypeProperty ) {
				dataPropEntityList.add( property.getEntity() );
				if ( ( (EIDatatypeProperty)property ).getTypeLabel().equals( "boolean" ) ) {
					booleanPropEntityList.add( property.getEntity() );
				} 
			} else if ( property instanceof EIObjectProperty ) {
				objPropEntityList.add( property.getEntity() );
				// Deal with equivalent classes
				final List<EIClass> assertedRanges = ( ( (EIObjectProperty)property ).getRangeList() );
				
				//TODO uncomment when we can handle equivalent classes
				//PLEASE DO NOT REMOVE THIS BLOCK
				
				/* final List<EIClass> inferredRanges = new ArrayList<EIClass>();
				// inferredRanges will contain asserted ranges where no equivalent classes
				// are defined, otherwise equivalent classes

				for (final EIClass range : assertedRanges) {
					if ( range.hasEquivalentClass() ) { // do not add range but its equivalences
						log.debug( "Range has equivalent classes; substituting" );
						final List<EIEquivalentClass> equivalentClasses = range.getEquivalentClasses();
						for (final EIEquivalentClass eqClass : equivalentClasses) {
							log.debug( "adding ranges from equivalent class: " + eqClass );
							inferredRanges.addAll( eqClass.getEquivalentTo() );
						}
					} else {
						inferredRanges.add( range );
					}
				}
				objectPropertyRanges.put( property.getEntity(), inferredRanges );
				*/
				
				//TODO when we uncomment code above, merge these two for loops
				//in provider forms, exclude from collection inverse properties
				final List< EIClass > rangesMinusDataModelCreate = new ArrayList<EIClass >();
				if(ResourceProvider.isResourceProviderType(eiInstance.getInstanceType())) {
					log.debug( "Processing provider form" );
					for(EIClass range : assertedRanges) {
						log.debug( "Processing range for provider form: " + range);
						if(!isDataModelCreateRange( range )) {
							log.debug( "Found range not annotated to DatatoolsCreate");
							rangesMinusDataModelCreate.add( range );
						}
					}
				} else {
					rangesMinusDataModelCreate.addAll(assertedRanges);
				}
				log.debug("Processing property: "  + property.getEntity() + " with number of ranges: " + rangesMinusDataModelCreate.size());
				if(! rangesMinusDataModelCreate.isEmpty() ) {
					objectPropertyRanges.put( property.getEntity(), rangesMinusDataModelCreate );
				}

			}
		}
		super.finishSetup();
	}

	/* (non-Javadoc)
	 * @see org.eaglei.datatools.client.ui.OntologyPropertiesRenderer#getDataTypeEntities()
	 */
	@Override
	public Collection<EIEntity> getDataTypeEntities() {
		return dataPropEntityList;
	}

	/* (non-Javadoc)
	 * @see org.eaglei.datatools.client.ui.OntologyPropertiesRenderer#getObjectTypeEntities()
	 */
	@Override
	public Collection<EIEntity> getObjectTypeEntities() {
		return objPropEntityList;
	}

	/* (non-Javadoc)
	 * @see org.eaglei.datatools.client.ui.OntologyPropertiesRenderer#addFormTitle(java.lang.String)
	 */
	
	@Override
	public void addFormTitle(String type) {
		//deliberate no-op
		//we can put a title here if needed
	}
	
}