package org.eaglei.datatools.client.ui.widgets;

import java.util.ArrayList;
import java.util.List;

import org.eaglei.datatools.client.logging.GWTLogger;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.rpc.RootAsyncCallback;
import org.eaglei.datatools.client.ui.OntologyPropEditRenderer;
import org.eaglei.datatools.client.ui.listeners.NewInnerInstanceListener;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.DisclosurePanel;
import com.google.gwt.user.client.ui.FlowPanel;

public class EIEmbeddedResourceEditWidget extends EditWidget implements NewInnerInstanceListener {
	private static final GWTLogger log = GWTLogger.getLogger( "EIEmbeddedResourceEditWidget" );

	private DisclosurePanel embeddedPanel;
	private EIInstance embeddedInstance;
	private EIEntity embeddedClass;
	private NewInnerInstanceListener listener;

	// in order to make sure to clear all stubs when the user clears the embedded instance, 
	// need an internal list of stubs for this embedded instance only
	private final List<EIInstance> newInnerInstances = new ArrayList<EIInstance>();

	public EIEmbeddedResourceEditWidget(final EIInstance outerInstance, final EIInstance embeddedInstance, final EIEntity embeddedClass, final EIEntity propertyEntity, String propertyDefinition, boolean isRequired, boolean showLabel,
			NewInnerInstanceListener listener) {
		super( outerInstance, propertyEntity, propertyDefinition, isRequired );
		log.debug( "Outer instance is: " + outerInstance );
		log.debug( "Embedded instance is: " + embeddedInstance );
		this.embeddedClass = embeddedClass;
		this.isRequired = isRequired;
		this.shouldShowLabel = showLabel;
		this.listener = listener;
		if ( embeddedInstance != null && !EIInstance.NULL_INSTANCE.equals( embeddedInstance ) ) {
			setup( embeddedInstance );
		} else {
			getEmptyEmbeddedInstance();
		}
	}

	/**
	 * @param embeddedClass
	 * @param propertyEntity
	 */
	private void getEmptyEmbeddedInstance() {
		ClientRepositoryToolsManager.INSTANCE.getEmptyEIInstance( embeddedClass.getURI(), new RootAsyncCallback<EIInstance>() {
			@Override
			public void onSuccess(final EIInstance newInstance) {
				newInstance.setEmbedded( true );
				eiInstance.addEmbeddedInstance( propertyEntity, newInstance );
				setup( newInstance );
			}

		} );
	}

	private void setup(final EIInstance embeddedInstance) {
		this.embeddedInstance = embeddedInstance;
		embeddedPanel = new DisclosurePanel( propertyEntity.getLabel() );
		embeddedPanel.setTitle( propertyDefinition );

		Anchor clearAllLink = new Anchor( "clear all" );

		FlowPanel mainPanel = new FlowPanel();
		FlowPanel ontologyPanel = new FlowPanel();
		addLinkClickHandler( clearAllLink, ontologyPanel, this );
		mainPanel.add( ontologyPanel );
		mainPanel.add( clearAllLink );
		new OntologyPropEditRenderer( this.embeddedInstance, ontologyPanel, this );
		embeddedPanel.setContent( mainPanel );
		widgetPanel.add( embeddedPanel );
		setShouldShowLabel( false );
	}

	private void addLinkClickHandler(Anchor clearAllLink, final FlowPanel ontologyPanel, final NewInnerInstanceListener currentListener) {
		clearAllLink.addClickHandler( new ClickHandler() {
			@Override
			public void onClick(ClickEvent arg0) {
				ontologyPanel.clear();
				clearEmbeddedInstance();
				new OntologyPropEditRenderer( embeddedInstance, ontologyPanel, currentListener );

			}
		} );

	}

	@Override
	public EditWidget duplicateBlank() {
		return new EIEmbeddedResourceEditWidget( eiInstance, EIInstance.NULL_INSTANCE, embeddedClass, propertyEntity, propertyDefinition, isRequired, false, listener );
	}

	@Override
	protected void removeValue() {
		clearEmbeddedInstance();
	}

	@Override
	public void setShouldShowLabel(final boolean shouldShowLabel) {
		if ( !shouldShowLabel ) {
			// We do not intend to show the label again for Stub Widget
			widgetPanel.remove( label );
		}
	}

	/**
	 * 
	 */
	private void clearEmbeddedInstance() {
		embeddedInstance.setInstanceLabel( "" );
		embeddedInstance.setInstanceClass( embeddedInstance.getRootSuperType() );
		embeddedInstance.getDatatypeProperties().clear();
		embeddedInstance.getObjectProperties().clear();
		listener.onInstanceRemoved( embeddedInstance );
		for ( EIInstance inner : newInnerInstances ) {
			listener.onInstanceRemoved( inner );
		}
	}

	@Override
	public void onInstanceAdded(EIInstance newInstance) {
		newInnerInstances.add( newInstance );
		listener.onInstanceAdded( newInstance );
	}

	@Override
	public void onInstanceRemoved(EIInstance newInstance) {
		newInnerInstances.remove( newInstance );
		listener.onInstanceRemoved( newInstance );
	}

	@Override
	public EIInstance getAddedInstance(EIEntity entity) {
		return listener.getAddedInstance( entity );
	}

	@Override
	public boolean isAddedInstanceEntity(EIEntity entity) {
		return listener.isAddedInstanceEntity( entity );
	};

}
