package org.eaglei.datatools.client.ui.widgets;

import org.eaglei.datatools.client.ui.Layout;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.ui.gwt.instance.widgets.InstanceWidgetUtils;

import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.TextArea;

public class TextAreaWidget extends EditWidget {

	private final TextArea valueField = new TextArea();
	protected OldValueHandler oldValueHandler;
	
	public static TextAreaWidget makeDatatypeTextArea(final EIInstance eiInstance, final EIEntity propertyEntity, final String propertyDefinition, final boolean isRequired, final String propertyValue) {
		return new TextAreaWidget( eiInstance, propertyEntity, propertyDefinition, isRequired, propertyValue, OldValueHandlerFactory.getDatatypeOldValueHandler() );
	}
	
	public static TextAreaWidget makeNonOntologyTextArea(final EIInstance eiInstance, final EIEntity propertyEntity, final String propertyDefinition, final boolean isRequired, final String propertyValue) {
		return new TextAreaWidget( eiInstance, propertyEntity, propertyDefinition, isRequired, propertyValue, OldValueHandlerFactory.getNonOntologyOldValueHandler() );
	}
	
	private TextAreaWidget(final EIInstance eiInstance, final EIEntity propertyEntity, final String propertyDefinition, final boolean isRequired, final String propertyValue, final OldValueHandler handler) {
		super( eiInstance, propertyEntity, propertyDefinition, isRequired);
		valueField.setName( propertyEntity.getURI().toString() );
		oldValue = propertyValue;
		oldValueHandler = handler;
		setup();
	}

	private void setup() {
		// Label propLabel = WidgetUtils.createLabel(propertyEntity);
		FlowPanel temp = new FlowPanel();
		temp.addStyleName("floatLeft");
		if ( hasOldValue() ) {
			valueField.setText( InstanceWidgetUtils.formatText( oldValue ) );
		}
		// widgetPanel.add(propLabel);
		widgetPanel.add( temp );
		temp.add( valueField );

		valueField.addValueChangeHandler( getValueChangeHandler() );
	}

	protected ValueChangeHandler<String> getValueChangeHandler() {
		return new ValueChangeHandler<String>() {
			@Override
			public void onValueChange(final ValueChangeEvent<String> changedValue) {
				if ( hasOldValue() ) {
					oldValueHandler.replaceValue( eiInstance, propertyEntity, oldValue, changedValue.getValue() );
				} else {
					oldValueHandler.addValue( eiInstance, propertyEntity, changedValue.getValue() );
				}
				updateOldValue( changedValue.getValue() );
			}
		};
	}

	@Override
	public EditWidget duplicateBlank() {
		return new TextAreaWidget( eiInstance, propertyEntity, propertyDefinition, isRequired, null, oldValueHandler );
	}

	@Override
	protected void removeValue() {
		if ( hasOldValue() ) {
			oldValueHandler.replaceValue( eiInstance, propertyEntity, oldValue, null );
		}
	}

}
