/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.datamanagment.server;

import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.datatools.User;
import org.eaglei.datatools.client.rpc.DataManagmentRemoteAuthService;
import org.eaglei.datatools.client.rpc.DataManagmentRemoteService;
import org.eaglei.datatools.client.status.ClientSideRepositoryException;
import org.eaglei.datatools.datamanagment.server.DataManagmentConfiguration;
import org.eaglei.datatools.datamanagment.server.DataManagmentRepositoryProvider;
import org.eaglei.datatools.jena.BulkCurationTriple;
import org.eaglei.datatools.jena.DataManagmentProvider;
import org.eaglei.datatools.server.AbstractRemoteServiceServlet;
import org.eaglei.model.EIURI;
import org.eaglei.security.Session;
import org.eaglei.services.repository.RepositoryHttpConfig;
import org.eaglei.services.repository.RepositoryProviderException;

public class DataManagmentServlet
extends AbstractRemoteServiceServlet
implements DataManagmentRemoteService,
DataManagmentRemoteAuthService {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(DataManagmentServlet.class);
    protected static final Log activityLogger = LogFactory.getLog((String)"bulk curation activity:");
    DataManagmentConfiguration configuration;

    public void init() {
        super.init();
        this.configuration = new DataManagmentConfiguration();
    }

    public List<BulkCurationTriple> getResourcesToRepair(Session session, EIURI typeURI, EIURI predicateURI, String objectString, Boolean isObjectLiteral) throws ClientSideRepositoryException {
        try {
            DataManagmentProvider dataManagmentProvider = this.getCachedDataMgmtProviderOfNodeBySession(session);
            return dataManagmentProvider.getResourcesToRepair(session, typeURI, predicateURI, objectString, isObjectLiteral);
        }
        catch (RepositoryProviderException e) {
            throw new ClientSideRepositoryException((Throwable)e, e.getExceptionType());
        }
    }

    public List<BulkCurationTriple> getResourcesToRepairByRegex(Session session, EIURI typeURI, EIURI predicateURI, String regex) throws ClientSideRepositoryException {
        try {
            DataManagmentProvider dataManagmentProvider = this.getCachedDataMgmtProviderOfNodeBySession(session);
            List results = dataManagmentProvider.getResourcesToRepairByRegex(session, typeURI, predicateURI, regex);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Returning triple list of size = " + results.size()));
            }
            return results;
        }
        catch (RepositoryProviderException e) {
            throw new ClientSideRepositoryException((Throwable)e, e.getExceptionType());
        }
    }

    private Session getRepositorySession() {
        HttpSession httpSession = this.getThreadLocalRequest().getSession();
        User userObj = (User)httpSession.getAttribute("user");
        Session session = userObj.getSession();
        return session;
    }

    public Integer replaceObject(Session session, EIURI typeURI, EIURI predicateURI, String oldObjectString, Boolean isOldObjectLiteral, String newObjectString, Boolean isNewObjectLiteral) throws ClientSideRepositoryException {
        try {
            DataManagmentProvider dataManagmentProvider = this.getCachedDataMgmtProviderOfNodeBySession(session);
            return dataManagmentProvider.replaceObject(session, typeURI, predicateURI, oldObjectString, isOldObjectLiteral, newObjectString, isNewObjectLiteral);
        }
        catch (RepositoryProviderException e) {
            activityLogger.error((Object)"there is error while performing operation 'replaceObject'");
            throw new ClientSideRepositoryException((Throwable)e, e.getExceptionType());
        }
    }

    public Integer replacePredicate(Session session, EIURI typeURI, EIURI oldPredicateURI, EIURI newPredicateURI, String objectString, Boolean isObjectLiteral) throws ClientSideRepositoryException {
        try {
            DataManagmentProvider dataManagmentProvider = this.getCachedDataMgmtProviderOfNodeBySession(session);
            return dataManagmentProvider.replacePredicate(session, typeURI, oldPredicateURI, newPredicateURI, objectString, isObjectLiteral);
        }
        catch (RepositoryProviderException e) {
            activityLogger.error((Object)"there is error while performing operation 'replaceObject'");
            throw new ClientSideRepositoryException((Throwable)e, e.getExceptionType());
        }
    }

    public Integer replaceObjectAndPredicate(Session session, EIURI typeURI, EIURI oldPredicateURI, EIURI newPredicateURI, String oldObjectString, Boolean isOldObjectLiteral, String newObjectString, Boolean isNewObjectLiteral) throws ClientSideRepositoryException {
        try {
            DataManagmentProvider dataManagmentProvider = this.getCachedDataMgmtProviderOfNodeBySession(session);
            return dataManagmentProvider.replaceObjectAndPredicate(session, typeURI, oldPredicateURI, newPredicateURI, oldObjectString, isOldObjectLiteral, newObjectString, isNewObjectLiteral);
        }
        catch (RepositoryProviderException e) {
            activityLogger.error((Object)"there is error while performing operation 'replaceObject'");
            throw new ClientSideRepositoryException((Throwable)e, e.getExceptionType());
        }
    }

    public Integer replaceObjectByRegex(Session session, EIURI typeURI, EIURI predicateURI, String regex, String replaceRegex) throws ClientSideRepositoryException {
        try {
            DataManagmentProvider dataManagmentProvider = this.getCachedDataMgmtProviderOfNodeBySession(session);
            return dataManagmentProvider.replaceObjectByRegex(session, typeURI, predicateURI, regex, replaceRegex);
        }
        catch (RepositoryProviderException e) {
            activityLogger.error((Object)"there is error while performing operation 'replaceObject'");
            throw new ClientSideRepositoryException((Throwable)e, e.getExceptionType());
        }
    }

    public Integer deleteTriple(Session session, EIURI typeURI, EIURI predicateURI, String oldObjectString, Boolean isObjectLiteral) throws ClientSideRepositoryException {
        try {
            DataManagmentProvider dataManagmentProvider = this.getCachedDataMgmtProviderOfNodeBySession(session);
            return dataManagmentProvider.deleteTriple(session, typeURI, predicateURI, oldObjectString, isObjectLiteral);
        }
        catch (RepositoryProviderException e) {
            activityLogger.error((Object)"there is error while performing operation 'replaceObject'");
            throw new ClientSideRepositoryException((Throwable)e, e.getExceptionType());
        }
    }

    public Integer addTriple(Session session, EIURI typeURI, EIURI oldPredicateURI, EIURI newPredicateURI, String oldObjectString, Boolean isOldObjectLiteral, String newObjectString, Boolean isNewObjectLiteral) throws RepositoryProviderException {
        try {
            DataManagmentProvider dataManagmentProvider = this.getCachedDataMgmtProviderOfNodeBySession(session);
            return dataManagmentProvider.addTriple(session, typeURI, oldPredicateURI, newPredicateURI, oldObjectString, isOldObjectLiteral, newObjectString, isNewObjectLiteral);
        }
        catch (RepositoryProviderException e) {
            activityLogger.error((Object)"there is error while performing operation 'replaceObject'");
            throw new ClientSideRepositoryException((Throwable)e, e.getExceptionType());
        }
    }

    public User switchServer(String node) throws ClientSideRepositoryException {
        String tier = System.getProperty("org.eaglei.tier");
        String nodeURI = this.configuration.getNodeRepositoryURI(node);
        String nodeURL = this.configuration.getNodeRepositoryURL(node);
        String tierURL = RepositoryHttpConfig.computeHostURL((String)tier, (String)nodeURL);
        DataManagmentRepositoryProvider.setDefaultRepositoryURI((String)nodeURI);
        DataManagmentRepositoryProvider.setDefaultRepositoryURL((String)tierURL);
        if (!this.isUserOfNodeChached(tierURL)) {
            throw new ClientSideRepositoryException(RepositoryProviderException.RepositoryProviderExceptionType.INVALID_SESSION);
        }
        User userToReturn = this.getCachedUserOfNode(tierURL);
        return userToReturn;
    }

    public User login(String userName, String password) throws ClientSideRepositoryException {
        try {
            User user = this.securityProvider.login(userName, password);
            String repositoryURL = this.getRepositoryURLBySession(user.getSession());
            DataManagmentProvider dataManagmentProvider = new DataManagmentProvider(this.generalSecurityProvider, repositoryURL);
            this.cacheDataMgmtProviderInHttpSession(repositoryURL, dataManagmentProvider);
            this.cacheUserInHttpSession(repositoryURL, user);
            return user;
        }
        catch (RepositoryProviderException e) {
            throw new ClientSideRepositoryException((Throwable)e);
        }
    }

    public void logout(Session session) throws ClientSideRepositoryException {
        HttpSession httpSession = this.getThreadLocalRequest().getSession();
        httpSession.invalidate();
        super.logout(session);
    }

    private String getRepositoryURLBySession(Session session) {
        RepositoryHttpConfig httpConfig = this.institutionRegistry.getRepositoryHttpConfig(session.getInstitutionId());
        return httpConfig.getHostURL();
    }

    private void cacheUserInHttpSession(String node, User user) {
        HashMap userCache = this.getUserChacheMapFromSession();
        userCache.put(node, user);
        this.setCachedMapInSession(userCache);
    }

    private User getCachedUserOfNode(String node) {
        HashMap userCache = this.getUserChacheMapFromSession();
        return (User)userCache.get(node);
    }

    private boolean isUserOfNodeChached(String node) {
        HashMap userCache = this.getUserChacheMapFromSession();
        return userCache.get(node) != null;
    }

    private HashMap<String, User> getUserChacheMapFromSession() {
        HttpSession httpSession = this.getThreadLocalRequest().getSession();
        HashMap userCache = httpSession.getAttribute("userCache") == null ? new HashMap() : (HashMap)httpSession.getAttribute("userCache");
        return userCache;
    }

    private void setCachedMapInSession(HashMap<String, User> userCache) {
        HttpSession httpSession = this.getThreadLocalRequest().getSession();
        httpSession.setAttribute("userCache", userCache);
    }

    private void cacheDataMgmtProviderInHttpSession(String node, DataManagmentProvider dataMgmtProvider) {
        HashMap dataMgmtCache = this.getDataMgmtProviderChacheMapFromSession();
        dataMgmtCache.put(node, dataMgmtProvider);
        this.setDataMgmtProviderMapInSession(dataMgmtCache);
    }

    private DataManagmentProvider getCachedDataMgmtProviderOfNodeBySession(Session session) {
        String repositoryURL = this.getRepositoryURLBySession(session);
        HashMap dataMgmtCache = this.getDataMgmtProviderChacheMapFromSession();
        return (DataManagmentProvider)dataMgmtCache.get(repositoryURL);
    }

    private boolean isDataMgmtProviderOfNodeChached(String node) {
        HashMap dataMgmtCache = this.getDataMgmtProviderChacheMapFromSession();
        return dataMgmtCache.get(node) != null;
    }

    private HashMap<String, DataManagmentProvider> getDataMgmtProviderChacheMapFromSession() {
        HttpSession httpSession = this.getThreadLocalRequest().getSession();
        HashMap dataMgmtCache = httpSession.getAttribute("dataManagmentProviderCache") == null ? new HashMap() : (HashMap)httpSession.getAttribute("dataManagmentProviderCache");
        return dataMgmtCache;
    }

    private void setDataMgmtProviderMapInSession(HashMap<String, DataManagmentProvider> dataMgmtCache) {
        HttpSession httpSession = this.getThreadLocalRequest().getSession();
        httpSession.setAttribute("dataManagmentProviderCache", dataMgmtCache);
    }
}

