package org.eaglei.datatools.client.ui;

import com.google.gwt.user.client.Element;
import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;

import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;

public class EagleiGlassPane extends Composite implements ResizeHandler {
	public static final String	STYLE	= "gcomp-GlassPanel";
	private SimplePanel			panel	= new SimplePanel();
	public EagleiGlassPane() {
		initWidget(panel);
		panel.setStylePrimaryName(STYLE);
		Window.addResizeHandler(this);
		resize();
	}
	public void onResize(ResizeEvent event) {
		resize();
	}
	public void show() {
		// Override the styles explicitly, because it's needed
		// every time the widget is detached
		Element elem = panel.getElement();
		DOM.setStyleAttribute(elem, "left", "0");
		DOM.setStyleAttribute(elem, "top", "0");
		DOM.setStyleAttribute(elem, "position", "absolute");
		RootPanel.get().add(this);
	}
	public void hide() {
		Widget w=panel.getWidget();
		panel.remove(w);
		RootPanel.get().remove(this);
	}
	private void resize() {
		panel.setSize(Window.getClientWidth() + "px", Window.getClientHeight() + "px");
	}
	public void add(Widget w) {
		SimplePanel childSimp = new SimplePanel();
		childSimp.setStyleName("center");
		childSimp.add(w);
		panel.add(childSimp);
	}
}