package org.eaglei.datatools.client.ui;

public class Validations {
	public static boolean ShouldNotBeEmpty(String txt) {
		if (txt.equals("")) {
			return false;
		} else
			return true;
	}
	public static boolean NumbersNotAllowed(String txt) {
		if (!txt.matches("^[a-zA-Z\\s]*$")) {
			return false;
		} else {
			return true;
		}
	}
	public static boolean TextNotAllowed(String txt) {
		if (!txt.matches("^[\\d]+$")) {
			return false;
		} else {
			return true;
		}
	}
	public static boolean OnlyPhoneFormat(String txt) {
		if (!txt.matches("^[\\d\\-]+$")) {
			return false;
		} else {
			return true;
		}
	}
	
	public static boolean OnlyNumbersAllowed(String txt) {
		if (!txt.matches("^[\\d]+$")) {
			return false;
		} else {
			return true;
		}
	}
	
	public static boolean SplChar_NotAllowed(String txt) {
		if (!txt.matches("^[a-zA-Z\\d\\s]*$")) {
			return false;
		} else {
			return true;
		}
	}
	public static boolean IsEmailBox(String txt) {
		if (!txt.matches("^[a-zA-Z_\\d\\.]+?@[a-zA-Z_\\d\\-]+?\\.[a-zA-Z\\.]+$")) {
			return false;
		} else {
			return true;
		}
	}
	public static boolean SpaceNotAllowed(String txt) {
		if (!txt.matches("^[^\\s]*$")) {
			return false;
		} else {
			return true;
		}
	}
	public static boolean not_EmptyandNumbersandSplChars(String txt) {
		if (!ShouldNotBeEmpty(txt) && !NumbersNotAllowed(txt) && SplChar_NotAllowed(txt)) {
			return false;
		} else
			return true;
	}
	public static boolean not_EmptyandSpaces(String txt) {
		if (!ShouldNotBeEmpty(txt) && SpaceNotAllowed(txt)) {
			return false;
		} else {
			return true;
		}
	}
	public static boolean Emailnot_EmptyandSpaces(String txt) {
		if (!ShouldNotBeEmpty(txt) && !IsEmailBox(txt) && SpaceNotAllowed(txt)) {
			return false;
		} else {
			return true;
		}
	}
	public static boolean not_EmptyPhoneFormat(String txt) {
		if (!ShouldNotBeEmpty(txt) && OnlyPhoneFormat(txt)) {
			return false;
		} else {
			return true;
		}
	}
	public static boolean EmptybutNot_NumbersandSplChars(String txt) {
		if (!NumbersNotAllowed(txt) && !SplChar_NotAllowed(txt)) {
			return false;
		} else {
			return true;
		}
	}

	
}
