/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.client.ui;

import com.allen_sauer.gwt.log.client.Log;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WorkFlowAction {
    public static WorkFlowAction CurationAction = new WorkFlowAction("Send to Curation", "Draft", "In curation");
    public static WorkFlowAction PublishAction = new WorkFlowAction("Publish", "In curation", "Published");
    public static WorkFlowAction WithdrawAction = new WorkFlowAction("Withdraw", "Published", "Withdrawn");
    public static WorkFlowAction ReturnToDraftAction = new WorkFlowAction("Return to Draft", "In curation", "Draft");
    private static Map<WorkFlowAction, List<String>> allowedActions;
    private final String name;
    private final String fromState;
    private final String toState;

    private WorkFlowAction(String name, String from, String to) {
        this.name = name;
        this.fromState = from;
        this.toState = to;
        if (allowedActions == null) {
            allowedActions = new HashMap();
        }
        if (allowedActions.get(this) == null) {
            allowedActions.put(this, new ArrayList(2));
        }
        ((List)allowedActions.get(this)).add(from);
    }

    public String getName() {
        return this.name;
    }

    public String getFromState() {
        return this.fromState;
    }

    public String getToState() {
        return this.toState;
    }

    public static String getAlertMessage(WorkFlowAction action) {
        String base = "Only resources in $STATE$ can be $ACTION$";
        String statusList = "";
        for (String status : (List)allowedActions.get(action)) {
            statusList = statusList + ", " + status;
        }
        statusList = statusList.replaceFirst(", ", "");
        Log.info((String)("status list " + statusList));
        base = base.replace("$STATE$", statusList);
        base = base.replace("$ACTION$", action.getName());
        return base;
    }
}

