/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.client.ui;

import java.util.List;
import java.util.Map;
import org.eaglei.datatools.client.ui.WorkFlowAction;
import org.eaglei.model.EIURI;

public class WorkFlowConstants {
    public static final String WITHDRAW_URI = "http://eagle-i.org/ont/repo/1.0/WFS_Withdrawn";
    public static final String PUBLISH_URI = "http://eagle-i.org/ont/repo/1.0/WFS_Published";
    public static final String CURATION_URI = "http://eagle-i.org/ont/repo/1.0/WFS_Curation";
    public static final String DRAFT_URI = "http://eagle-i.org/ont/repo/1.0/WFS_Draft";
    public static final String EAGLE_I_REPO_URI = "http://eagle-i.org/ont/repo/1.0/";
    public static final String NO_DRAFT_MESSAGE = "Only resources in 'draft' state can be sent to curation.";
    public static final String NO_CURATION_MESSAGE = "Only 'withdrawn' resources or resources in 'in curation' state can be published.";
    public static final String NO_WITHDRAWN = "Only resources in 'published' state can be withdrawn.";
    public static final String NO_RETURNTODRAFT = "Only resources in 'in curation' state can be returned to draft.";
    public static final String SELECT_MESSAGE = "Please select resources and choose action.";
    public static final String SAVE_SUCCESS = "Resource has been saved.";
    public static final String LABEL_REQUIRED = "Name is a required field.";
    public static final String NOT_IN_LIST = "Resource was not found in the repository; please click on 'Create New' to add it.";
    public static final String INVALID_VALUE = "Please select a valid value for ";
    public static final String SAVE_SUCCESS_LIGHTBOX = "Resource has been saved; please close the dialog to reflect changes.";
    public static final String BULK_OPERATION_ERROR = "Only resources in $STATE$ can be $ACTION$";
    public static final String PLEASE_LOGIN = "Please log in.";
    public static final String NO_USER = "A user name is required.";
    public static final String NO_PASSWORD = "A password is required.";
    public static final String FORM_ACTIONS_TITLE = "Form Actions";
    public static final String WORKFLOW_ACTIONS_TITLE = "Workflow Actions";
    public static final String SAVE_ACTION = "Save Resource";
    public static final String DUPLICATE_ACTION = "Duplicate Resource";
    public static final String EDIT_ACTION = "Edit Resource";
    public static final String CURATION_ACTION = "Send to Curation";
    public static final String PUBLISH_ACTION = "Publish";
    public static final String DRAFT_ACTION = "Return to Draft";
    public static final String WITHDRAW_ACTION = "Withdraw";
    public static final String CURATION_STATE = "In curation";
    public static final String PUBLISH_STATE = "Published";
    public static final String DRAFT_STATE = "Draft";
    public static final String WITHDRAW_STATE = "Withdrawn";
    public static final String COMMENTS = "http://www.w3.org/2000/01/rdf-schema#comment";
    public static final String CURATOR_NOTE = "http://purl.obolibrary.org/obo/IAO_0000232";
    public static final Map<String, List<String>> ALLOWED_TRANSITIONS = new /* Unavailable Anonymous Inner Class!! */;
    public static final Map<String, List<WorkFlowAction>> ALLOWED_ACTION_TRANSITIONS = new /* Unavailable Anonymous Inner Class!! */;
    private String statusType;

    public String getStatusType() {
        return this.statusType;
    }

    public String getStatusType(String eiuri) {
        if (DRAFT_URI.equals(eiuri)) {
            return DRAFT_STATE;
        }
        if (CURATION_URI.equals(eiuri)) {
            return CURATION_STATE;
        }
        if (PUBLISH_URI.equals(eiuri)) {
            return PUBLISH_STATE;
        }
        if (WITHDRAW_URI.equals(eiuri)) {
            return WITHDRAW_STATE;
        }
        if (DRAFT_STATE.equals(eiuri)) {
            return DRAFT_STATE;
        }
        if (CURATION_STATE.equals(eiuri)) {
            return CURATION_STATE;
        }
        if (PUBLISH_STATE.equals(eiuri)) {
            return PUBLISH_STATE;
        }
        if (WITHDRAW_STATE.equals(eiuri)) {
            return WITHDRAW_STATE;
        }
        return "";
    }

    public String getStatusTypeByStatusURI(String eiuri) {
        if (DRAFT_URI.equals(eiuri)) {
            return DRAFT_STATE;
        }
        if (CURATION_URI.equals(eiuri)) {
            return CURATION_STATE;
        }
        if (PUBLISH_URI.equals(eiuri)) {
            return PUBLISH_STATE;
        }
        if (WITHDRAW_URI.equals(eiuri)) {
            return WITHDRAW_STATE;
        }
        return null;
    }

    public EIURI getStatusURI(String status) {
        if (DRAFT_STATE.equals(status)) {
            return EIURI.create((String)DRAFT_URI);
        }
        if (CURATION_STATE.equals(status)) {
            return EIURI.create((String)CURATION_URI);
        }
        if (PUBLISH_STATE.equals(status)) {
            return EIURI.create((String)PUBLISH_URI);
        }
        if (WITHDRAW_STATE.equals(status)) {
            return EIURI.create((String)WITHDRAW_URI);
        }
        return null;
    }

    public boolean canPerform(String action, String status) {
        if (ALLOWED_ACTION_TRANSITIONS.containsKey(status)) {
            return ((List)ALLOWED_ACTION_TRANSITIONS.get(status)).contains(action);
        }
        if (ALLOWED_ACTION_TRANSITIONS.containsKey(this.getStatusType(status))) {
            return ((List)ALLOWED_ACTION_TRANSITIONS.get(status)).contains(this.getStatusType(action));
        }
        return false;
    }
}

