/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import java.io.File;
import java.net.URL;
import java.util.List;
import javax.servlet.ServletException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.datatools.client.rpc.RepositoryToolsModelService;
import org.eaglei.datatools.config.DatatoolsConfiguration;
import org.eaglei.datatools.jena.EIInstanceFactory;
import org.eaglei.datatools.jena.RESTRepositoryProviderFactory;
import org.eaglei.datatools.provider.RepositoryProvider;
import org.eaglei.datatools.provider.RepositoryProviderFactory;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIURI;
import org.eaglei.model.gwt.rpc.LoggedException;

public class RepositoryToolsModelServlet
extends RemoteServiceServlet
implements RepositoryToolsModelService {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(RepositoryToolsModelServlet.class);
    private RepositoryProvider provider = null;
    private DatatoolsConfiguration config;

    public void init() throws ServletException {
        this.config = this.getConfiguration();
        try {
            if (this.config != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"about to create provider");
                }
                this.provider = this.createProvider();
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"about to load defaults (null config)");
                }
                this.loadDefaults();
            }
        }
        catch (Exception e) {
            log.error((Object)("Error initializing RepositoryToolsModelServlet: " + e));
            throw new ServletException((Throwable)e);
        }
        this.lazyLoadFactories();
        log.info((Object)"init succesful");
    }

    private RepositoryProvider createProvider() throws Exception {
        String providerFactoryClass = this.config.getDatatoolsRepositoryProviderFactory();
        Class<?> factoryClass = Class.forName(providerFactoryClass);
        RepositoryProviderFactory factory = (RepositoryProviderFactory)factoryClass.newInstance();
        return factory.createRepositoryProvider(this.config);
    }

    private void lazyLoadFactories() {
        EIInstanceFactory.getInstance();
    }

    private void loadDefaults() throws Exception {
        log.info((Object)"Loading default provider, RESTProvider: ");
        RESTRepositoryProviderFactory factory = new RESTRepositoryProviderFactory();
        this.provider = factory.createRepositoryProvider(this.config);
        log.info((Object)("Loading default provider, RESTProvider: " + factory.toString()));
    }

    public void createInstance(String session, EIInstance instance) throws Exception {
        try {
            this.provider.createInstance(session, instance);
        }
        catch (Exception e) {
            throw new LoggedException(e.getMessage());
        }
    }

    public void deleteInstance(String session, EIInstance instance) throws Exception {
        try {
            this.provider.deleteInstance(session, instance);
        }
        catch (Exception e) {
            throw new LoggedException(e.getMessage());
        }
    }

    public String updateInstance(String session, EIInstance instance, String token) throws Exception {
        try {
            return this.provider.updateInstance(session, instance, token);
        }
        catch (Exception e) {
            throw new LoggedException(e.getMessage());
        }
    }

    public String[] login(String user, String password) throws Exception {
        try {
            return this.provider.login(user, password);
        }
        catch (Exception e) {
            throw new LoggedException(e.getMessage());
        }
    }

    public void logout(String session) throws Exception {
        try {
            this.provider.logout(session);
        }
        catch (Exception e) {
            throw new LoggedException(e.getMessage());
        }
    }

    public String[] whoami(String session) throws Exception {
        try {
            return this.provider.whoami(session);
        }
        catch (Exception e) {
            log.error((Object)("whoami exception " + e));
            throw new LoggedException(e.getMessage());
        }
    }

    private DatatoolsConfiguration getConfiguration() throws ServletException {
        String propFile = System.getProperty("datatools.config.file");
        if (propFile == null) {
            propFile = "datatools.prop";
        }
        log.debug((Object)("Using properties file " + propFile));
        URL configURL = this.getClass().getClassLoader().getResource(propFile);
        if (configURL == null) {
            log.error((Object)("Could not locate " + propFile + " on classpath "));
            throw new ServletException("Could not locate " + propFile + " on classpath ");
        }
        try {
            File configFile = new File(configURL.toURI());
            return new DatatoolsConfiguration(configFile);
        }
        catch (Exception e) {
            log.error((Object)("Error loading configuration from " + configURL + " " + e));
            throw new ServletException("Error loading configuration from " + configURL + " " + e);
        }
    }

    public boolean isOnline() {
        return this.provider.isOnline();
    }

    public List<EIInstance> getAllResources(String session, String rnav) throws Exception {
        try {
            return this.provider.getAllResources(session, rnav);
        }
        catch (Exception e) {
            throw new LoggedException(e.getMessage());
        }
    }

    public List<EIInstance> getResourcesOfClass(String session, String rnav, EIURI classUri) throws Exception {
        try {
            return this.provider.getResourcesOfClass(session, rnav, classUri);
        }
        catch (Exception e) {
            throw new LoggedException(e.getMessage());
        }
    }

    public List<EIInstance> EIQuery(String session, String query) throws Exception {
        try {
            return this.provider.EIQuery(session, query);
        }
        catch (Exception e) {
            throw new LoggedException(e.getMessage());
        }
    }

    public List<EIInstance> getInstancesForLab(String session, String rnav, String labURI) throws Exception {
        try {
            return this.provider.getInstancesForLab(session, rnav, labURI);
        }
        catch (Exception e) {
            throw new LoggedException(e.getMessage());
        }
    }

    public void uploadInstances(String session, String rdf) throws Exception {
        this.provider.uploadInstances(session, rdf);
    }

    public EIInstance getEmptyEIInstance(String session, EIURI classUri, EIEntity instanceEntity) throws Exception {
        try {
            return this.provider.getEmptyEIInstance(session, classUri, instanceEntity);
        }
        catch (Exception e) {
            throw new LoggedException(e.getMessage());
        }
    }

    public List<EIURI> getNewInstanceID(String session, int count) throws Exception {
        try {
            return this.provider.getNewInstanceID(session, count);
        }
        catch (Exception e) {
            throw new LoggedException(e.getMessage());
        }
    }

    public String query(String session, String sparql) throws Exception {
        try {
            return this.provider.query(session, sparql);
        }
        catch (Exception e) {
            throw new LoggedException(e.getMessage());
        }
    }

    public EIInstance getInstance(String session, EIURI instanceID) throws Exception {
        return this.provider.getInstance(session, instanceID);
    }

    public String claim(String session, String uri, String claimant) throws Exception {
        try {
            return this.provider.claim(session, uri, claimant);
        }
        catch (Exception e) {
            throw new LoggedException(e.getMessage());
        }
    }

    public String promote(String session, String uri, String newState) throws Exception {
        try {
            return this.provider.promote(session, uri, newState);
        }
        catch (Exception e) {
            throw new LoggedException(e.getMessage());
        }
    }

    public String[] bulkPromote(String session, String[] uri, String newState) throws Exception {
        try {
            String[] retStrAry = new String[uri.length];
            int i = 0;
            for (String strUri : uri) {
                retStrAry[i] = this.provider.promote(session, strUri, newState);
                ++i;
            }
            return retStrAry;
        }
        catch (Exception e) {
            throw new LoggedException(e.getMessage());
        }
    }

    public String[] getWFStates(String session, String user) throws Exception {
        try {
            return this.provider.getWFStates(session, user);
        }
        catch (Exception e) {
            throw new LoggedException(e.getMessage());
        }
    }

    public List<EIInstance> getFilterQuery(String session, String user, EIURI classUri, EIURI state, EIURI lab) throws Exception {
        try {
            return this.provider.getFilterQuery(session, user, classUri, state, lab);
        }
        catch (Exception e) {
            throw new LoggedException(e.getMessage());
        }
    }

    public String retrieveLabel(String session, EIURI uri) throws Exception {
        try {
            return this.provider.retrieveLabel(session, uri);
        }
        catch (Exception e) {
            throw new LoggedException(e.getMessage());
        }
    }
}

