package org.eaglei.datatools.client.rpc;

import java.util.List;

import org.eaglei.datatools.provider.RepositoryProvider;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIURI;
import org.eaglei.model.gwt.rpc.LoggedException;


import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.RemoteServiceRelativePath;

/**
 * The GWT client side stub for the RPC service to the repository
 */
@RemoteServiceRelativePath("repository")
public interface RepositoryToolsModelService extends RepositoryProvider, RemoteService {
	public String[] bulkPromote(String session, List<EIURI> urisToPromote, EIURI newState) throws Exception;
	public String[] claim(String session, EIURI[] uri, String claimant) throws Exception;
	public EIClass getRootSuperclassForInstanceUri(String session, EIURI instanceUri) throws Exception;
	public List<EIClass> getClassAndSuperclassesForInstanceUri(String session, EIURI instanceUri) throws Exception;
	public EIClass getRootSuperClass(EIClass eclass) throws Exception;
	public EIClass getSuperClass(EIClass eclass) throws Exception;
}
