package org.eaglei.datatools.client.ui;

import org.eaglei.datatools.client.Datatools;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager.EIInstanceCallback;
import org.eaglei.datatools.client.ui.QueryTokenObject.Mode;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIURI;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.VerticalPanel;

/**
 * Creates a Form Panel. This is a common class for Labs & Resources
 * 
 * @author pp101
 * 
 */
public class FormsPanelFactory {	
	@Deprecated
	private FormsPanelFactory() {
		
	}
	/**
	 * Generates a new form based on the URI passed.
	 * 
	 * @return
	 */
	public static VerticalPanel generateNewForm(final EIURI eiURI) {
		return generateNewForm(eiURI, false, getNewFormRedisplay());
	}

	public static VerticalPanel generateNewForm(final EIURI eiURI, final boolean isDialog, final EditFormRedisplay redisplay) {
		final VerticalPanel vp = new VerticalPanel();
		
		ClientRepositoryToolsManager.INSTANCE.getEmptyEIInstance(eiURI, new EIInstanceCallback() {
			@Override
			public void onSuccess(EIInstance newInstance) {
				EIClass resourceClass = newInstance.getInstanceClass();
				Log.info("Class from new empty instance was " + resourceClass);
				EIFormsPanel formsPanel;
				if (isDialog)
					formsPanel = EditFormsPanel.createDialogForm(newInstance, resourceClass, ApplicationState.getInstance().getLabUri(), redisplay);
				else
					formsPanel = EditFormsPanel.createNewForm(newInstance, resourceClass, ApplicationState.getInstance().getLabUri(), redisplay);
				vp.add(formsPanel);
			}
			@Override
			public void loginRequired() {
				handleLoginRequired();			
			}
			
		});
		return vp;
	}
	
	/**
	 * This method creates a form to edit. The values of fields will be
	 * prepopulated.
	 * 
	 * @param eiuri
	 * @return
	 */
	public static EIFormsPanel generateEditForm(EIInstance instance) {
		Log.info("generating edit form from instance");
		return generateEditContents(instance);
	}
	
	public static VerticalPanel generateDuplicateForm(EIInstance instance) {
		Log.info("generating new form from (duplicated) instance");
		final VerticalPanel vp = new VerticalPanel();
		vp.setStyleName("formPanel");
		EIFormsPanel formsPanel = EditFormsPanel.createNewForm(instance, instance.getInstanceClass(), ApplicationState.getInstance().getLabUri(), getNewFormRedisplay());
		vp.add(formsPanel);
		return vp;
	}
	
	public static VerticalPanel generateViewForm(EIURI uri) {
		Log.info("generating view form from uri " + uri);
		final VerticalPanel vp = new VerticalPanel();
		vp.setStyleName("formPanel");
		try {
			ClientRepositoryToolsManager.INSTANCE.getInstance(uri, new EIInstanceCallback() {
				@Override
				public void onSuccess(final EIInstance instance) {
					vp.add(generateViewForm(instance));
				}
				
				@Override
				public void loginRequired() {
					handleLoginRequired();
				}
			});
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return vp; 
	}
	
	@Deprecated
	public static VerticalPanel generateEditForm(String eiuri) {
		return generateEditForm(EIURI.create(eiuri));
	}
	
	public static VerticalPanel generateEditForm(EIURI uri) {
		Log.info("generating edit form from uri");
		final VerticalPanel vp = new VerticalPanel();
		vp.setStyleName("formPanel");
		try {
			ClientRepositoryToolsManager.INSTANCE.getInstance(uri, new EIInstanceCallback() {
				@Override
				public void onSuccess(final EIInstance instance) {
					vp.add(generateEditContents(instance));
				}
				
				@Override
				public void loginRequired() {
					handleLoginRequired();
				}
			});
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return vp; 
	}
	
	private static EIFormsPanel generateEditContents(final EIInstance instance) {
		Log.info("generating edit contents");
		
		EIFormsPanel formsPanel = EditFormsPanel.createEditForm(instance, instance.getInstanceClass(), ApplicationState.getInstance().getLabUri(), getEditFormRedisplay());
		return formsPanel;
	}
	
	/**
	 * This method creates a form in 'view' mode. The fields are not editable
	 * 
	 * @param eiuri
	 * @return
	 */
	public static VerticalPanel generateViewForm(final EIInstance instance) {
		final VerticalPanel vp = new VerticalPanel();
		vp.setStyleName("formPanel");
		EIFormsPanel formsPanel = new ViewFormsPanel(instance, getViewFormRedisplay());
		vp.add(formsPanel);
		
		return vp;
	}
	
	private static void handleLoginRequired() {
		Window.alert(UIMessages.PLEASE_LOGIN);
	}
	
	protected static EditFormRedisplay getEditFormRedisplay() {
		return new EditFormRedisplay() {
			
			@Override
			public void drawAfterSave(EIInstance instance) {
				// TODO: need a way to show a message!
				ApplicationState.getInstance().updateApplicationState(Mode.view, instance.getEntity(), instance.getInstanceType(), ApplicationState.getInstance().getLabEntity());				
				/*
				Datatools.clearDataPanel(); // TODO: I don't like this here At All!
				
				HTML msg = new HTML("<font color='green'>" + UIMessages.SAVE_SUCCESS + "</font>");
				Datatools.showData(msg);// TODO: I don't like this here At All!
				try {
					ClientRepositoryToolsManager.INSTANCE.getInstance(instance.getInstanceURI(), new EIInstanceCallback() {
						@Override
						public void onSuccess(EIInstance fetchedInstance) {
							viewAfterUpdate(fetchedInstance);
						}
						@Override
						public void loginRequired() {
							handleLoginRequired();
						}
					});
				} catch (Exception e) {
					Log.error("could not (re-) get instance");
				} */
			}
			
			@Override
			public void drawAfterPromote(final EIInstance instance) {
				Datatools.clearDataPanel(); // TODO: I don't like this here At All!
				try {
					ClientRepositoryToolsManager.INSTANCE.getInstance(instance.getInstanceURI(), new EIInstanceCallback() {
						@Override
						public void onSuccess(EIInstance fetchedInstance) {
							generateEditForm(fetchedInstance);
						}
						@Override
						public void loginRequired() {
							handleLoginRequired();
						}
					});
				} catch (Exception e) {
					Log.error("could not (re-) get instance");
				}
			}
			
			@Override
			public void drawAfterCancel(EIInstance instance) {
				Datatools.clearDataPanel(); // TODO: I don't like this here At All!
				try {
					ClientRepositoryToolsManager.INSTANCE.getInstance(instance.getInstanceURI(), new EIInstanceCallback() {
						@Override
						public void onSuccess(EIInstance fetchedInstance) {
							viewAfterUpdate(fetchedInstance);
						}
						@Override
						public void loginRequired() {
							handleLoginRequired();
						}
					});
				} catch (Exception e) {
					Log.error("could not (re-) get instance");
				}
				
			}

			@Override
			public void drawAfterDuplicate(EIInstance instance) {
				copyResource(instance.getInstanceURI());
			}
		};
	}
	
	protected static ViewFormRedisplay getViewFormRedisplay() {
		return new ViewFormRedisplay() {
			
			@Override
			public void drawAfterPromote(EIInstance instance) {
				Datatools.clearDataPanel(); // TODO: I don't like this here At All!
				try {
					ClientRepositoryToolsManager.INSTANCE.getInstance(instance.getInstanceURI(), new EIInstanceCallback() {
						@Override
						public void onSuccess(EIInstance fetchedInstance) {
							Datatools.showData(generateViewForm(fetchedInstance));  // TODO: any way to NOT do the showData part?
						}
						@Override
						public void loginRequired() {
							handleLoginRequired();
						}
					});
				} catch (Exception e) {
					Log.error("could not (re-) get instance");
				}
			}
			
			@Override
			public void drawAfterDuplicate(EIInstance instance) {
				copyResource(instance.getInstanceURI());
			}

			@Override
			public void drawEdit(EIInstance instance) {
				Datatools.clearDataPanel(); // TODO: I don't like this here At All!
				Datatools.showData(generateEditForm(instance));
			}
		};
	}
	
	public static void copyResource(EIURI instanceId) {
		ClientRepositoryToolsManager.INSTANCE.deepCopyInstance(instanceId, new EIInstanceCallback() {
			
			@Override
			public void loginRequired() {
				handleLoginRequired();
			}
			
			@Override
			public void onSuccess(EIInstance eiInstance) {
				Datatools.showData(generateDuplicateForm(eiInstance));
				// TODO: how to set app state to show we're editing this?
			}
		});
	}
	
	protected static EditFormRedisplay getNewFormRedisplay() {
		return new EditFormRedisplay() {
			
			@Override
			public void drawAfterSave(EIInstance instance) {
				// TODO: need a way to show a message!
				ApplicationState.getInstance().updateApplicationState(Mode.view, instance.getEntity(), instance.getInstanceType(), ApplicationState.getInstance().getLabEntity());
				/*
				MainPanel.dataPanel.clear();
				HTML msg = new HTML("<font color='green'>" + UIMessages.SAVE_SUCCESS + "</font>");
				Datatools.showData(msg);
				try {
					ClientRepositoryToolsManager.INSTANCE.getInstance(instance.getInstanceURI(), new EIInstanceCallback() {
						@Override
						public void onSuccess(EIInstance fetched) {
							ApplicationState.getInstance().updateApplicationState(Mode.view, fetched.getEntity(), ApplicationState.getInstance().getTypeEntity(), ApplicationState.getInstance().getLabEntity());
						}
						@Override
						public void loginRequired() {
							handleLoginRequired();
						}
					});
				} catch (Exception e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
				*/
			}
			
			@Override
			public void drawAfterPromote(EIInstance instance) {
				Window.alert("Cannot promote an unsaved new instance");
			}
			
			@Override
			public void drawAfterCancel(EIInstance instance) {
				Window.alert("shouldn't get here (I think)");
			}

			@Override
			public void drawAfterDuplicate(EIInstance instance) {
				copyResource(instance.getInstanceURI());
			}
		};
	}
	
	public static String getWFStateString(final EIInstance instance) {
		return instance.getWFState() == null ? "" : instance.getWFState().toString(); // TODO: make sure we need WFState() not WFState().getURI()
	}
	
	public static void viewAfterSave(boolean showSuccessMsg, EIInstance instance) {
		Datatools.clearDataPanel(); // TODO: not here!
		if(showSuccessMsg)
		{
			HTML msg = new HTML("<font color='green'>" + UIMessages.SAVE_SUCCESS + "</font>");
			Datatools.showData(msg);	
		}
		
		ApplicationState.getInstance().updateApplicationState(Mode.view, instance.getEntity(), ApplicationState.getInstance().getTypeEntity(), ApplicationState.getInstance().getLabEntity());
	}
	
	public static void viewAfterUpdate(EIInstance fetchedInstance) {
		ApplicationState.getInstance().updateApplicationState(Mode.view, fetchedInstance.getEntity(), ApplicationState.getInstance().getTypeEntity(), ApplicationState.getInstance().getLabEntity());
	}
}
