package org.eaglei.datatools.client.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.eaglei.datatools.client.Datatools;
import org.eaglei.model.gwt.rpc.ClientModelManager;
import org.eaglei.model.gwt.rpc.ClientModelManager.ClassCallback;
import org.eaglei.model.gwt.rpc.ClientModelManager.ClassDefinitionCallback;
import org.eaglei.model.gwt.rpc.ClientModelManager.TopLevelClassesCallback;

import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.ui.QueryTokenObject.Mode;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.HTMLTable.Cell;

public class LeftListPanel extends VerticalPanel implements ClientRepositoryToolsManager.SessionListener, ApplicationStateChangeListener  {
	private static final int TYPE_COLUMN = 0;
	private static final int ADD_NEW_COLUMN = 1;
	private static final int HIDDEN_URI_COLUMN_INDEX = 2;
	private static final int	LAB_NAME_ROW = 0;
	private static final int ALL_TYPES_ROW = 1;

	private boolean				signedIn		= false;
	//TODO (dbw) can we pull this list and map out of LeftPanel? for now I leave it public because it's being used in filter panel (yikes)
	
	//TODO we also need a separate list with resources related to a lab (currently hardcoded, but will come from ont soon)
	
	public static List<EIClass>	resourceTypes;
	public static Map<String, EIEntity> resourceTypeLabels = new HashMap<String, EIEntity>();
	private static Map<EIEntity, String> definitions = new HashMap<EIEntity, String>();
	private static FlexTable		labsTable		= new FlexTable(); // TODO: can this be non-static? or does that mess up the click handler?
	private static FlexTable		resourcesTable	= new FlexTable();
	private Anchor				labsLink		= new Anchor();
	private Anchor				resourcesLink	= new Anchor();
	final FlowPanel				labsPanel		= new FlowPanel();
	final FlowPanel				resourcesPanel	= new FlowPanel();
	
	public LeftListPanel() {
		Log.debug("making left list panel");
		ClientRepositoryToolsManager.INSTANCE.addSessionListener(this);
		ApplicationState.getInstance().addApplicationStateListener(this);
		signedIn = ApplicationState.getInstance().hasUser();
		if (signedIn)
			getResourceTypes();
	}
	
	@Override
	public void onApplicationStateChange() {
		drawFromApplicationState();
	}
	
	private void drawFromApplicationState() {
		if (! ApplicationState.getInstance().hasUser() && !signedIn) {
			labsTable.setVisible(false);
			resourcesTable.setVisible(false);
			return;
		}
		
		if (ApplicationState.getInstance().getMode() == Mode.labs) {
			addLabName("");
			labsTable.setVisible(false);
			resourcesTable.setVisible(false);
			selectType(labsTable);
			unselectAll(resourcesTable);
			resourcesPanel.setStyleName("panelNotSelected");
		} else if (ApplicationState.getInstance().hasLab()) {
			addLabName(ApplicationState.getInstance().getLabEntity().getLabel());
			labsTable.setVisible(true);		
			resourcesTable.setVisible(false);
			if(!ApplicationState.getInstance().hasType()) {
				unselectAll(labsTable);
				labsTable.getRowFormatter().setStyleName(ALL_TYPES_ROW, "panelSelected");
			} else {
				selectType(labsTable);
			}
			unselectAll(resourcesTable);
			resourcesPanel.setStyleName("panelNotSelected");
		} else {
			addLabName("");
			labsTable.setVisible(false);
			resourcesTable.setVisible(true);
			selectType(resourcesTable);
			unselectAll(labsTable);
			if (ApplicationState.getInstance().getMode() == Mode.resources ||
					(ApplicationState.getInstance().getMode() == Mode.filter &&
					 EIEntity.NULL_ENTITY.equals(ApplicationState.getInstance().getTypeEntity()) &&
					 EIEntity.NULL_ENTITY.equals(ApplicationState.getInstance().getLabEntity()))) {
				resourcesPanel.setStyleName("panelSelected");
				unselectAll(resourcesTable);
			}
			else {
				resourcesPanel.setStyleName("panelNotSelected");
			}
		}
	}
	
	/**
	 * Retrieves all the top level Resource Categories
	 * 
	 * @return
	 */
	private void getResourceTypes() {
		Log.debug("left panel getting resource types");
		ClientModelManager.INSTANCE.getTopLevelClasses(new TopLevelClassesCallback() {
			@Override
			public void onSuccess(List<EIClass> classList) {
				Datatools.hideGlasspane();
				Log.debug("left list panel got top level classes: " + classList.size());
				resourceTypes = classList;
				for (EIClass resourceClass : resourceTypes) {
					resourceTypeLabels.put(resourceClass.getEntity().getLabel(), resourceClass.getEntity());
				}
				getTypeDefinitions();
				//createPanel();
			}

		});
	}
	
	//FIXME this is boneheaded at the ModelService level; no need to pass around EIClasses - revisit
	private void getTypeDefinitions() {
		Log.debug("Left panel getting definitions");
		ClientModelManager.INSTANCE.getClassDefinitions(resourceTypes, new ClassDefinitionCallback() {
			@Override
			public void onSuccess(List<EIClass> result) {
				for (EIClass eclass : result) {
					definitions.put(eclass.getEntity(), eclass.getDefinition());
				}
				Log.debug("finished with definitions");
				createPanel();
			}
		});
	}
	
	/**
	 * Creates the left panel. If the user is not logged in, it will display the
	 * general view. For a valid user it displays an authenticated view.
	 */
	private void createPanel() {
		Log.debug("left list panel creating sub-panel; logged in? " + signedIn);
		labsLink.setHTML("<b> My Laboratories</b>");
		resourcesLink.setHTML("<b>My Resources</b>");
		setWidth("100");
		setStyleName("leftPanel");
		if (signedIn) {
			//Build labs section
			Anchor addNewLink = new Anchor("add new");
			addNewLink.setName(DatatoolsUIConstants.EI_LAB +"_add_new");
			labsPanel.add(labsLink);
			labsPanel.add(addNewLink);
			addNewLink.setStyleName("gwt_add_item");
			add(labsPanel);
			add(labsTable);
			labsTable.setVisible(false);
			// Create empty row for setting the selected Lab Name
			// TODO: pull out FlexPanel creation into a method --DONE
			labsTable.setText(LAB_NAME_ROW, TYPE_COLUMN, "");
			labsTable.setText(LAB_NAME_ROW, ADD_NEW_COLUMN, "");
			addAllTypesOption();
			populateTypeTable(labsTable, LabResources.resourcesEntityMap);
			
			//Build resources section
			resourcesPanel.add(resourcesLink);
			add(resourcesPanel);
			add(resourcesTable);
			resourcesTable.setVisible(ApplicationState.getInstance().getMode() == Mode.resources || ApplicationState.getInstance().hasType());
			populateTypeTable(resourcesTable, resourceTypeLabels);
			
			// Add top level handlers
			// Create New Lab
			addNewLink.addClickHandler(new ClickHandler() {
				@Override
				public void onClick(ClickEvent arg0) {
					ApplicationState.getInstance().updateApplicationState(Mode.edit, EIEntity.NULL_ENTITY, DatatoolsUIConstants.EI_LAB_ENTITY, EIEntity.NULL_ENTITY);
				}
			});
			labsLink.addClickHandler(new ClickHandler() {
				@Override
				public void onClick(ClickEvent arg0) {
					ApplicationState.getInstance().updateApplicationState(Mode.labs, EIEntity.NULL_ENTITY, DatatoolsUIConstants.EI_LAB_ENTITY, EIEntity.NULL_ENTITY);
				}
			});
			resourcesLink.addClickHandler(new ClickHandler() {
				@Override
				public void onClick(ClickEvent arg0) {
					resourcesPanel.setStyleName("panelSelected");
					ApplicationState.getInstance().updateApplicationState(Mode.resources, EIEntity.NULL_ENTITY, EIEntity.NULL_ENTITY, EIEntity.NULL_ENTITY);
				}
			});
			
			drawFromApplicationState();
		}
	}

	private void populateTypeTable(FlexTable table, Map<String, EIEntity> labelTypeEntityMap) {
		for(final Map.Entry<String, EIEntity> entry : labelTypeEntityMap.entrySet()) {
			final FlowPanel typePanel = new FlowPanel();
			final Label icon = new Label();
			icon.setStyleName("tempIcon");
			final Anchor typeLabel = new Anchor(entry.getKey());
			typeLabel.setTitle(definitions.get(entry.getValue()));
			typeLabel.setStyleName("gwt_super_type");
			typePanel.add(icon);
			typePanel.add(typeLabel);
			table.setWidget(table.getRowCount(), TYPE_COLUMN, typePanel);
			typeLabel.addClickHandler(new ClickHandler() {
				@Override
				public void onClick(ClickEvent event) {
					ApplicationState.getInstance().updateApplicationState(Mode.list, 
							EIEntity.NULL_ENTITY, 
							entry.getValue(), 
							ApplicationState.getInstance().getLabEntity(), true);
				}
			});
			final Anchor addNew = new Anchor("add new");
			addNew.setName(entry.getValue().getURI().toString() + "_add_new");
			addNew.setStyleName("gwt_add_item");
			table.setWidget(table.getRowCount() - 1, ADD_NEW_COLUMN, addNew);
			addNew.addClickHandler(new ClickHandler() {
				@Override
				public void onClick(ClickEvent event) {
					ApplicationState.getInstance().updateApplicationState(Mode.edit, 
							EIEntity.NULL_ENTITY, 
							entry.getValue(), 
							ApplicationState.getInstance().getLabEntity(), true);
				}
			});
			//FIXME - keep this for spacing until we can fix it at CSS level
			//(used to be hidden URI)
			table.setWidget(table.getRowCount() - 1, HIDDEN_URI_COLUMN_INDEX, null);
		}
	}
	
	//TODO if we want to include an All Types option in My resources, adapt this, e.g. pass row as parameter
	private void addAllTypesOption() {
		FlowPanel h = new FlowPanel();
		Label i = new Label();
		i.setStyleName("tempIcon");
		Anchor allTypesLabel = new Anchor("All Resource Types");
		allTypesLabel.setStyleName("gwt_super_type");
		h.add(i);
		h.add(allTypesLabel);
		labsTable.setWidget(ALL_TYPES_ROW, TYPE_COLUMN, h);
		//FIXME keep for spacing until we can fix CSS
		labsTable.setWidget(ALL_TYPES_ROW, HIDDEN_URI_COLUMN_INDEX, null);

		allTypesLabel.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent event) {
				ApplicationState.getInstance().updateApplicationState(Mode.list, 
						EIEntity.NULL_ENTITY, EIEntity.NULL_ENTITY, 
						ApplicationState.getInstance().getLabEntity(), true);
			}
		});
	}

	private void addLabName(String labName) {
		FlowPanel labNamePanel = new FlowPanel();
		Label labNameLabel = new Label(labName);
		labNameLabel.setStyleName("labSelected");
		labNamePanel.add(labNameLabel);
		labsTable.setWidget(LAB_NAME_ROW, TYPE_COLUMN, labNamePanel);
		//FIXME keep this for spacing until we can fix it in CSS
		labsTable.setWidget(LAB_NAME_ROW, HIDDEN_URI_COLUMN_INDEX, null);

		labNameLabel.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent event) {
				ApplicationState.getInstance().updateApplicationState(Mode.view,
						ApplicationState.getInstance().getLabEntity(), 
						DatatoolsUIConstants.EI_LAB_ENTITY,
						ApplicationState.getInstance().getLabEntity());
			}
		});
	}
	
	private void selectType(FlexTable typesTable) {
		if (ApplicationState.getInstance().hasType()) {
			String typeLabel = ApplicationState.getInstance().getTypeEntity().getLabel();
			for (int i = 0; i < typesTable.getRowCount(); i++) {
				if (typesTable.getText(i, TYPE_COLUMN).equals(typeLabel)) {
					typesTable.getRowFormatter().setStyleName(i, "panelSelected");
				}
				else {
					typesTable.getRowFormatter().setStyleName(i, "panelNotSelected");
				}
			}
		} 
		if (ApplicationState.getInstance().getMode() == Mode.resources) {
			resourcesPanel.setStyleName("panelSelected");
		}
	}	 
	
	private void unselectAll(FlexTable typesTable) {
		for (int i = 0; i < typesTable.getRowCount(); i++) {
			typesTable.getRowFormatter().setStyleName(i, "panelNotSelected");
		}
	}
	
	private FlowPanel createClassLabel(HashMap<EIClass, Anchor> mapNoDefClassToUIObject, EIClass eclass) {
		FlowPanel h = new FlowPanel();
		Label i = new Label();
		i.setStyleName("tempIcon");
		Anchor lbl = new Anchor(eclass.getEntity().getLabel());
		lbl.setStyleName("gwt_super_type");
		if (eclass.getDefinition() == null) {
			mapNoDefClassToUIObject.put(eclass, lbl);
		} else
			lbl.setTitle(eclass.getDefinition());
		h.add(i);
		h.add(lbl);
		return h;
	}
	
	private void setToolTipforClass(final Map<EIClass, Anchor> mapNoDefClassToUIObject) {
		final List<EIClass> listNoDefClasses = new ArrayList<EIClass>(mapNoDefClassToUIObject.keySet());
		ClientModelManager.INSTANCE.getClassDefinitions(listNoDefClasses, new ClassDefinitionCallback() {
			@Override
			public void onSuccess(List<EIClass> result) {
				for (EIClass clazz : result) {
					Anchor o = mapNoDefClassToUIObject.get(clazz);
					o.setTitle(clazz.getDefinition());
				}
			}
		});
	}
	@Override
	public void onLogOut() {
		signedIn = false;
		labsTable = new FlexTable();
		labsPanel.clear();
		resourcesTable = new FlexTable();
		resourcesPanel.clear();
		labsLink = new Anchor();
		resourcesLink = new Anchor();
		clear();
	}
	
	@Override
	public void onLogIn(String username, String userUri) {
		signedIn = true;
		if (resourceTypes != null && resourceTypes.size() > 0) { // TODO: right?
			createPanel();
		}
		else {
			Log.debug("left list panel logging in: about to get resource types");
			getResourceTypes();
		}
	}
	
	/**
	 * This method takes care of handling of events on the left panel and the
	 * Data panel
	 */
	
	//FIXME moved click handlers to anchors; get rid of this
	private void createHandler() {
		LeftListPanel.labsTable.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent arg0) {
				final Cell cell = labsTable.getCellForEvent(arg0);
				final String resourceLabel = cell.getElement().getInnerText();
				EIEntity eiEntity;
				Mode newMode;
				if (resourceLabel.equals("add new")) {
					String labelString = labsTable.getText(cell.getRowIndex(), TYPE_COLUMN); 
					//Log.info(" for class " + labelString);
					eiEntity = LabResources.resourcesEntityMap.get(labelString);
					newMode = Mode.edit;
				}
				else {
					eiEntity = LabResources.resourcesEntityMap.get(resourceLabel);
					newMode = Mode.list;
				}
				Log.info("updating state: mode=" + newMode + "; entity = " + eiEntity);
				ApplicationState.getInstance().updateApplicationState(newMode, EIEntity.NULL_ENTITY, eiEntity, ApplicationState.getInstance().getLabEntity(), true);
			}
		});
		
		LeftListPanel.resourcesTable.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent arg0) {
				final Cell cell = resourcesTable.getCellForEvent(arg0);
				final String resourceLabel = cell.getElement().getInnerText();
				EIEntity entity;
				Mode newMode;
				if (resourceLabel.equals("add new")) {
					String labelString = resourcesTable.getText(cell.getRowIndex(), TYPE_COLUMN); 
					entity = resourceTypeLabels.get(labelString);
					newMode = Mode.edit;
				}
				else {
					entity = resourceTypeLabels.get(resourceLabel);
					newMode = Mode.list;
				}
				
				Log.info("updating state: mode=" + newMode + "; class = " + entity);
				ApplicationState.getInstance().updateApplicationState(newMode, EIEntity.NULL_ENTITY, entity, EIEntity.NULL_ENTITY, true);
			}
		});
	}
}
