package org.eaglei.datatools.client.ui;

import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager.ResultsCallback;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstanceMinimal;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.user.client.Window;

public class OwnershipAction {

	public static final OwnershipAction	ClaimAction		= new OwnershipAction("claim", "self");
	public static final OwnershipAction	ReleaseAction	= new OwnershipAction("release", "nobody");
	final String						name;
	private final String				newOwnerString;

	private OwnershipAction(String name, String newOwner) {
		this.name = name;
		this.newOwnerString = newOwner;
	}

	public void perform(final EIInstanceMinimal instance, final ActionRedisplay redisplay) {
		Log.info("claiming " + instance.getInstanceLabel() + " for " + newOwnerString);
		try {
			ClientRepositoryToolsManager.INSTANCE.claim(instance, newOwnerString, new ResultsCallback() {

				@Override
				public void onSuccess(String[] arg0) {
					instance.setWFOwner((newOwnerString.equals("nobody") ? EIEntity.NULL_ENTITY : ApplicationState.getInstance().getUser()));
					redisplay.drawAfterClaim(instance);
				}

				@Override
				public void onSuccess(String arg0) {
					instance.setWFOwner((newOwnerString.equals("nobody") ? EIEntity.NULL_ENTITY : ApplicationState.getInstance().getUser()));
					redisplay.drawAfterClaim(instance);
				}

				@Override
				public void loginRequired() {
				}
			});
		} catch (Exception e) {
			e.printStackTrace();
			Window.alert(e.getMessage());
		}
	}

	public void perform(final EIInstanceMinimal[] instances, final ActionRedisplay redisplay) {
		//	Log.info("claiming " + instance.getInstanceLabel() + " for " + newOwnerString);
		try {
			ClientRepositoryToolsManager.INSTANCE.claim(instances, newOwnerString, new ResultsCallback() {

				@Override
				public void onSuccess(String[] arg0) {
					for (EIInstanceMinimal instance : instances) {
						instance.setWFOwner((newOwnerString.equals("nobody") ? EIEntity.NULL_ENTITY : ApplicationState.getInstance().getUser()));
					}
					redisplay.drawAfterClaim(instances);
				}

				@Override
				public void onSuccess(String arg0) {
					for (EIInstanceMinimal instance : instances) {
						instance.setWFOwner((newOwnerString.equals("nobody") ? EIEntity.NULL_ENTITY : ApplicationState.getInstance().getUser()));
					}
					redisplay.drawAfterClaim(instances);
				}

				@Override
				public void loginRequired() {
				}
			});
		} catch (Exception e) {
			e.printStackTrace();
			Window.alert(e.getMessage());
		}
	}

	public static String getErrorMsgOfOwnershipAction(String seletecChoice) {
		String base = UIMessages.BULK_CLAIM_RELEASE_ERROR;

		base = base.replace("$ACTION$", seletecChoice + "ed");

		return base;
	}
}
