package org.eaglei.datatools.client.ui;

import java.util.ArrayList;
import java.util.List;

import org.eaglei.datatools.client.WorkFlowConstants;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.ui.widgets.EditWidgetCollection;
import org.eaglei.datatools.client.ui.widgets.TermWidget;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIURI;
import org.eaglei.model.gwt.rpc.ClientModelManager;
import org.eaglei.model.gwt.rpc.ClientModelManager.ClassCallback;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;

/**
 * Collection of static utility methods required for form generation
 */
public class WidgetUtils {

	public interface InstanceSaveCallback {
		public void updateState(EIInstance newInstance);
		public void reset();
	}

	/**
	 * 
	 * @param propertyEntity
	 * @return
	 */
	public static Label createLabel(EIEntity propertyEntity) {
		if (propertyEntity == null || propertyEntity == EIEntity.NULL_ENTITY)
			return createLabel("");
		return createLabel(propertyEntity.getLabel());
	}

	public static Label createLabel(String label) {
		Label propLabel;
		if (label == null || label.equals(""))
			propLabel = new Label(label);
		else 
			propLabel = new Label(Character.toUpperCase(label.charAt(0)) + label.substring(1));
		
		propLabel.setStyleName("formLabel");
		return propLabel;
	}

	/**
	 * Some field values that are retrieved from the repo have extra bit of data
	 * attached. This method eliminates the unwanted data in the value.
	 * 
	 * @return formatted value String
	 */
	public static String formatText(String value) {
		if (value.indexOf("^") > 0) {
			return value.substring(0, value.indexOf("^"));
		}
		return value;
	}

	public static TextBox createTextField() {
		TextBox textField = new TextBox();
		textField.setStyleName("formText");
		return textField;
	}

	public static TextBox createTextFieldForResourceWidget() {
		TextBox textField = new TextBox();
		textField.setStyleName("textSuggest");
		return textField;
	}

	public static void addTermWidgetToPanel(final EIInstance eiInstance, final EIEntity propertyEntity, final EIClass range, final String selectedClassUri, final EditWidgetCollection fields, final boolean showLabel) {
		// TODO: get rid of this when we get back EIEntity in maps rather than EIURIs
		ClientModelManager.INSTANCE.getClass(EIURI.create(selectedClassUri), new ClassCallback() {


			@Override
			public void onSuccess(EIClass result) {
				Log.info("got root superclass for " + selectedClassUri + " Superclass is " + result);
				fields.addWidget(new TermWidget(eiInstance, propertyEntity, range, result, showLabel));
			}
		});
	}

	public static void addTermWidgetToPanel(final EIInstance eiInstance, final EIEntity propertyEntity, final EIClass range, final EIEntity selectedClassEntity, final HorizontalPanel tempPanel, final boolean showLabel) {
		if (selectedClassEntity == null || selectedClassEntity == EIEntity.NULL_ENTITY) {
			tempPanel.add(new TermWidget(eiInstance, propertyEntity, range, EIClass.NULL_CLASS, showLabel));
		}
		ClientModelManager.INSTANCE.getClass(selectedClassEntity.getURI(), new ClassCallback() {

			@Override
			public void onSuccess(EIClass result) {
				Log.info("got class for " + selectedClassEntity + " class is " + result);
				tempPanel.add(new TermWidget(eiInstance, propertyEntity, range, result, showLabel));
			}
		});
	}

	public static HorizontalPanel createRadioButon(final EIInstance instance, final EIEntity propertyEntity, final String originalValue) {
		HorizontalPanel hPanel = new HorizontalPanel();
		CheckBox checkBox = new CheckBox();
		if (originalValue != null) {
			Boolean booleanValue = Boolean.valueOf(originalValue);
			if (booleanValue == Boolean.FALSE) {
				if (originalValue.toLowerCase().startsWith("yes")) {
					booleanValue = Boolean.TRUE;
				}
			}
			Log.info("original value: " + originalValue + "; parsed value " + booleanValue);
			checkBox.setValue(booleanValue);
		}
		hPanel.add(createLabel(propertyEntity));
		hPanel.add(checkBox);
		checkBox.addValueChangeHandler(new ValueChangeHandler<Boolean>() {

			@Override
			public void onValueChange(ValueChangeEvent<Boolean> arg0) {
				Boolean oldValue = !(arg0.getValue());
				instance.replaceDatatypePropertyValue(propertyEntity, oldValue.toString(), arg0.getValue().toString());
				instance.replaceDatatypePropertyValue(propertyEntity, originalValue, arg0.getValue().toString());
			}
		});
		return hPanel;
	}

	public static boolean isInstanceUri(String selectedUri) {
		if (selectedUri == null || selectedUri.equals("") || selectedUri.equals(EIURI.NULL_EIURI.toString()))
			return false;
		return selectedUri.indexOf("/i/") != -1; //TODO: TOTAL HACK
	}

	public static String getWFStateString(final EIInstance instance) {
		return (instance.getWFState() == null || instance.getWFState() == EIEntity.NULL_ENTITY) ? "" : instance.getWFState().toString();
	}

	public static EIEntity getSelectedEntity(ListBox listBox) {
		final int selectedIndex = listBox.getSelectedIndex(); 
		return EIEntity.create(getSelectedUri(listBox), listBox.getItemText(selectedIndex));
	}

	@Deprecated
	public static EIURI getSelectedUri(ListBox listBox) {
		EIURI selectedUri = EIURI.create(listBox.getValue(listBox.getSelectedIndex()));
		return selectedUri;
	}

	public static boolean isLabType(EIURI range) {
		if (range == null || range == EIURI.NULL_EIURI)
			return false;
		return (range.toString().equals(DatatoolsUIConstants.EI_LAB) || range.toString().equals(DatatoolsUIConstants.EI_CORE_LAB));
	}

	public static boolean isLabProperty(EIEntity range) {
		if (range == null || range == EIEntity.NULL_ENTITY)
			return false;
		return (range.getURI().toString().equals(DatatoolsUIConstants.EI_LAB) || range.getURI().toString().equals(DatatoolsUIConstants.EI_CORE_LAB));
	}

	public static boolean isLabProperty(EIClass range) {
		if (range == null || range.getEntity() == null)
			return false;
		return isLabProperty(range.getEntity());
	}

	public static PopupPanel createDialog(final EIInstance parentInstance, final EIClass range, final EIEntity propertyEntity, final EIURI oldValue, final int position, final InstanceSaveCallback innerCallback) {
		final EagleIPopup window = new EagleIPopup("100%", "100%");
		final VerticalPanel vPanel = new VerticalPanel();
		window.setWidget(vPanel);
		window.setModal(false);
		window.setAnimationEnabled(true);
		final EditFormRedisplay redisplay = new EditFormRedisplay() {

			@Override
			public void drawAfterPromote(EIInstance instance) {
			}

			@Override
			public void drawAfterDuplicate(EIInstance instance) {
			}

			@Override
			public void drawAfterSave(EIInstance instance) {
				innerCallback.updateState(instance);
				window.hide();
			}

			@Override
			public void drawAfterCancel(EIInstance instance) {
				innerCallback.reset();
				window.hide();
			}
		};
		final VerticalPanel newPanel = FormsPanelFactory.generateNewForm(range.getEntity().getURI(), true, redisplay);
		vPanel.add(newPanel);
		return window;
	}

	public static String formatDate(String dt) {
		String date = "";
		if (dt != null)
			date = dt.substring(0, dt.indexOf("T"));
		return date;
	}

	//TODO revise this -where should it go?
	//Is this different than editableStates in ClientRepositoryToolsManager
	private static List<EIURI>	editableReadableStates	= new ArrayList<EIURI>(4);
	static {
		if (ClientRepositoryToolsManager.INSTANCE.canEdit(WorkFlowConstants.DRAFT_URI))
			editableReadableStates.add(WorkFlowConstants.DRAFT_URI);
		if (ClientRepositoryToolsManager.INSTANCE.canEdit(WorkFlowConstants.CURATION_URI))
			editableReadableStates.add(WorkFlowConstants.CURATION_URI);
		if (ClientRepositoryToolsManager.INSTANCE.canEdit(WorkFlowConstants.PUBLISH_URI))
			editableReadableStates.add(WorkFlowConstants.PUBLISH_URI);
		if (ClientRepositoryToolsManager.INSTANCE.canEdit(WorkFlowConstants.WITHDRAW_URI))
			editableReadableStates.add(WorkFlowConstants.WITHDRAW_URI);
	}

	public static List<EIURI> getEditableReadableStates() {
		return editableReadableStates;
	}
	
	public static String getExtendedPropertyLabel(String typeLabel, String propertyName) {
		return capitalizeFirst(typeLabel) + " " + lowerCaseFirst(propertyName);
		
	}
	
	public static String capitalizeFirst(String s) {
    	char first = s.charAt(0);
    	String S =Character.toUpperCase(first) + s.substring(1);
    	return S;
    }
	
	public static String lowerCaseFirst(String S) {
		char first = S.charAt(0);
    	String s =Character.toLowerCase(first) + S.substring(1);
    	return s;
		
	}
}
