package org.eaglei.datatools.client.ui.widgets;

import org.eaglei.datatools.client.ui.WidgetUtils;
import org.eaglei.model.EIEntity;

import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;

public class LabelValuesWidget extends Composite{
	HorizontalPanel labelValuePanel = new HorizontalPanel();
	VerticalPanel valuesPanel = new VerticalPanel();
	
	public LabelValuesWidget(EIEntity propertyEntity) {
		initWidget(labelValuePanel);
		Label propLabel = WidgetUtils.createLabel(propertyEntity);
		labelValuePanel.add(propLabel);
		labelValuePanel.add(valuesPanel);
	}
	
	// for non-ontology prop
	public LabelValuesWidget(String propertyLabel) {
		initWidget(labelValuePanel);
		Label propLabel = WidgetUtils.createLabel(propertyLabel);
		labelValuePanel.add(propLabel);
		labelValuePanel.add(valuesPanel);
	}
	
	
	public void add(Widget widget) {
		valuesPanel.add(widget);
	}
}
