package org.eaglei.datatools.client.ui.widgets;

import org.eaglei.datatools.client.ui.WidgetUtils;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;

import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.ui.TextArea;

public class TextAreaWidget extends EditWidget{

	private TextArea valueField = new TextArea();

	public TextAreaWidget(EIInstance eiInstance, EIEntity propertyEntity, String propertyValue) {
		this(eiInstance, propertyEntity, propertyValue, false);
	}
	
	public TextAreaWidget(EIInstance eiInstance, EIEntity propertyEntity, String propertyValue, boolean isDatatype) {
		super(eiInstance, propertyEntity);
		valueField.setName(propertyEntity.getURI().toString());
		oldValue = propertyValue;
		setup(isDatatype);
	}

	
	
	private void setup(boolean isDatatype) {
		//Label propLabel = WidgetUtils.createLabel(propertyEntity);
		if(hasOldValue()) {
			valueField.setText(WidgetUtils.formatText(oldValue));
		}
		//widgetPanel.add(propLabel);
		widgetPanel.add(valueField);
		
		valueField.addValueChangeHandler(getValueChangedHandler(isDatatype));
	}

	private ValueChangeHandler<String> getValueChangedHandler(boolean isDatatype) {
		if (isDatatype) {
			return new ValueChangeHandler<String>() {
				@Override
				public void onValueChange(ValueChangeEvent<String> changedValue) {
					if(hasOldValue()) {
						eiInstance.replaceDatatypePropertyValue(propertyEntity, oldValue, changedValue.getValue());
					} else {
						eiInstance.addDatattypeProperty(propertyEntity, changedValue.getValue());
					}
					updateOldValue(changedValue.getValue());
				}
			};
		}
		return new ValueChangeHandler<String>() {
			@Override
			public void onValueChange(ValueChangeEvent<String> changedValue) {
				if(hasOldValue()) {
					eiInstance.replaceNonOntologyLiteralProperty(propertyEntity, oldValue, changedValue.getValue());
				} else {
					eiInstance.addNonOntologyLiteralProperty(propertyEntity, changedValue.getValue());
				}
				updateOldValue(changedValue.getValue());
			}
		};
	}

	@Override
	public EditWidget duplicateBlank() {
		return new TextAreaWidget(eiInstance, propertyEntity, null);
	}

	@Override
	protected void removeValue() {
		if (hasOldValue())
			eiInstance.replaceNonOntologyLiteralProperty(propertyEntity, oldValue, null);
	}
	
	
}
