package org.eaglei.datatools.client.ui;

import java.util.HashMap;
import java.util.Map;

import org.eaglei.model.EIEntity;
import static org.eaglei.ui.gwt.instance.EagleIEntityConstants.*;

public class DatatoolsUIConstants {

	// Pagination
	public static final Integer DEFAULT_PAGE_SIZE = new Integer( 20 );

	// FIXME - relocate URIs and entities to EagleIEntityConstants; review which are still needed
	// Property URIs
	public static final String COMMENTS = "http://eagle-i.org/ont/datatools/1.0/user_comments";
	public static final String COMMENTS_LABEL = "Comments";
	public static final String CURATOR_NOTE = "http://purl.obolibrary.org/obo/IAO_0000232";
	public static final String CURATOR_LABEL = "Curator note";
	// Entities
	public static final EIEntity termRequestEntity = EIEntity.create( "http://eagle-i.org/ont/datatools/1.0/has_term_request", "Term Request" );

	public static final EIEntity personEntity = EIEntity.create( FOAF_PERSON, "Person" );
	public static final EIEntity organizationEntity = EIEntity.create( EI_ORGANIZATION, "Organization" );
	public static final EIEntity documentEntity = EIEntity.create( "http://purl.obolibrary.org/obo/IAO_0000310", "Document");
	
	public static final EIEntity isStubEntity = EIEntity.create( "http://eagle-i.org/ont/datatools/1.0/is_stub", "Is stub" );

	// Actions (to be displayed in buttons and lists of actions)
	public static final String SAVE_ACTION = "Save Resource";
	// Buttons and states labels
	public static final String FORM_ACTIONS_TITLE = "Form Actions";
	public static final String WORKFLOW_ACTIONS_TITLE = "Workflow Actions";
	public static final String DUPLICATE_ACTION = "Duplicate Resource";
	public static final String EDIT_ACTION = "Edit Resource";

}
