package org.eaglei.datatools.client.ui.widgets;

import org.eaglei.datatools.client.ApplicationState;
import org.eaglei.datatools.client.QueryTokenObject.Mode;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIURI;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;

public class LeftListRowWidget extends FlowPanel {
	private final EIClass eiClass;
	private final EIEntity eiEntity;

	public LeftListRowWidget(EIClass eiClass, final String titleText, final boolean canAdd) {
		super();
		this.eiClass = eiClass;
		eiEntity = eiClass.getEntity();
		init( titleText, canAdd, eiClass.getEntity() );
	}

	/* constructor which takes EIEntity, this is for use when we don't have EIClass but we know EIEntity */
	/*TODO :  see if by adding this constructor has any implications on other part of code and remove the canAdd boolean from the argument */
	public LeftListRowWidget(EIEntity eiEntity, final String titleText, final boolean canAdd) {
		super();
		eiClass = null;
		this.eiEntity = eiEntity;
		init( titleText, canAdd, eiEntity );
	}
	
	public EIEntity getEntity() {
		return eiEntity;
	}
	
	@Override
	public String toString() {
		return eiEntity.getLabel();
	}

	private void init(final String titleText, final boolean canAdd, final EIEntity entity) {
		if ( canAdd ) {
			final HTML addNew = new HTML( "<a>add new</a>" );
			add( addNew );
			addNew.setStyleName( "leftPanelSubAddNew" );
			addNew.addStyleName( "liveLink" );
			addNew.addClickHandler( new ClickHandler() {

				@Override
				public void onClick(ClickEvent event) {
					ApplicationState.getInstance().updateApplicationState( Mode.edit, EIEntity.NULL_ENTITY, entity, ApplicationState.getInstance().getLabEntity(), true );

					// TODO: figure out a way to pass the class instead...
				}
			} );
		}

		final HTML classLabel = new HTML( "<a>" + entity.getLabel() + "</a>" );
		add( classLabel );
		classLabel.setStyleName( "liveLink" ); // was leftPanelSubHeaderText
		classLabel.setTitle( titleText );
		classLabel.addClickHandler( new ClickHandler() {

			@Override
			public void onClick(ClickEvent event) {
				EIEntity correctEntity = entity.getURI().equals( EIURI.NULL_EIURI ) ? EIEntity.NULL_ENTITY : entity;
				ApplicationState.getInstance().updateApplicationState( Mode.list, EIEntity.NULL_ENTITY, correctEntity, ApplicationState.getInstance().getLabEntity(), true );
			}

		} );

	}

}
