/**
 * The eagle-i consortium
 * Harvard University
 * Dec 6, 2010
 */
package org.eaglei.datatools.client.ui.widgets;

import org.eaglei.datatools.client.ApplicationState;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;

/**
 * based on org.eaglei.ui.gwt.search.results.NavBar;
 * 
 */
public class PaginationWidget extends FlowPanel {
	public interface PageListener {
		void onPreviousPage();

		void onNextPage();
	}

	private final Anchor paginateButton = new Anchor ( " paginate ");
	private final Anchor previousButton = new Anchor( "< previous" );
	private final Label disabledPreviousButton = new Label( "< previous" );
	private final Anchor nextButton = new Anchor( "next >" );
	private final Label countLabel;
	private final Anchor viewAllButton = new Anchor( " view all " );
	private final ListBox pageSizeList = new ListBox();
	public PaginationWidget(final Integer offset, final Integer count, final Integer pageSize) {
		super();
		addClickHandlers( pageSize );
		initializePageSizeList();

		paginateButton.setStyleName("dtPaginateFrame");
		previousButton.setStyleName("dtPaginateFrame");
		disabledPreviousButton.setStyleName("dtPaginateFrame");
		disabledPreviousButton.addStyleName( "dtPaginateDisabled" );
		nextButton.setStyleName("dtPaginateFrame");
		viewAllButton.setStyleName("dtPaginateFrame");
		pageSizeList.addStyleName("dtPaginateFrame");


		if ( offset != null && pageSize != null) {
			//setVisibility( previousButton, offset != 0 );
			//FIXME what to do if last page has default_page_size? 
			//setVisibility(nextButton, count == pageSize);
			countLabel = new Label( " " + ( offset + 1 ) + " - " + ( pageSize + offset ) + " " );
			countLabel.setStyleName("dtPaginateFrame");
			if(offset == 0) {
				add( disabledPreviousButton );
			} else {
				add( previousButton );
			}
			add( countLabel );
			add( nextButton );
			//add( viewAllButton );
			add( pageSizeList );
		} else {
			countLabel = new Label( " 1 - " + count + " " );
			countLabel.setStyleName("dtPaginateFrame");
			add( countLabel );
			//add( paginateButton );
			add( pageSizeList );
		}
	}


	private void initializePageSizeList() {
		final String[] options = {"10", "20", "50", "100"};
		for( String option : options) {
			pageSizeList.addItem( /*"view " +*/ option, option );
			if(ApplicationState.getInstance().getLimit() != null && 
					option.equals( ApplicationState.getInstance().getLimit().toString() )) {
				pageSizeList.setSelectedIndex( pageSizeList.getItemCount() - 1 );
			}
		}
		pageSizeList.addItem( "view all", "all");
		if(!ApplicationState.getInstance().isPaginated()) {
			pageSizeList.setSelectedIndex( pageSizeList.getItemCount() - 1 );
		}
		pageSizeList.addChangeHandler( new ChangeHandler() {

			@Override
			public void onChange(ChangeEvent event) {
				final String selectedText = pageSizeList.getValue( pageSizeList.getSelectedIndex() );
				if("all".equals( selectedText )) {
					ApplicationState.getInstance().updatePaging( ApplicationState.getInstance().getSortBy(), null, null );
				} else {
					ApplicationState.getInstance().updatePaging( ApplicationState.getInstance().getSortBy(), 
							0, new Integer(selectedText) );
				}
			}
		});
	}


	private void addClickHandlers(final Integer pageSize) {
		paginateButton.addClickHandler ( new ClickHandler() {

			@Override
			public void onClick(ClickEvent event) {
				ApplicationState.getInstance().updateToDefaultPaging();
				
			}
			
		});
		nextButton.addClickHandler( new ClickHandler() {

			@Override
			public void onClick(final ClickEvent event) {
				ApplicationState.getInstance().updatePaging( ApplicationState.getInstance().getSortBy(), 
						ApplicationState.getInstance().getOffset() + pageSize, pageSize );
			}

		} );
		previousButton.addClickHandler( new ClickHandler() {

			@Override
			public void onClick(final ClickEvent event) {
				ApplicationState.getInstance().updatePaging( ApplicationState.getInstance().getSortBy(), 
						ApplicationState.getInstance().getOffset() - pageSize, pageSize );

			}

		} );

		viewAllButton.addClickHandler( new ClickHandler() {

			@Override
			public void onClick(final ClickEvent event) {
				ApplicationState.getInstance().updatePaging( ApplicationState.getInstance().getSortBy(), null, null );
			}

		} );
	}

/*	private void setVisibility(final Widget widget, final boolean visible) {
		widget.setVisible( visible );
	}*/

}
