/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.client.rpc;

import com.google.gwt.core.client.GWT;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.Cookies;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eaglei.datatools.SortByProperties;
import org.eaglei.datatools.User;
import org.eaglei.datatools.WorkFlowTransition;
import org.eaglei.datatools.client.ApplicationState;
import org.eaglei.datatools.client.DatatoolsCookies;
import org.eaglei.datatools.client.WorkFlowConstants;
import org.eaglei.datatools.client.logging.GWTLogger;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.rpc.RepositoryToolsModelService;
import org.eaglei.datatools.client.rpc.RepositoryToolsModelServiceAsync;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIInstanceMinimal;
import org.eaglei.model.EIProperty;
import org.eaglei.model.EIURI;
import org.eaglei.model.gwt.rpc.ClientModelManager;
import org.eaglei.model.gwt.rpc.LoggedException;
import org.eaglei.model.gwt.rpc.ModelService;
import org.eaglei.model.gwt.rpc.ModelServiceAsync;
import org.eaglei.search.provider.AuthSearchRequest;
import org.eaglei.security.Session;
import org.eaglei.ui.gwt.instance.EagleIEntityConstants;

/*
 * Exception performing whole class analysis ignored.
 */
public class ClientRepositoryToolsManager {
    public static final ClientRepositoryToolsManager INSTANCE = new ClientRepositoryToolsManager();
    public static RepositoryToolsModelServiceAsync repositoryService;
    public static ModelServiceAsync modelService;
    private final HashMap<EIURI, EIClass> mapIdToClass = new HashMap();
    private Session session;
    private User user;
    private ArrayList<SessionListener> listeners;
    private static final GWTLogger log;

    private ClientRepositoryToolsManager() {
        repositoryService = (RepositoryToolsModelServiceAsync)GWT.create(RepositoryToolsModelService.class);
        modelService = (ModelServiceAsync)GWT.create(ModelService.class);
    }

    public boolean isLoggedIn() {
        return Session.isValid((Session)this.session);
    }

    public void initializeAfterRefresh() {
        this.session = DatatoolsCookies.getSession();
    }

    private void handleLogOut() {
        this.session = null;
        this.user = null;
        Cookies.removeCookie((String)"datatools_username");
        Cookies.removeCookie((String)"datatools_userUri");
        Cookies.removeCookie((String)"datatools_session");
        log.info("removed cookies");
        if (this.listeners != null) {
            for (SessionListener listener : this.listeners) {
                listener.onLogOut();
            }
        }
    }

    public void addSessionListener(SessionListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(listener);
    }

    public void logOut() {
        if (!this.isLoggedIn()) {
            return;
        }
        try {
            repositoryService.logout(this.session, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void logIn(String username, String password, UserCallback callback) {
        if (this.isLoggedIn()) {
            try {
                repositoryService.whoami(this.session, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
            }
            catch (Exception e) {}
        } else {
            try {
                repositoryService.login(username, password, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void getToken(EIInstance instance, TokenCallback callback) throws Exception {
        repositoryService.getToken(this.session, instance, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void getTokens(List<EIInstance> instances, TokensCallback callback) throws Exception {
        repositoryService.getTokens(this.session, instances, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void updateInstance(EIInstance eiInstance, String token, SaveResultsCallback callback) throws Exception {
        repositoryService.updateInstance(this.session, eiInstance, token, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void updateInstances(Map<EIInstance, String> instancesWithTokens, SaveResultsCallback callback) throws Exception {
        repositoryService.updateInstances(this.session, instancesWithTokens, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void getInstance(EIURI eiURI, EIInstanceCallback callback) throws Exception {
        repositoryService.getInstance(this.session, eiURI, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void deleteInstance(EIURI instanceUri, DeleteInstanceCallback callback) throws Exception {
        repositoryService.deleteInstance(this.session, instanceUri, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public boolean canEdit(EIURI workflowState) {
        return this.user.canEdit(workflowState);
    }

    public boolean canClaim(EIInstance instance) {
        if (ClientRepositoryToolsManager.isNotNull((EIEntity)instance.getWFState())) {
            return !this.instanceHasAnyOwner(instance) && this.canEdit(instance.getWFState().getURI());
        }
        return true;
    }

    public boolean canClaim(EIInstanceMinimal instance) {
        return !this.instanceHasAnyOwner(instance) && this.canEdit(instance.getWFStateUri());
    }

    public boolean canEdit(EIInstanceMinimal instance) {
        return this.instanceHasCurrentOwner(instance) && this.canEdit(instance.getWFStateUri());
    }

    public boolean canEdit(EIInstance instance) {
        if (ClientRepositoryToolsManager.isNotNull((EIEntity)instance.getWFState())) {
            return this.instanceHasCurrentOwner(instance) && this.canEdit(instance.getWFState().getURI());
        }
        return true;
    }

    public void listResourcesForObjectPropertyValue(EIURI classUri, EIURI lab, EIURI state, boolean onlyLab, MinimalEIInstancesCallback callback) throws Exception {
        repositoryService.listResourcesForObjectPropertyValue(this.session, classUri, lab, state, onlyLab, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void listResources(AuthSearchRequest queryRequest, SortByProperties orderBy, boolean strictOwnerFilter, MinimalEIInstancesCallback callback) throws Exception {
        this.listResources(queryRequest, orderBy, strictOwnerFilter, false, callback);
    }

    public void listResources(AuthSearchRequest queryRequest, SortByProperties orderBy, boolean strictOwnerFilter, boolean stubsOnly, MinimalEIInstancesCallback callback) throws Exception {
        repositoryService.listResources(this.session, queryRequest, orderBy, strictOwnerFilter, stubsOnly, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void listReferencingResources(EIURI resourceUri, AuthSearchRequest queryRequest, SortByProperties orderBy, boolean strictOwnerFilter, MinimalEIInstancesCallback callback) throws Exception {
        repositoryService.listReferencingResources(this.session, resourceUri, queryRequest, orderBy, strictOwnerFilter, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void getNewInstanceID(int count, IdCallback callback) {
        try {
            repositoryService.getNewInstanceID(this.session, count, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void createInstances(List<EIInstance> instances, EIInstancesCallback callback) {
        try {
            repositoryService.createInstances(this.session, instances, ApplicationState.getInstance().getWorkspaceEntity(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void createInstance(EIInstance instance, EIInstanceCallback callback) {
        try {
            log.info("creating instance " + instance.getEntity() + " with type " + instance.getInstanceClass());
            repositoryService.createInstance(this.session, instance, ApplicationState.getInstance().getWorkspaceEntity(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void getEmptyEIInstance(EIURI classUri, EIEntity instanceEntity, EIInstanceCallback callback) {
        repositoryService.getEmptyEIInstance(this.session, classUri, instanceEntity, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void getEmptyEIInstance(EIURI classUri, EIInstanceCallback callback) {
        repositoryService.getEmptyEIInstance(this.session, classUri, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void deepCopyInstance(EIURI originalUri, EIInstanceCallback callback) {
        try {
            repositoryService.deepCopy(this.session, originalUri, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
    }

    public void whoami(UserCallback callback) throws Exception {
        if (repositoryService == null) {
            repositoryService = (RepositoryToolsModelServiceAsync)GWT.create(RepositoryToolsModelService.class);
        }
        Session session = DatatoolsCookies.getSession();
        repositoryService.whoami(session, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void claim(EIInstanceMinimal instance, EIInstanceCallback callback) {
        this.claim(new EIInstanceMinimal[]{instance}, (BulkWorkflowCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void claim(EIInstanceMinimal[] instances, BulkWorkflowCallback callback) {
        try {
            HashMap<EIURI, EIInstanceMinimal> instanceUriMap = new HashMap<EIURI, EIInstanceMinimal>();
            for (EIInstanceMinimal instance : instances) {
                instanceUriMap.put(instance.getInstanceURI(), instance);
            }
            repositoryService.getModifiedDates(this.session, new ArrayList(instanceUriMap.keySet()), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (Exception e) {
            callback.onFailure(e.toString());
        }
    }

    protected void partitionOKUris(Map<EIURI, EIInstanceMinimal> instanceUriMap, Map<EIURI, String> uriModificationDateMap, List<EIURI> unchangedUris, List<EIURI> outdatedUris) {
        DateTimeFormat dateFormat = DateTimeFormat.getFormat((String)"yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        for (EIURI uri : instanceUriMap.keySet()) {
            String repositoryDateString = uriModificationDateMap.get(uri);
            if (repositoryDateString == null) {
                log.warn("no modification date from repository for " + uri);
                continue;
            }
            String instanceDateString = instanceUriMap.get(uri).getModifiedDate();
            if (instanceDateString == null) {
                outdatedUris.add(uri);
                return;
            }
            if (instanceDateString.indexOf("^") != -1) {
                instanceDateString = instanceDateString.substring(0, instanceDateString.indexOf("^"));
            }
            try {
                Date repositoryModification = dateFormat.parse(repositoryDateString);
                Date instanceModification = dateFormat.parse(instanceDateString);
                if (repositoryModification.after(instanceModification)) {
                    outdatedUris.add(uri);
                    continue;
                }
                unchangedUris.add(uri);
            }
            catch (IllegalArgumentException e) {
                log.info("could not convert date " + e);
                e.printStackTrace();
            }
        }
    }

    public void release(EIInstanceMinimal instance, EIInstanceCallback callback) {
        this.release(new EIInstanceMinimal[]{instance}, (BulkWorkflowCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void release(EIInstanceMinimal[] instances, BulkWorkflowCallback callback) {
        try {
            HashMap<EIURI, EIInstanceMinimal> instanceUriMap = new HashMap<EIURI, EIInstanceMinimal>();
            for (EIInstanceMinimal instance : instances) {
                instanceUriMap.put(instance.getInstanceURI(), instance);
            }
            repositoryService.release(this.session, new ArrayList(instanceUriMap.keySet()), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (Exception e) {
            callback.onFailure(e.toString());
            e.printStackTrace();
        }
    }

    public static boolean isNotNull(EIEntity entity) {
        return entity != null && !EIEntity.NULL_ENTITY.equals((Object)entity);
    }

    public static boolean isNotNull(EIInstance instance) {
        return instance != null && !EIInstance.NULL_INSTANCE.equals(instance);
    }

    public boolean instanceHasCurrentOwner(EIInstance instance) {
        return ClientRepositoryToolsManager.isNotNull((EIEntity)instance.getWFOwner()) && instance.getWFOwner().equals((Object)this.user.getUserEntity());
    }

    public boolean instanceHasCurrentOwner(EIInstanceMinimal instance) {
        return ClientRepositoryToolsManager.isNotNull((EIEntity)instance.getWFOwner()) && instance.getWFOwner().equals((Object)this.user.getUserEntity());
    }

    public boolean instanceHasAnyOwner(EIInstance instance) {
        return ClientRepositoryToolsManager.isNotNull((EIEntity)instance.getWFOwner());
    }

    public boolean instanceHasAnyOwner(EIInstanceMinimal instance) {
        return ClientRepositoryToolsManager.isNotNull((EIEntity)instance.getWFOwner());
    }

    public void transition(EIInstance instance, WorkFlowTransition transition, EIInstanceCallback callback) {
        this.transition(new EIInstanceMinimal[]{EIInstanceMinimal.create((EIInstance)instance)}, transition, (BulkWorkflowCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void transition(EIInstanceMinimal[] eiInstanceMinimals, WorkFlowTransition transition, BulkWorkflowCallback callback) {
        try {
            if (transition == null) {
                log.error("null transition!");
                callback.onFailure(null);
            }
            HashMap<EIURI, EIInstanceMinimal> instanceUriMap = new HashMap<EIURI, EIInstanceMinimal>();
            for (EIInstanceMinimal instance : eiInstanceMinimals) {
                instanceUriMap.put(instance.getInstanceURI(), instance);
            }
            repositoryService.transition(this.session, new ArrayList(instanceUriMap.keySet()), transition.getEntity(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (Exception e) {
            callback.onFailure(e.toString());
            e.printStackTrace();
        }
    }

    public void retrieveLabel(EIURI uri, ResultsCallback callback) {
        repositoryService.retrieveLabel(this.session, uri, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void getRootSuperclassForInstanceUri(EIURI instanceUri, ClientModelManager.ClassCallback callback) {
        try {
            repositoryService.getRootSuperclassForInstanceUri(this.session, instanceUri, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (Exception e) {
            log.error("modelService.getRootSuperclassForInstanceUri threw exception " + e.toString());
            e.printStackTrace();
        }
    }

    public void getClassAndSuperclassesForInstanceUri(EIURI instanceUri, EIClassesCallback callback) {
        try {
            repositoryService.getClassAndSuperclassesForInstanceUri(this.session, instanceUri, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (Exception e) {
            log.error("modelService.getSuperclassesForInstanceUri threw exception " + e.toString());
            e.printStackTrace();
            callback.onFailure(e.toString());
        }
    }

    public List<WorkFlowTransition> getAllowedTransitions() {
        return this.user.getAllowedTransitions();
    }

    public List<WorkFlowTransition> getAllowedTransitions(EIInstance instance) {
        return this.getAllowedTransitions(instance.getWFState());
    }

    public List<WorkFlowTransition> getAllowedTransitions(EIInstanceMinimal instance) {
        return this.getAllowedTransitions(instance.getWFState());
    }

    private List<WorkFlowTransition> getAllowedTransitions(EIEntity workflowState) {
        if (ClientRepositoryToolsManager.isNotNull((EIEntity)workflowState)) {
            return this.user.getAllowedTransitionsForState(workflowState.getURI());
        }
        return this.user.getAllowedTransitionsForState(WorkFlowConstants.DRAFT_URI);
    }

    private void handleFailure(LoginRequiredCallback callback, Throwable arg0) {
        if (arg0 instanceof LoggedException) {
            if (arg0.getMessage().contains("No session information was found")) {
                callback.loginRequired();
            } else {
                Window.alert((String)arg0.getMessage());
            }
        } else {
            callback.loginRequired();
        }
    }

    public void getSuperClass(EIClass eclass, DatatoolsClassCallback callback) {
        repositoryService.getSuperClass(eclass, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void getRootSuperClass(EIClass eclass, DatatoolsClassCallback callback) {
        repositoryService.getRootSuperClass(eclass, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void getLabRootSuperclass(DatatoolsClassCallback callback) {
        if (this.mapIdToClass.containsKey(EagleIEntityConstants.EI_LAB_URI)) {
            callback.onSuccess((EIClass)this.mapIdToClass.get(EagleIEntityConstants.EI_LAB_URI));
        } else {
            modelService.getClass(EagleIEntityConstants.EI_LAB_URI, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    public void getEquivalentClasses(List<EIProperty> propertiesToPopulate, EquivalentClassesCallback callback) {
        repositoryService.getAllEquivalentClasses(propertiesToPopulate, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void getTopClassesAnotatedByDataModelCreate(TopLevelClassesCallback callback) {
        repositoryService.getTopClassesAnotatedByDataModelCreate((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void isModelClassURI(EIURI eiuri, AsyncCallback<Boolean> callback) {
        repositoryService.isModelClassURI(eiuri, callback);
    }

    static /* synthetic */ void access$000(ClientRepositoryToolsManager x0) {
        x0.handleLogOut();
    }

    static /* synthetic */ Session access$102(ClientRepositoryToolsManager x0, Session x1) {
        x0.session = x1;
        return x0.session;
    }

    static /* synthetic */ User access$202(ClientRepositoryToolsManager x0, User x1) {
        x0.user = x1;
        return x0.user;
    }

    static /* synthetic */ Session access$100(ClientRepositoryToolsManager x0) {
        return x0.session;
    }

    static /* synthetic */ GWTLogger access$300() {
        return log;
    }

    static /* synthetic */ ArrayList access$400(ClientRepositoryToolsManager x0) {
        return x0.listeners;
    }

    static /* synthetic */ void access$500(ClientRepositoryToolsManager x0, LoginRequiredCallback x1, Throwable x2) {
        x0.handleFailure(x1, x2);
    }

    static /* synthetic */ User access$200(ClientRepositoryToolsManager x0) {
        return x0.user;
    }

    static /* synthetic */ HashMap access$600(ClientRepositoryToolsManager x0) {
        return x0.mapIdToClass;
    }

    static {
        log = GWTLogger.getLogger((String)"ClientRepositoryToolsManager");
    }
}

