/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.client.ui;

import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eaglei.datatools.client.ui.OntologyPropertiesRenderer;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIURI;
import org.eaglei.ui.gwt.instance.widgets.InstanceWidgetUtils;
import org.eaglei.ui.gwt.instance.widgets.LabelValuesWidget;

public abstract class DataToolsBasicInstancePanel<T extends OntologyPropertiesRenderer>
extends Composite {
    private OntologyPropertiesRenderer opr;
    protected final VerticalPanel outerFormPanel = new VerticalPanel();
    protected VerticalPanel formPanel = new VerticalPanel();
    protected VerticalPanel ontologyPanel = new VerticalPanel();
    protected EIInstance eiInstance;
    protected T ontologyPropRenderer;
    protected boolean shouldShowReadOnlyProperties = true;

    protected abstract void drawAdminProperties();

    protected abstract void drawReferencedBy();

    protected abstract void drawExtraFields(Map<EIEntity, Set<String>> var1);

    protected abstract Collection<EIEntity> getNonOntologyLiteralPropEntities();

    protected abstract Collection<EIEntity> getNonOntologyResourcePropEntities();

    public DataToolsBasicInstancePanel(EIInstance instance) {
        this.eiInstance = instance;
        this.initWidget((Widget)this.outerFormPanel);
        this.outerFormPanel.setStyleName("formPanel");
        this.formPanel.setStyleName("formPanel");
        this.ontologyPanel.setStyleName("formPanel");
        this.initializeSpecifics();
    }

    protected DataToolsBasicInstancePanel() {
        this.initWidget((Widget)this.outerFormPanel);
        this.outerFormPanel.setStyleName("formPanel");
        this.formPanel.setStyleName("formPanel");
        this.ontologyPanel.setStyleName("formPanel");
    }

    protected void initializeSpecifics() {
        this.formPanel.add((Widget)this.ontologyPanel);
        this.constructForm();
        this.outerFormPanel.add((Widget)this.formPanel);
    }

    public EIInstance getInstance() {
        return this.eiInstance;
    }

    protected void constructForm() {
        Map instanceNonOntologyLiteralProperties = this.eiInstance.getNonOntologyLiteralProperties();
        this.drawExtraFields(instanceNonOntologyLiteralProperties);
        this.drawReferencedBy();
        this.drawAdminProperties();
    }

    protected HashSet<String> makeSetFromSingle(String value) {
        return new HashSet<String>(Arrays.asList(value));
    }

    protected HashSet<EIURI> makeSetFromSingleURI(EIURI value) {
        return new HashSet<EIURI>(Arrays.asList(value));
    }

    protected HashSet<EIEntity> makeSetFromSingleEntity(EIEntity value) {
        return new HashSet<EIEntity>(Arrays.asList(value));
    }

    protected Widget handleReadOnlyTextProperty(String value) {
        if (value.startsWith("www") || value.startsWith("http")) {
            return new Anchor(InstanceWidgetUtils.formatText((String)value), InstanceWidgetUtils.formatText((String)value), "_blank");
        }
        HTML valueField = new HTML(InstanceWidgetUtils.formatText((String)InstanceWidgetUtils.insertBreaks((String)value)));
        valueField.setStyleName("formLabelValue");
        return valueField;
    }

    protected void drawReadOnlyLiteralProperty(EIEntity propertyEntity, Set<String> propertyValues, Map<EIEntity, String> labelMap, VerticalPanel nonOntologyPanel) {
        String propLabel = labelMap == null || labelMap.get(propertyEntity) == null || labelMap.get(propertyEntity).equals("") ? propertyEntity.getLabel() : labelMap.get(propertyEntity);
        LabelValuesWidget widget = new LabelValuesWidget(propLabel);
        for (String value : propertyValues) {
            widget.add(this.handleReadOnlyTextProperty(value));
        }
        nonOntologyPanel.add((Widget)widget);
    }

    protected void drawReadOnlyResourceProperty(EIEntity propertyEntity, Set<EIEntity> propertyValues, Map<EIEntity, String> labelMap, VerticalPanel nonOntologyPanel) {
        String propLabel = labelMap == null || labelMap.get(propertyEntity) == null || labelMap.get(propertyEntity).equals("") ? propertyEntity.getLabel() : labelMap.get(propertyEntity);
        LabelValuesWidget widget = new LabelValuesWidget(propLabel);
        for (EIEntity propEntity : propertyValues) {
            if (propEntity == null || propEntity == EIEntity.NULL_ENTITY) continue;
            widget.add(this.handleReadOnlyTextProperty(propEntity.getLabel()));
        }
        nonOntologyPanel.add((Widget)widget);
    }
}

