/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.institution.server;

import java.io.IOException;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIOntModel;
import org.eaglei.search.datagen.DataGenParams;
import org.eaglei.search.provider.SearchProvider;
import org.eaglei.search.provider.lucene.CompositeLuceneProvider;
import org.eaglei.search.provider.rdf.RDFModelProvider;
import org.eaglei.search.provider.rdf.RepositoryHarvester;
import org.eaglei.services.InstitutionRegistry;
import org.eaglei.services.repository.RepositoryConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportResource;

/*
 * Exception performing whole class analysis ignored.
 */
@Configuration
@ImportResource(value={"classpath:search-common-config.xml"})
@Import(value={RepositoryConfig.class})
public class InstitutionSearchConfig {
    @Autowired
    private EIOntModel eagleiOntModel;
    @Autowired
    private RepositoryHarvester harvester;
    @Autowired
    private InstitutionRegistry registry;

    @Bean
    public SearchProvider rootSearchProvider() {
        try {
            RepositoryHarvester nestedProvider;
            boolean test = InstitutionSearchConfig.isTest();
            if (test) {
                EIEntity institution = this.registry.getInstitution();
                DataGenParams params = DataGenParams.createForOneInstitution((String)institution.getURI().toString(), (String)institution.getLabel());
                params.setMaterializeHierarchy(true);
                nestedProvider = new RDFModelProvider(this.eagleiOntModel, params, institution);
            } else {
                nestedProvider = this.harvester;
            }
            return new CompositeLuceneProvider(this.eagleiOntModel, (SearchProvider)nestedProvider);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean isTest() {
        boolean test = false;
        String testMode = System.getProperty("org.eaglei.search.test");
        if (testMode != null && Boolean.parseBoolean(testMode)) {
            test = true;
        }
        return test;
    }
}

