/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.institution.server;

import java.io.IOException;
import java.util.HashMap;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIOntModel;
import org.eaglei.search.datagen.DataGenParams;
import org.eaglei.search.provider.MultiDataSetSearchProvider;
import org.eaglei.search.provider.SearchProvider;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.search.provider.lucene.CompositeLuceneProvider;
import org.eaglei.search.provider.lucene.DataSetAnalyzer;
import org.eaglei.search.provider.lucene.LuceneSearchProviderIndexer;
import org.eaglei.search.provider.lucene.RepositoryHarvester;
import org.eaglei.search.provider.lucene.suggest.LuceneAutoSuggestConfig;
import org.eaglei.search.provider.ncbi.gene.NCBIGeneSearchProvider;
import org.eaglei.search.provider.ncbi.pubmed.NCBIPubMedSearchProvider;
import org.eaglei.search.provider.nif.NIFSearchProvider;
import org.eaglei.search.provider.rdf.RDFModelProvider;
import org.eaglei.services.InstitutionRegistry;
import org.eaglei.services.repository.RepositoryConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportResource;

/*
 * Exception performing whole class analysis ignored.
 */
@Configuration
@ImportResource(value={"classpath:search-common-config.xml"})
@Import(value={RepositoryConfig.class, LuceneAutoSuggestConfig.class})
public class InstitutionSearchConfig {
    @Autowired
    private EIOntModel eagleiOntModel;
    @Autowired
    private RepositoryHarvester harvester;
    @Autowired
    private InstitutionRegistry registry;
    @Autowired
    private LuceneSearchProviderIndexer indexer;
    @Autowired
    private DataSetAnalyzer modelUsageCache;

    @Bean
    public SearchProvider rootSearchProvider() {
        try {
            RepositoryHarvester nestedProvider;
            boolean test = InstitutionSearchConfig.isTest();
            if (test) {
                EIEntity institution = this.registry.getInstitution();
                DataGenParams params = DataGenParams.createForOneInstitution((String)institution.getURI().toString(), (String)institution.getLabel());
                params.setMaterializeHierarchy(true);
                nestedProvider = new RDFModelProvider(this.eagleiOntModel, params, institution);
            } else {
                nestedProvider = this.harvester;
            }
            HashMap<SearchRequest.DataSet, Object> mapDSToProvider = new HashMap<SearchRequest.DataSet, Object>();
            CompositeLuceneProvider resourceSearchProvider = new CompositeLuceneProvider(this.eagleiOntModel, (SearchProvider)nestedProvider, this.indexer);
            resourceSearchProvider.setModelUsageCache(this.modelUsageCache);
            mapDSToProvider.put(SearchRequest.DataSet.EI_RESOURCES, resourceSearchProvider);
            NIFSearchProvider nifSearchProvider = new NIFSearchProvider(this.eagleiOntModel, this.registry);
            mapDSToProvider.put(SearchRequest.DataSet.NIF_RESOURCES, nifSearchProvider);
            NCBIPubMedSearchProvider pubSearchProvider = new NCBIPubMedSearchProvider(this.eagleiOntModel, this.registry);
            mapDSToProvider.put(SearchRequest.DataSet.PUBS, pubSearchProvider);
            NCBIGeneSearchProvider geneSearchProvider = new NCBIGeneSearchProvider(this.eagleiOntModel, this.registry);
            mapDSToProvider.put(SearchRequest.DataSet.GENES, geneSearchProvider);
            MultiDataSetSearchProvider searchProvider = new MultiDataSetSearchProvider(mapDSToProvider);
            return searchProvider;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean isTest() {
        boolean test = false;
        String testMode = System.getProperty("org.eaglei.search.test");
        if (testMode != null && Boolean.parseBoolean(testMode)) {
            test = true;
        }
        return test;
    }
}

