package org.eaglei.institution.server;

import java.util.HashMap;
import java.util.Map;

import org.eaglei.model.EIOntModel;
import org.eaglei.search.provider.MultiDataSetSearchProvider;
import org.eaglei.search.provider.SearchProvider;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.search.provider.SearchRequest.DataSet;
import org.eaglei.search.provider.ncbi.gene.NCBIGeneSearchProvider;
import org.eaglei.search.provider.ncbi.pubmed.NCBIPubMedSearchProvider;
import org.eaglei.search.provider.nif.NIFSearchProvider;
import org.eaglei.services.InstitutionRegistry;
import org.eaglei.services.repository.RepositoryConfig;
import org.eaglei.solr.search.LuceneSearchConfig;
import org.eaglei.solr.search.LuceneSearchProvider;
import org.eaglei.solr.suggest.LuceneAutoSuggestConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportResource;

@Configuration
@ImportResource("classpath:search-common-config.xml")
@Import({RepositoryConfig.class, LuceneAutoSuggestConfig.class, LuceneSearchConfig.class})
public class InstitutionSearchConfig {

    private @Autowired EIOntModel eagleiOntModel;
    private @Autowired InstitutionRegistry institutionRegistry;
    private @Autowired LuceneSearchProvider searchProvider;

    @Bean
    public SearchProvider rootSearchProvider() {
        Map<SearchRequest.DataSet, SearchProvider> mapDSToProvider = new HashMap<SearchRequest.DataSet, SearchProvider>();
        mapDSToProvider.put(DataSet.EI_RESOURCES, searchProvider);
        NIFSearchProvider nifSearchProvider = new NIFSearchProvider(eagleiOntModel, institutionRegistry);
        mapDSToProvider.put(DataSet.NIF_RESOURCES, nifSearchProvider);
        NCBIPubMedSearchProvider pubSearchProvider = new NCBIPubMedSearchProvider(eagleiOntModel, institutionRegistry);
        mapDSToProvider.put(DataSet.PUBS, pubSearchProvider);
        NCBIGeneSearchProvider geneSearchProvider = new NCBIGeneSearchProvider(eagleiOntModel, institutionRegistry);
        mapDSToProvider.put(DataSet.GENES, geneSearchProvider);
        MultiDataSetSearchProvider searchProvider = new MultiDataSetSearchProvider(mapDSToProvider);
        return searchProvider;
    }

}
