/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.institution.server;

import java.util.HashMap;
import org.eaglei.model.EIOntModel;
import org.eaglei.search.provider.MultiDataSetSearchProvider;
import org.eaglei.search.provider.SearchProvider;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.search.provider.ncbi.gene.NCBIGeneSearchProvider;
import org.eaglei.search.provider.ncbi.pubmed.NCBIPubMedSearchProvider;
import org.eaglei.search.provider.nif.NIFSearchProvider;
import org.eaglei.services.InstitutionRegistry;
import org.eaglei.services.repository.RepositoryConfig;
import org.eaglei.solr.search.LuceneSearchConfig;
import org.eaglei.solr.search.LuceneSearchProvider;
import org.eaglei.solr.suggest.LuceneAutoSuggestConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportResource;

@Configuration
@ImportResource(value={"classpath:search-common-config.xml"})
@Import(value={RepositoryConfig.class, LuceneAutoSuggestConfig.class, LuceneSearchConfig.class})
public class InstitutionSearchConfig {
    @Autowired
    private EIOntModel eagleiOntModel;
    @Autowired
    private InstitutionRegistry institutionRegistry;
    @Autowired
    private LuceneSearchProvider searchProvider;

    @Bean
    public SearchProvider rootSearchProvider() {
        HashMap<SearchRequest.DataSet, Object> mapDSToProvider = new HashMap<SearchRequest.DataSet, Object>();
        mapDSToProvider.put(SearchRequest.DataSet.EI_RESOURCES, this.searchProvider);
        NIFSearchProvider nifSearchProvider = new NIFSearchProvider(this.eagleiOntModel, this.institutionRegistry);
        mapDSToProvider.put(SearchRequest.DataSet.NIF_RESOURCES, nifSearchProvider);
        NCBIPubMedSearchProvider pubSearchProvider = new NCBIPubMedSearchProvider(this.eagleiOntModel, this.institutionRegistry);
        mapDSToProvider.put(SearchRequest.DataSet.PUBS, pubSearchProvider);
        NCBIGeneSearchProvider geneSearchProvider = new NCBIGeneSearchProvider(this.eagleiOntModel, this.institutionRegistry);
        mapDSToProvider.put(SearchRequest.DataSet.GENES, geneSearchProvider);
        MultiDataSetSearchProvider searchProvider = new MultiDataSetSearchProvider(mapDSToProvider);
        return searchProvider;
    }
}

