package org.eaglei.lexical;

import java.io.IOException;
import java.util.List;

/**
 * Interface for classes the implement auto-suggest functionality. Implementations should
 * assume that input text can represent a partially completed word or phrase (e.g. "D" vs
 * "DNA" or "mi" vs "microscope").
 * 
 * @author rfrost
 */
public interface SuggestionProvider {

    /**
     * Retrieves suggestions for the specified request.
     * 
     * @param request The suggestion request.
     * 
     * @return List of generated suggestions in relevance ranked order.
     * 
     * @throws IOException Thrown if an error is encountered generating the suggestions.
     */
    public List<EntityMatch> suggest(EntityMatchRequest request) throws IOException;

}
