/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.lexical.lucene;

import com.hp.hpl.jena.ontology.OntModel;
import java.io.IOException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.eaglei.lexical.EntityExtractionProvider;
import org.eaglei.lexical.lucene.AutoSuggestIndexAnalyzer;
import org.eaglei.lexical.lucene.AutoSuggestQueryAnalyzer;
import org.eaglei.lexical.lucene.EIModelLuceneIndexer;
import org.eaglei.lexical.lucene.LuceneEntityExtractionProvider;
import org.eaglei.lexical.lucene.PorterStemAnalyzer;
import org.eaglei.model.EIOntModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration
public class LuceneConfig {
    @Autowired
    private OntModel jenaOntModel;
    @Autowired
    private EIOntModel eagleiOntModel;

    @Lazy
    @Bean
    public EntityExtractionProvider eagleiModelEntityExtractor() throws IOException {
        RAMDirectory directory = new RAMDirectory();
        PorterStemAnalyzer analyzer = new PorterStemAnalyzer();
        EIModelLuceneIndexer indexer = new EIModelLuceneIndexer(analyzer, (Directory)directory, this.eagleiOntModel, this.jenaOntModel);
        indexer.index();
        return new LuceneEntityExtractionProvider(analyzer, (Directory)directory);
    }

    @Bean
    public EntityExtractionProvider eagleiModelSuggestionProvider() throws IOException {
        RAMDirectory directory = new RAMDirectory();
        AutoSuggestQueryAnalyzer queryAnalyzer = new AutoSuggestQueryAnalyzer();
        AutoSuggestIndexAnalyzer indexAnalyzer = new AutoSuggestIndexAnalyzer();
        EIModelLuceneIndexer indexer = new EIModelLuceneIndexer(indexAnalyzer, (Directory)directory, this.eagleiOntModel, this.jenaOntModel);
        indexer.index();
        return new LuceneEntityExtractionProvider(queryAnalyzer, indexAnalyzer, (Directory)directory);
    }
}

