package org.eaglei.model.gwt.rpc;

import java.util.List;
import java.util.Map;
import java.util.Set;

import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIEquivalentClass;
import org.eaglei.model.EIProperty;
import org.eaglei.model.EIURI;

import com.google.gwt.user.client.rpc.AsyncCallback;


/**
 * The async counterpart of <code>ModelService</code>.
 * 
 * Client code should generally not call this directly.
 * Use ClientModelManager instead.
 */
public interface ModelServiceAsync {
    void getVersion(AsyncCallback<String> callback);
    //void getInstitutions(AsyncCallback<List<EIEntity>> callback);
    void getTopLevelClasses(AsyncCallback<List<EIClass>> callback);
    void getNonResourceBaseClasses(AsyncCallback<List<EIClass>> callback);
    void getClass(EIURI classId, AsyncCallback<EIClass> callback);
    void getSuperClasses(EIURI classId, AsyncCallback<List<EIClass>> callback);
    void getSubClasses(EIURI classId, AsyncCallback<List<EIClass>> callback);
    void getProperties(EIURI classId, AsyncCallback<List<EIProperty>> callback);
    void getEquivalentClasses(EIURI classId, AsyncCallback<List<EIEquivalentClass>> callback);
    void getClassDefinitions(List<EIURI> classURIs, AsyncCallback<List<String>> callback);
    void getPropertyDefinitions(List<EIURI> propertyURIs, AsyncCallback<List<String>> callback);
    void getLabels(EIURI uri, AsyncCallback<List<String>> callback);
    void getClassAnnotations(List<EIURI> classURIs, AsyncCallback<List<Set<String>>> callback);
    //void getPropertyAnnotations(EIURI classURI, AsyncCallback<Map<EIURI,Map<String,String>>> callback);
}
