/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.model.jena;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIOntModel;
import org.eaglei.model.jena.NonResourceVisitor;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class ComputeNonResourceRoots
extends TestCase {
    private static final Log logger = LogFactory.getLog(ComputeNonResourceRoots.class);
    private EIOntModel eagleiOntModel;

    protected void setUp() throws Exception {
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext(new String[]{"jena-model-config.xml"});
        this.eagleiOntModel = (EIOntModel)context.getBean("eagleiOntModel");
    }

    public void testComputeRootNonResources() {
        NonResourceVisitor nonres = new NonResourceVisitor(this.eagleiOntModel);
        ArrayList<NonResourceVisitor> visitors = new ArrayList<NonResourceVisitor>();
        visitors.add(nonres);
        this.eagleiOntModel.traverseDataModel(visitors);
        try {
            File dir = ComputeNonResourceRoots.ensureOutputDirectory("target/output");
            File f = new File(dir, "rootNonResourceList.txt");
            if (f.exists()) {
                f.delete();
            }
            FileWriter fw = new FileWriter(f);
            for (EIClass c : nonres.setNonResource) {
                fw.write(c.getEntity().getURI().toString());
                fw.write(44);
            }
            fw.close();
        }
        catch (IOException e) {
            logger.error((Object)e);
            ComputeNonResourceRoots.assertTrue((boolean)false);
        }
    }

    public static File ensureOutputDirectory(String outputPath) throws IOException {
        if (outputPath == null || outputPath.length() == 0) {
            logger.error((Object)"Empty or null output path");
            return null;
        }
        File outputDir = new File(outputPath);
        logger.info((Object)("Generating test data to directory: " + outputDir.getAbsolutePath()));
        if (!outputDir.exists() && !outputDir.mkdirs()) {
            logger.error((Object)("Failed to create output directory " + outputDir.getAbsolutePath()));
            return null;
        }
        return outputDir;
    }
}

