/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.model.jena;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIOntModel;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class WriteTermLists
extends TestCase {
    private static final Log logger = LogFactory.getLog(WriteTermLists.class);
    private EIOntModel eagleiOntModel;

    protected void setUp() throws Exception {
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext(new String[]{"jena-model-config.xml"});
        this.eagleiOntModel = (EIOntModel)context.getBean("eagleiOntModel");
    }

    public void testWriteTermLists() {
        try {
            File dir = WriteTermLists.ensureOutputDirectory("target/output/termlists");
            List top = this.eagleiOntModel.getTopLevelClasses();
            for (EIClass c : top) {
                File f = new File(dir, c.getEntity().getLabel() + ".txt");
                logger.info((Object)("Writing terms to: " + f.getAbsolutePath()));
                FileWriter fw = new FileWriter(f);
                this.writeTermLabels(this.eagleiOntModel, 0, c, fw);
                fw.close();
            }
            List nonres = this.eagleiOntModel.getNonResourceBaseClasses();
            for (EIClass c : nonres) {
                File f = new File(dir, c.getEntity().getLabel() + ".txt");
                logger.info((Object)("Writing terms to: " + f.getAbsolutePath()));
                FileWriter fw = new FileWriter(f);
                this.writeTermLabels(this.eagleiOntModel, 0, c, fw);
                fw.close();
            }
            logger.info((Object)"Write of term lists complete.");
        }
        catch (IOException e) {
            logger.error((Object)e);
            WriteTermLists.assertTrue((boolean)false);
        }
    }

    private void writeTermLabels(EIOntModel model, int depth, EIClass c, FileWriter fw) throws IOException {
        for (int i = 0; i < depth; ++i) {
            fw.write("  ");
        }
        fw.write(c.getEntity().getLabel());
        fw.write("\r\n");
        if (c.hasSubClass()) {
            List subclasses = model.getSubClasses(c.getEntity().getURI());
            for (EIClass subclass : subclasses) {
                this.writeTermLabels(model, depth + 1, subclass, fw);
            }
        }
    }

    public static File ensureOutputDirectory(String outputPath) throws IOException {
        if (outputPath == null || outputPath.length() == 0) {
            logger.error((Object)"Empty or null output path");
            return null;
        }
        File outputDir = new File(outputPath);
        logger.info((Object)("Generating test data to directory: " + outputDir.getAbsolutePath()));
        if (outputDir.exists() && !outputDir.delete()) {
            logger.error((Object)("Failed to delete output directory " + outputDir.getAbsolutePath()));
        }
        if (!outputDir.mkdirs()) {
            logger.error((Object)("Failed to create output directory " + outputDir.getAbsolutePath()));
            return null;
        }
        return outputDir;
    }
}

