/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.model.jena;

import com.hp.hpl.jena.ontology.AnnotationProperty;
import com.hp.hpl.jena.ontology.ConversionException;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.ontology.UnionClass;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFList;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIDatatypeProperty;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIObjectProperty;
import org.eaglei.model.EIOntModel;
import org.eaglei.model.EIProperty;
import org.eaglei.model.EIURI;
import org.eaglei.model.jena.EagleIOntDocumentManager;
import org.eaglei.model.jena.EagleIOntUtils;

public class JenaEIOntModel
implements EIOntModel {
    protected static final Log logger = LogFactory.getLog(JenaEIOntModel.class);
    public static final JenaEIOntModel INSTANCE = new JenaEIOntModel();
    private final OntModel eagleiModel;
    private final String version;
    private final AnnotationProperty inPropertyGroup;
    private final Resource dataModelExclude;
    private final List<Property> prefLabelProperties = new ArrayList<Property>();
    private final List<Property> labelProperties = new ArrayList<Property>();
    private final HashMap<EIURI, List<EIEntity>> mapClassIdToTypeLabels = new HashMap();
    private final List<OntClass> listTopLevelOntClasses;
    private final Set<String> setTopLevelURIs;
    private final List<EIClass> listTopLevelEIClasses;
    private final Set<String> setNonResourceBaseURIs;
    private final List<EIClass> listNonResourceBaseEIClasses;
    private final HashMap<String, EIClass> mapURIStrToEIClass = new HashMap();

    private JenaEIOntModel() {
        logger.info((Object)"loading ontology...");
        long start = System.currentTimeMillis();
        this.eagleiModel = EagleIOntDocumentManager.INSTANCE.getOntModel();
        this.version = this.eagleiModel.getOntology("http://purl.org/eagle-i/app-ext/").getVersionInfo();
        logger.info((Object)("eagle-i ontology version " + this.version + " loaded:  " + (System.currentTimeMillis() - start) + "msec"));
        this.inPropertyGroup = this.eagleiModel.getAnnotationProperty("http://eagle-i.org/ont/app/1.0/inPropertyGroup");
        this.dataModelExclude = this.eagleiModel.getResource("http://eagle-i.org/ont/app/1.0/PropertyGroup/dataModelExclude");
        Property eiPrefLabel = this.eagleiModel.getProperty("http://eagle-i.org/ont/app/1.0/preferredLabel");
        Property iaoPrefTerm = this.eagleiModel.getProperty("http://purl.obolibrary.org/obo/IAO_0000111");
        Property iaoAltTerm = this.eagleiModel.getProperty("http://purl.obolibrary.org/obo/IAO_0000118");
        this.prefLabelProperties.add(eiPrefLabel);
        this.prefLabelProperties.add(iaoPrefTerm);
        this.prefLabelProperties.add(RDFS.label);
        this.labelProperties.add(eiPrefLabel);
        this.labelProperties.add(iaoPrefTerm);
        this.labelProperties.add(RDFS.label);
        this.labelProperties.add(iaoAltTerm);
        logger.info((Object)"initializing resource class lists...");
        start = System.currentTimeMillis();
        List<List<OntClass>> listClassesInGroup = this.getResourceLists();
        this.listTopLevelOntClasses = listClassesInGroup.get(0);
        this.setTopLevelURIs = new HashSet<String>(this.listTopLevelOntClasses.size());
        TreeMap<String, EIClass> tmClasses = new TreeMap<String, EIClass>();
        for (OntClass ontClass : this.listTopLevelOntClasses) {
            this.setTopLevelURIs.add(ontClass.getURI());
            EIClass eiClass = this.createClass(ontClass);
            tmClasses.put(eiClass.getEntity().getLabel().toLowerCase(), eiClass);
        }
        this.listTopLevelEIClasses = new ArrayList(tmClasses.values());
        List<OntClass> listNonResourceOntClasses = listClassesInGroup.get(1);
        this.listNonResourceBaseEIClasses = new ArrayList<EIClass>(listNonResourceOntClasses.size());
        this.setNonResourceBaseURIs = new HashSet<String>(listNonResourceOntClasses.size());
        for (OntClass ontClass : listNonResourceOntClasses) {
            this.setNonResourceBaseURIs.add(ontClass.getURI());
            EIClass eiClass = this.createClass(ontClass);
            this.listNonResourceBaseEIClasses.add(eiClass);
        }
        logger.info((Object)("resource class lists initialized: " + (System.currentTimeMillis() - start)));
    }

    public String getVersion() {
        return this.version;
    }

    public OntModel getOntModel() {
        return this.eagleiModel;
    }

    private List<List<OntClass>> getResourceLists() {
        ArrayList<List<OntClass>> result = new ArrayList<List<OntClass>>(2);
        List<OntClass> resourceList = EagleIOntUtils.getClassesInGroup("http://eagle-i.org/ont/app/1.0/ClassGroup/resourceRoot");
        if (resourceList != null) {
            result.add(resourceList);
        } else assert (false) : "TODO";
        resourceList = this.getResourceListFromCache("/rootNonResourceList.txt");
        if (resourceList != null) {
            result.add(resourceList);
        } else {
            result.add(new ArrayList());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<OntClass> getResourceListFromCache(String path) {
        ArrayList<OntClass> arrayList;
        InputStream is = this.getClass().getResourceAsStream(path);
        if (is == null) {
            return null;
        }
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader(is));
            String list = br.readLine();
            if (list == null) {
                List<OntClass> list2 = null;
                return list2;
            }
            String[] uriStrings = list.split(",");
            ArrayList<OntClass> listOntClass = new ArrayList<OntClass>(uriStrings.length);
            for (String uri : uriStrings) {
                listOntClass.add(this.getOntologyClass(uri));
            }
            arrayList = listOntClass;
        }
        catch (Exception e) {
            logger.error((Object)e);
            List<OntClass> list = null;
            return list;
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {}
        }
        return arrayList;
    }

    public List<EIEntity> getTypeEntities(EIURI classId) {
        assert (classId != null);
        List<EIEntity> results = this.mapClassIdToTypeLabels.get(classId);
        if (results != null) {
            return results;
        }
        results = new ArrayList<EIEntity>();
        EIClass root = this.getClass(classId);
        this.getTypeLabelsInternal(root, results);
        this.mapClassIdToTypeLabels.put(classId, results);
        return results;
    }

    private void getTypeLabelsInternal(EIClass c, List<EIEntity> results) {
        results.add(c.getEntity());
        if (c.hasSubClass()) {
            List<EIClass> subclasses = this.getSubClasses(c.getEntity().getURI());
            for (EIClass subclass : subclasses) {
                this.getTypeLabelsInternal(subclass, results);
            }
        }
    }

    public List<EIClass> getTopLevelClasses() {
        return this.listTopLevelEIClasses;
    }

    public List<EIClass> getNonResourceBaseClasses() {
        return this.listNonResourceBaseEIClasses;
    }

    public List<EIEntity> getInstitutions() {
        TreeMap<String, EIEntity> mapLabelToEIEntity = new TreeMap<String, EIEntity>();
        Iterator<? extends OntResource> i$ = EagleIOntUtils.getUniversities().iterator();
        while (i$.hasNext()) {
            OntResource o;
            OntResource ontResource = o = i$.next();
            EIURI uri = EIURI.create((String)ontResource.getURI());
            String label = this.getPreferredLabel(uri);
            assert (label != null);
            EIEntity entity = EIEntity.create((EIURI)uri, (String)label);
            mapLabelToEIEntity.put(label, entity);
        }
        ArrayList<EIEntity> institutions = new ArrayList<EIEntity>(mapLabelToEIEntity.values());
        return institutions;
    }

    public EIClass getClass(EIURI uri) {
        assert (uri != null);
        return this.getClass(uri.toString());
    }

    private EIClass getClass(String uri) {
        OntClass ontClass = this.getOntologyClass(uri);
        if (ontClass == null) {
            return null;
        }
        return this.createClass(ontClass);
    }

    private EIClass createClass(OntClass ontClass) {
        assert (ontClass != null);
        EIClass result = this.mapURIStrToEIClass.get(ontClass.getURI());
        if (result != null) {
            return result;
        }
        assert (!ontClass.getURI().equals(OWL.Thing.getURI()));
        assert (!ontClass.getURI().equals(OWL.Nothing.getURI()));
        EIURI uri = EIURI.create((String)ontClass.getURI());
        String label = this.getPreferredLabel(uri);
        boolean hasSuperClass = this.hasSuperClass(ontClass);
        boolean hasSubClass = this.hasSubClass(ontClass);
        boolean hasProperties = this.hasProperty(ontClass);
        boolean isEagleIResource = this.isResource(ontClass);
        EIEntity entity = EIEntity.create((EIURI)uri, (String)label);
        result = new EIClass(entity, hasProperties, hasSubClass, hasSuperClass, isEagleIResource);
        this.mapURIStrToEIClass.put(ontClass.getURI(), result);
        return result;
    }

    private EIProperty createProperty(OntProperty p) {
        EIDatatypeProperty result = null;
        EIURI uri = EIURI.create((String)p.getURI());
        String label = this.getPreferredLabel(uri);
        EIEntity entity = EIEntity.create((EIURI)uri, (String)label);
        if (p.isObjectProperty()) {
            List listRange = p.listRange().toList();
            ArrayList<EIClass> listRangeClasses = new ArrayList<EIClass>();
            for (OntResource rangeOntResource : listRange) {
                OntClass rangeOntClass = (OntClass)rangeOntResource;
                if (rangeOntClass.isUnionClass()) {
                    UnionClass uc = rangeOntClass.asUnionClass();
                    RDFList members = uc.getOperands();
                    for (int i = 0; i < members.size(); ++i) {
                        String rangeURI;
                        RDFNode rangeNode = members.get(i);
                        if (!(rangeNode instanceof Resource) || (rangeURI = ((Resource)rangeNode).getURI()).equals(OWL.Thing.getURI())) continue;
                        EIClass rangeClass = this.getClass(rangeURI);
                        listRangeClasses.add(rangeClass);
                    }
                    continue;
                }
                if (rangeOntClass.getURI().equals(OWL.Thing.getURI())) continue;
                EIClass rangeClass = this.createClass(rangeOntClass);
                listRangeClasses.add(rangeClass);
            }
            if (listRangeClasses.size() > 0) {
                result = new EIObjectProperty(entity, listRangeClasses);
            } else {
                assert (false) : "Unable to determine range for object property " + entity.toString();
                result = new EIDatatypeProperty(entity, null);
            }
        } else if (p.isDatatypeProperty()) {
            String typeLabel = null;
            OntResource rangeResource = p.getRange();
            if (rangeResource != null) {
                typeLabel = rangeResource.getLocalName();
            }
            result = new EIDatatypeProperty(entity, typeLabel);
        }
        return result;
    }

    private boolean hasSuperClass(OntClass ontClass) {
        boolean hasSuperClass = !this.isResourceBaseClass(ontClass) && !this.isNonResourceBaseClass(ontClass);
        return hasSuperClass;
    }

    public EIClass getSuperClass(EIClass eiClass) {
        assert (eiClass != null);
        if (!eiClass.hasSuperClass()) {
            logger.debug((Object)("getSuperClass() called on class for which hasSuperClass() is false: " + eiClass.getEntity().toString()));
            return null;
        }
        EIClass parentEIClass = eiClass.getSuperClass();
        if (parentEIClass != null) {
            return parentEIClass;
        }
        String uri = eiClass.getEntity().getURI().toString();
        if (this.isResourceBaseClass(uri)) {
            return null;
        }
        if (this.isNonResourceBaseClass(uri)) {
            return null;
        }
        OntClass childClass = this.getOntologyClass(uri);
        ExtendedIterator itrSuperClasses = childClass.listSuperClasses(true);
        while (itrSuperClasses.hasNext()) {
            OntClass parentClass = (OntClass)itrSuperClasses.next();
            String parentURI = parentClass.getURI();
            if (parentURI == null || OWL.Thing.getURI().equals(parentURI)) continue;
            parentEIClass = this.getClass(parentClass.getURI());
            eiClass.setSuperClass(parentEIClass);
            return parentEIClass;
        }
        return null;
    }

    private boolean isResource(OntClass ontClass) {
        if (this.isResourceBaseClass(ontClass)) {
            return true;
        }
        for (OntClass c : this.listTopLevelOntClasses) {
            if (!c.hasSubClass((Resource)ontClass)) continue;
            return true;
        }
        return false;
    }

    private boolean isResourceBaseClass(OntClass ontClass) {
        return this.isResourceBaseClass(ontClass.getURI());
    }

    private boolean isResourceBaseClass(String uri) {
        return this.setTopLevelURIs.contains(uri);
    }

    private boolean isNonResourceBaseClass(OntClass ontClass) {
        return this.isNonResourceBaseClass(ontClass.getURI());
    }

    private boolean isNonResourceBaseClass(String uri) {
        return this.setNonResourceBaseURIs.contains(uri);
    }

    private boolean hasSubClass(OntClass ontClass) {
        ExtendedIterator itrSubClasses = ontClass.listSubClasses(true);
        while (itrSubClasses.hasNext()) {
            OntClass childClass = (OntClass)itrSubClasses.next();
            if (childClass == null || childClass.getURI() == null) continue;
            return !childClass.getURI().equals(OWL.Nothing.getURI());
        }
        return false;
    }

    public boolean isSubClass(EIURI ancestorURI, EIURI descendentURI) {
        OntClass ancestorOntClass = this.getOntologyClass(ancestorURI.toString());
        OntClass descendentOntClass = this.getOntologyClass(descendentURI.toString());
        return ancestorOntClass.hasSubClass((Resource)descendentOntClass);
    }

    public List<EIClass> getSubClasses(EIURI classId) {
        EIClass eiClass = this.getClass(classId);
        if (eiClass == null) {
            return Collections.emptyList();
        }
        if (!eiClass.hasSubClass()) {
            logger.debug((Object)("getSubClasses() called on class for which hasSubClass() is false: " + eiClass.getEntity().toString()));
            return new ArrayList<EIClass>();
        }
        List<EIClass> result = eiClass.getSubClasses();
        if (result != null) {
            return result;
        }
        OntClass parentClass = this.getOntologyClass(classId.toString());
        result = this.getSubClasses(parentClass);
        eiClass.setSubClasses(result);
        return result;
    }

    OntClass getOntologyClass(String strURI) {
        return this.eagleiModel.getOntClass(strURI);
    }

    private List<EIClass> getSubClasses(OntClass ontClass) {
        TreeMap<String, EIClass> tmSubClasses = new TreeMap<String, EIClass>();
        ExtendedIterator itrSubClasses = ontClass.listSubClasses(true);
        while (itrSubClasses.hasNext()) {
            OntClass childClass = (OntClass)itrSubClasses.next();
            if (childClass == null || childClass.getURI() == null || childClass.getURI().equals(OWL.Nothing.getURI())) continue;
            EIClass eiChildClass = this.createClass(childClass);
            tmSubClasses.put(eiChildClass.getEntity().getLabel().toLowerCase(), eiChildClass);
        }
        ArrayList<EIClass> listSubClasses = new ArrayList<EIClass>(tmSubClasses.values());
        return listSubClasses;
    }

    private boolean hasProperty(OntClass ontClass) {
        ExtendedIterator itrProperties = ontClass.listDeclaredProperties();
        while (itrProperties.hasNext()) {
            try {
                Object o = itrProperties.next();
                if (!(o instanceof OntProperty) || !((OntProperty)o).isObjectProperty()) continue;
                return true;
            }
            catch (ConversionException ex) {
            }
        }
        return false;
    }

    public List<EIProperty> getProperties(EIURI classId) {
        return this.getProperties(classId, null);
    }

    public List<EIProperty> getProperties(EIURI classId, String groupURI) {
        EIClass eiClass = this.getClass(classId);
        assert (eiClass != null);
        if (!eiClass.hasProperty()) {
            logger.debug((Object)("getProperties() called on class for which hasProperty() is false: " + eiClass.getEntity().toString()));
            return new ArrayList<EIProperty>();
        }
        List<EIProperty> result = eiClass.getProperties();
        if (result != null) {
            return result;
        }
        OntClass parentClass = this.getOntologyClass(classId.toString());
        result = this.getProperties(parentClass, groupURI);
        eiClass.setProperties(result);
        return result;
    }

    private List<EIProperty> getProperties(OntClass ontClass, String groupURI) {
        TreeMap<String, EIProperty> tmProperties = new TreeMap<String, EIProperty>();
        ExtendedIterator itrProperties = ontClass.listDeclaredProperties();
        while (itrProperties.hasNext()) {
            try {
                EIProperty property;
                OntProperty ontProperty;
                Object o = itrProperties.next();
                if (!(o instanceof OntProperty) || (ontProperty = (OntProperty)o).isAnnotationProperty() || ontProperty.hasProperty((Property)this.inPropertyGroup, (RDFNode)this.dataModelExclude) || (property = this.createProperty(ontProperty)) == null) continue;
                tmProperties.put(property.getEntity().getLabel().toLowerCase(), property);
            }
            catch (ConversionException ex) {}
        }
        ArrayList<EIProperty> listProperties = new ArrayList<EIProperty>(tmProperties.values());
        return listProperties;
    }

    public List<String> getClassDefinitions(List<EIURI> classURIs) {
        ArrayList<String> results = new ArrayList<String>(classURIs.size());
        for (EIURI classURI : classURIs) {
            String def = this.getClassDefinition(classURI);
            results.add(def);
        }
        return results;
    }

    public String getClassDefinition(EIURI classURI) {
        OntClass ontClass = this.getOntologyClass(classURI.toString());
        if (ontClass == null) {
            return null;
        }
        String def = null;
        RDFNode defNode = ontClass.getPropertyValue(ontClass.getModel().getProperty("http://purl.obolibrary.org/obo/IAO_0000115"));
        if (defNode != null) {
            def = ((Literal)defNode).getString();
        }
        if (def == null && (defNode = ontClass.getPropertyValue(RDFS.comment)) != null) {
            def = "COMMENT: " + ((Literal)defNode).getString();
        }
        return def;
    }

    public String getPreferredLabel(EIURI uri) {
        assert (uri != null);
        Resource resource = this.eagleiModel.getResource(uri.toString());
        if (resource == null) {
            return null;
        }
        ArrayList<String> labels = new ArrayList<String>();
        for (Property prop : this.prefLabelProperties) {
            JenaEIOntModel.getLiteralsForProperty(resource, prop, labels);
            if (labels.size() <= 0) continue;
            return (String)labels.get(0);
        }
        return null;
    }

    public List<Property> getPrefLabelProperties() {
        return this.prefLabelProperties;
    }

    public List<String> getLabels(EIURI uri) {
        assert (uri != null);
        Resource resource = this.eagleiModel.getResource(uri.toString());
        if (resource == null) {
            return Collections.emptyList();
        }
        ArrayList<String> labels = new ArrayList<String>();
        for (Property prop : this.labelProperties) {
            JenaEIOntModel.getLiteralsForProperty(resource, prop, labels);
        }
        return labels;
    }

    public List<Property> getLabelProperties() {
        return this.labelProperties;
    }

    public static void getLiteralsForProperty(Resource r, Property p, List<String> values) {
        StmtIterator it = r.listProperties(p);
        while (it.hasNext()) {
            String value;
            Statement stmt = (Statement)it.next();
            RDFNode node = stmt.getObject();
            if (!node.isLiteral() || (value = ((Literal)node).getLexicalForm()) == null || (value = value.trim()).isEmpty() || values.contains(value)) continue;
            values.add(value);
        }
    }

    public List<String> getPropertyDefinitions(List<EIURI> propertyURIs) {
        ArrayList<String> results = new ArrayList<String>(propertyURIs.size());
        for (EIURI propertyURI : propertyURIs) {
            String def = this.getClassDefinition(propertyURI);
            results.add(def);
        }
        return results;
    }

    public String getPropertyDefinition(EIURI propertyURI) {
        String def = null;
        assert (false) : "Not yet implemented";
        return def;
    }

    public void traverseDataModel(List<EIOntModel.Visitor> visitors) {
        logger.info((Object)"Start traversal of data model");
        HashSet<EIClass> setChecked = new HashSet<EIClass>();
        ArrayDeque<String> stack = new ArrayDeque<String>();
        for (EIClass top : this.listTopLevelEIClasses) {
            this.traverseDataModel(top, setChecked, stack, visitors);
        }
        logger.info((Object)"Traversal of data model complete");
    }

    private void traverseDataModel(EIClass c, Set<EIClass> setChecked, Deque<String> stack, List<EIOntModel.Visitor> visitors) {
        if (setChecked.contains(c)) {
            return;
        }
        stack.addLast(c.toString());
        for (EIOntModel.Visitor v : visitors) {
            v.visit(c, stack);
        }
        setChecked.add(c);
        if (c.hasProperty()) {
            List<EIProperty> properties = this.getProperties(c.getEntity().getURI());
            for (EIProperty prop : properties) {
                stack.addLast(prop.toString());
                for (EIOntModel.Visitor v : visitors) {
                    v.visit(prop, stack);
                }
                if (prop instanceof EIObjectProperty) {
                    List objPropClassList = ((EIObjectProperty)prop).getRangeList();
                    for (EIClass objPropClass : objPropClassList) {
                        if (objPropClass == null) continue;
                        this.traverseDataModel(objPropClass, setChecked, stack, visitors);
                    }
                }
                stack.removeLast();
            }
        }
        if (c.hasSubClass()) {
            List<EIClass> subclasses = this.getSubClasses(c.getEntity().getURI());
            for (EIClass subclass : subclasses) {
                stack.addLast("SUBCLASS");
                this.traverseDataModel(subclass, setChecked, stack, visitors);
                stack.removeLast();
            }
        }
        stack.removeLast();
    }

    public String generateStackTrace(Deque<String> stack) {
        StringBuilder buf = new StringBuilder();
        for (String item : stack) {
            buf.append(item);
            buf.append("\r\n");
        }
        return buf.toString();
    }
}

