/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.model.jena;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIURI;
import org.eaglei.model.jena.JenaEIInstanceFactory;
import org.junit.Test;

public class JenaEIInstanceFactoryTest
extends TestCase {
    private static final String EI_INSTRUMENT = "http://purl.obolibrary.org/obo/ERO_0000004";
    private static final String RDFS_URI = "http://www.w3.org/2000/01/rdf-schema#";
    private static final Log logger = LogFactory.getLog(JenaEIInstanceFactoryTest.class);
    private final String instanceListFileName = "Boyer Core Laboratory.rdf";
    private final String singleInstanceFileName = "AlaskaEIInstanceTest.rdf";
    private final String sparqlFilename = "sparql-results.xml";
    private final EIURI testURIForSigleInstance = EIURI.create((String)"http://dev.alaska.eagle-i.net/i/INSTANCE_6ceac5c4-cb64-40f3-8451-d877d936430d");
    private static final EIURI EI_INSTRUMENT_URI = EIURI.create((String)"http://purl.obolibrary.org/obo/ERO_0000004");
    private static final String EI_INSTRUMENT_LABEL = "Instrument";
    private static final String RDFS_LABEL = "http://www.w3.org/2000/01/rdf-schema#label";

    public void testCreateEIURIModel() {
    }

    public void testCreateModel() {
        Model model = this.createModelFromFile("Boyer Core Laboratory.rdf");
        List instances = JenaEIInstanceFactory.getInstance().create(model);
        JenaEIInstanceFactoryTest.assertNotNull((Object)instances);
        logger.debug((Object)("Created " + instances.size() + " instances:"));
        JenaEIInstanceFactoryTest.assertEquals((int)7, (int)instances.size());
        for (EIInstance e : instances) {
            JenaEIInstanceFactoryTest.assertNotNull((Object)e);
        }
    }

    @Test
    public void createSingleInstance() {
        Model model = this.createModelFromFile("AlaskaEIInstanceTest.rdf");
        EIInstance instance = JenaEIInstanceFactory.getInstance().create(this.testURIForSigleInstance, model);
        JenaEIInstanceFactoryTest.assertNotNull((String)"EIInstanceFactory#create(final EIURI instanceUri, final Model model) failed to create Instance", (Object)instance);
    }

    @Test
    public void testAllPropertiesCorrectlyCreated() {
        Model model = this.createModelFromFile("AlaskaEIInstanceTest.rdf");
        EIInstance instance = JenaEIInstanceFactory.getInstance().create(this.testURIForSigleInstance, model);
        int propertyCount = this.countProperties(instance);
        JenaEIInstanceFactoryTest.assertEquals((String)("expected 8 properties but got " + propertyCount + " properties"), (int)8, (int)propertyCount);
        EIEntity typeEntity = EIEntity.create((EIURI)EI_INSTRUMENT_URI, (String)EI_INSTRUMENT_LABEL);
        JenaEIInstanceFactoryTest.assertEquals((String)"Instance type is not correctly create", (Object)typeEntity, (Object)instance.getInstanceType());
        JenaEIInstanceFactoryTest.assertEquals((String)"Instance label is not correctly create", (String)"Actiheart 19", (String)instance.getInstanceLabel());
    }

    private int countProperties(EIInstance instance) {
        int propertyCount = this.getCountfromMap(instance.getReadOnlyResourceProperties());
        propertyCount += this.getCountfromMap(instance.getObjectProperties());
        propertyCount += this.getCountfromMap(instance.getDatatypeProperties());
        propertyCount += this.getCountfromMap(instance.getNonOntologyLiteralProperties());
        return propertyCount += this.getCountfromMap(instance.getNonOntologyResourceProperties());
    }

    @Test
    public void testconverToJenaModel() {
        Model expectedModel = this.createModelFromFile("AlaskaEIInstanceTest.rdf");
        EIInstance instance = JenaEIInstanceFactory.getInstance().create(this.testURIForSigleInstance, expectedModel);
        Model modelAfterConvert = JenaEIInstanceFactory.getInstance().convertToJenaModel(instance);
        StmtIterator iter = expectedModel.listStatements();
        while (iter.hasNext()) {
            Statement statement = (Statement)iter.next();
            JenaEIInstanceFactoryTest.assertTrue((boolean)modelAfterConvert.contains(statement));
        }
    }

    @Test
    public void testSerialization() {
        Model expectedModel = this.createModelFromFile("AlaskaEIInstanceTest.rdf");
        EIInstance instance = JenaEIInstanceFactory.getInstance().create(this.testURIForSigleInstance, expectedModel);
        String rdfXmlString = JenaEIInstanceFactory.getInstance().serialize(instance, "RDF/XML");
        Model afterSerialize = ModelFactory.createDefaultModel();
        StringReader reader = new StringReader(rdfXmlString);
        afterSerialize.read((Reader)reader, null, "RDF/XML");
        StmtIterator iter = expectedModel.listStatements();
        while (iter.hasNext()) {
            Statement statement = (Statement)iter.next();
            JenaEIInstanceFactoryTest.assertTrue((boolean)afterSerialize.contains(statement));
        }
    }

    @Test
    public void testcreateEmptyInstance() {
        EIEntity typeEntity = EIEntity.create((EIURI)EI_INSTRUMENT_URI, (String)EI_INSTRUMENT_LABEL);
        EIInstance instance = JenaEIInstanceFactory.getInstance().createEmpty(EI_INSTRUMENT_URI, typeEntity);
        int propertyCount = this.countProperties(instance);
        JenaEIInstanceFactoryTest.assertEquals((String)("expected 0 properties but got " + propertyCount + " properties"), (int)0, (int)propertyCount);
        JenaEIInstanceFactoryTest.assertEquals((String)"Instance type is not correctly create", (Object)typeEntity, (Object)instance.getInstanceType());
        JenaEIInstanceFactoryTest.assertEquals((String)"Instance label is not correctly create", (String)EI_INSTRUMENT_LABEL, (String)instance.getInstanceLabel());
    }

    private String getStringFromInputStream(InputStream in) throws IOException {
        StringWriter writer = new StringWriter();
        IOUtils.copy((InputStream)in, (Writer)writer, (String)"UTF-8");
        return writer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Model createModelFromFile(String fileName) {
        Model model = ModelFactory.createDefaultModel();
        InputStream is = null;
        try {
            is = ClassLoader.getSystemResourceAsStream(fileName);
            logger.debug((Object)("Opening file: " + fileName));
            model.read(is, null);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {}
        }
        return model;
    }

    private int getCountfromMap(Map map) {
        if (map != null) {
            return map.size();
        }
        return 0;
    }
}

