/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.model.jena;

import java.io.InputStream;
import java.util.List;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIOntModel;
import org.eaglei.model.EIURI;
import org.eaglei.model.jena.JenaEIOntModel;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class JenaEIOntModelTest
extends TestCase {
    private static final Log logger = LogFactory.getLog(JenaEIOntModel.class);
    private static final String PIG_URI = "http://purl.org/obo/owl/NCBITaxon#NCBITaxon_10141";
    private static final String INSTRUMENT_URI = "http://purl.obolibrary.org/obo/ERO_0000004";
    private EIOntModel eagleiOntModel;

    protected void setUp() throws Exception {
        InputStream is = ClassLoader.getSystemResource("model-jena-test.properties").openStream();
        System.getProperties().load(is);
        is.close();
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext(new String[]{"jena-model-config.xml"});
        this.eagleiOntModel = (EIOntModel)context.getBean("eagleiOntModel");
    }

    public void testGetClassesWithClassGroupAnnotation() {
        List embeddedClassList = this.eagleiOntModel.getClassesWithClassGroupAnnotation("http://eagle-i.org/ont/app/1.0/ClassGroup_embedded_class");
        for (EIClass eiClass : embeddedClassList) {
            logger.info((Object)("Embedded class " + eiClass.getEntity()));
        }
        JenaEIOntModelTest.assertTrue((embeddedClassList.size() > 0 ? 1 : 0) != 0);
    }

    public void testIsModelClassURI() {
        JenaEIOntModelTest.assertTrue((boolean)this.eagleiOntModel.isModelClassURI(INSTRUMENT_URI));
        JenaEIOntModelTest.assertTrue((boolean)this.eagleiOntModel.isModelClassURI(PIG_URI));
        JenaEIOntModelTest.assertFalse((boolean)this.eagleiOntModel.isModelClassURI("http://www.geneontology.org/formats/oboInOwl#DbXref"));
        JenaEIOntModelTest.assertFalse((boolean)this.eagleiOntModel.isModelClassURI("http://bogus.org/bogosity"));
    }

    public void testGetPreferredLabel() {
        EIURI uri = EIURI.create((String)PIG_URI);
        String prefLabel = this.eagleiOntModel.getPreferredLabel(uri);
        logger.info((Object)("Preferred label for http://purl.org/obo/owl/NCBITaxon#NCBITaxon_10141:" + prefLabel));
        JenaEIOntModelTest.assertTrue((prefLabel != null && !prefLabel.isEmpty() ? 1 : 0) != 0);
    }

    public void testGetPreferredLabelNoValue() {
        String uriString = "http://www.geneontology.org/formats/oboInOwl#DbXref";
        EIURI uri = EIURI.create((String)uriString);
        String prefLabel = this.eagleiOntModel.getPreferredLabel(uri);
        logger.info((Object)("Preferred label for " + uriString + ":" + prefLabel));
        JenaEIOntModelTest.assertTrue((prefLabel == null ? 1 : 0) != 0);
    }

    public void testGetLabels() {
        EIURI uri = EIURI.create((String)PIG_URI);
        List labels = this.eagleiOntModel.getLabels(uri);
        JenaEIOntModelTest.assertTrue((labels != null ? 1 : 0) != 0);
        JenaEIOntModelTest.assertTrue((labels.size() == 2 ? 1 : 0) != 0);
        for (String label : labels) {
            logger.info((Object)("Label for http://purl.org/obo/owl/NCBITaxon#NCBITaxon_10141:" + label));
        }
    }
}

