package org.eaglei.model.jena;

import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.model.EIInstanceFactory;
import org.eaglei.model.EIOntConstants;
import org.eaglei.model.EIOntModel;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.jena.PelletReasonerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

import com.hp.hpl.jena.ontology.OntDocumentManager;
import com.hp.hpl.jena.ontology.OntModel;

@Configuration
public class JenaModelConfig {
    
    private static final Log logger = LogFactory.getLog(JenaModelConfig.class);

    // Static for now, could support user configuration
    static {
        // Configure pellet logging
        if (System.getProperty( "pellet.configuration" ) == null) {
            Properties defaultOptions = new Properties();
            defaultOptions.setProperty("USE_CLASSIFICATION_MONITOR", PelletOptions.MonitorType.NONE.toString());
            defaultOptions.setProperty("IGNORE_UNSUPPORTED_AXIOMS", "true");
            PelletOptions.setOptions(defaultOptions);
        }

        /* TODO support user controlled config
        if (pelletOptions != null) {
            PelletOptions.setOptions(pelletOptions);
        }
        */
        
        Logger logger = LogManager.getLogManager().getLogger("org.mindswap.pellet.jena.graph.loader.DefaultGraphLoader");
        // If logger is non-null assume that it was set via property file
        // and don't override.
        if (logger == null) {
            logger = Logger.getLogger("org.mindswap.pellet.jena.graph.loader.DefaultGraphLoader");
            logger.setLevel(Level.SEVERE);
        }        
    }
    
    private @Autowired OntDocumentManager jenaOntDocumentManager;

    public @Bean OntModel jenaOntModel() {
        long start;      
        logger.info("loading ontology...");
        start = System.currentTimeMillis();
        OntModel model = jenaOntDocumentManager.getOntology(EIOntConstants.EAGLE_I_APP_EXT_URI, PelletReasonerFactory.THE_SPEC);
        logger.info("eagle-i ontology loaded:  " + (System.currentTimeMillis()-start) + "msec");
        return model;
    }

    public @Bean EIOntModel eagleiOntModel() {
        JenaEIOntModel eagleiOntModel = new JenaEIOntModel(jenaOntModel());
        return eagleiOntModel;
    }
    
    public @Bean EIInstanceFactory eagleiInstanceFactory() {
    	JenaEIInstanceFactory eagleiInstanceFactory = new JenaEIInstanceFactory(eagleiOntModel());
    	return eagleiInstanceFactory;
    }
    
}
